/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPCoaExtUpdate
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = Logger.getLogger((String)EPPCoaExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "coa:update";
    public static final String ELM_PUT = "coa:put";
    public static final String ELM_REM = "coa:rem";
    private List putAttrs = null;
    private List remAttrs = null;

    public List getPutAttrs() {
        return this.putAttrs;
    }

    public void setPutAttrs(List aPutAttrs) {
        this.putAttrs = aPutAttrs;
    }

    public List getRemAttrs() {
        return this.remAttrs;
    }

    public void setRemAttrs(List remAttrs) {
        this.remAttrs = remAttrs;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element putElm;
        this.putAttrs = null;
        this.remAttrs = null;
        Element remElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:coa-1.0", ELM_REM);
        if (remElm != null) {
            this.remAttrs = EPPUtil.decodeCompList(remElm, "urn:ietf:params:xml:ns:coa-1.0", "coa:key", EPPCoaExtKey.class);
        }
        if ((putElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:coa-1.0", ELM_PUT)) != null) {
            this.putAttrs = EPPUtil.decodeCompList(putElm, "urn:ietf:params:xml:ns:coa-1.0", "coa:attr", EPPCoaExtAttr.class);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPCoaExtUpdate.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPCoaExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPCoaExtUpdate invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_NAME);
        root.setAttribute("xmlns:coa", "urn:ietf:params:xml:ns:coa-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:coa-1.0 coa-1.0.xsd");
        if (this.hasRemData()) {
            Element rem = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_REM);
            root.appendChild(rem);
            EPPUtil.encodeCompList(aDocument, rem, this.remAttrs);
        }
        if (this.hasPutData()) {
            Element put = aDocument.createElementNS("urn:ietf:params:xml:ns:coa-1.0", ELM_PUT);
            root.appendChild(put);
            EPPUtil.encodeCompList(aDocument, put, this.putAttrs);
        }
        return root;
    }

    private boolean hasRemData() {
        return this.remAttrs != null ? !this.remAttrs.isEmpty() : false;
    }

    private boolean hasPutData() {
        return this.putAttrs != null ? !this.putAttrs.isEmpty() : false;
    }

    private void validateState() throws EPPCodecException {
        if (!this.hasPutData() && !this.hasRemData()) {
            throw new EPPCodecException("EPPCoaExtUpdate contains no attr elements.");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCoaExtUpdate theClone = new EPPCoaExtUpdate();
        if (this.putAttrs != null) {
            for (Object attrObject : this.putAttrs) {
                if (attrObject == null) continue;
                EPPCoaExtAttr attr = (EPPCoaExtAttr)attrObject;
                theClone.appendPutAttr((EPPCoaExtAttr)attr.clone());
            }
        }
        if (this.remAttrs != null) {
            for (Object keyObject : this.remAttrs) {
                if (keyObject == null) continue;
                EPPCoaExtKey key = (EPPCoaExtKey)keyObject;
                theClone.appendRemAttr((EPPCoaExtKey)key.clone());
            }
        }
        return theClone;
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof EPPCoaExtUpdate)) {
            return false;
        }
        EPPCoaExtUpdate theComp = (EPPCoaExtUpdate)aObj;
        if (!EPPUtil.equalLists(this.putAttrs, theComp.putAttrs)) {
            return false;
        }
        return EPPUtil.equalLists(this.remAttrs, theComp.remAttrs);
    }

    public void appendPutAttr(EPPCoaExtAttr aAttr) {
        if (this.putAttrs == null) {
            this.putAttrs = new ArrayList();
        }
        this.putAttrs.add(aAttr);
    }

    public void appendRemAttr(EPPCoaExtKey aKey) {
        if (this.remAttrs == null) {
            this.remAttrs = new ArrayList();
        }
        this.remAttrs.add(aKey);
    }
}

