/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.codestudio.util.GenericPoolManager;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.EPPXMLErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EPPXMLByteArray {
    private static Logger LOG = Logger.getLogger((String)EPPXMLByteArray.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static Logger PACKET_LOG = Logger.getLogger((String)(EPPXMLByteArray.class.getName() + ".packet"), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private GenericPoolManager manager = null;
    private String parserPoolName = null;
    private String transformerPoolName = null;

    public EPPXMLByteArray() {
        this.manager = null;
        this.parserPoolName = null;
        this.transformerPoolName = null;
    }

    public EPPXMLByteArray(String aParserPoolName) {
        this.manager = GenericPoolManager.getInstance();
        this.parserPoolName = aParserPoolName;
        this.transformerPoolName = "EPP_XML_TRANSFORMER_POOL";
    }

    public EPPXMLByteArray(String aParserPoolName, String aTransformerPoolName) {
        this.manager = GenericPoolManager.getInstance();
        this.parserPoolName = aParserPoolName;
        this.transformerPoolName = aTransformerPoolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document decode(byte[] aPacket) throws EPPAssemblerException, EPPException, IOException {
        LOG.debug((Object)"decode(): enter");
        if (aPacket == null) {
            throw new EPPException("decode(): BAD ARGUMENT (aPacket)");
        }
        DocumentBuilder theBuilder = null;
        Document theDoc = null;
        if (this.manager != null && this.manager.getPool(this.parserPoolName) != null) {
            theBuilder = (DocumentBuilder)this.manager.requestObject(this.parserPoolName);
            theBuilder.setErrorHandler(new EPPXMLErrorHandler());
            LOG.debug((Object)("decode(): Parser " + theBuilder + " checked out from pool"));
        } else {
            theBuilder = new EPPSchemaCachingParser();
            theBuilder.setErrorHandler(new EPPXMLErrorHandler());
            LOG.debug((Object)"decode(): Created new EPPSchemaCachingParser");
        }
        if (PACKET_LOG.isDebugEnabled()) {
            PACKET_LOG.debug((Object)("decode() : epp packet [" + new String(aPacket) + "]"));
        }
        try {
            try {
                theDoc = theBuilder.parse(new ByteArrayInputStream(aPacket));
            }
            catch (SAXParseException ex) {
                LOG.debug((Object)(aPacket + "\nline      " + ex.getLineNumber() + "\ncolumn    " + ex.getColumnNumber() + "\nuri       " + ex.getSystemId() + "\nMessage : " + ex.getMessage()), (Throwable)ex);
                throw new EPPAssemblerException("[SAXParseException]\nline      " + ex.getLineNumber() + "\ncolumn    " + ex.getColumnNumber() + "\nuri       " + ex.getSystemId() + "\nMessage : " + ex.getMessage(), EPPAssemblerException.XML);
            }
            catch (SAXException ex) {
                LOG.debug((Object)("decode(): [SAXException]" + aPacket), (Throwable)ex);
                throw new EPPAssemblerException("[SAXException] " + ex, EPPAssemblerException.XML);
            }
        }
        finally {
            if (this.manager != null && this.manager.getPool(this.parserPoolName) != null && theBuilder != null) {
                this.manager.returnObject((Object)theBuilder, this.parserPoolName);
                LOG.debug((Object)("decode(): Parser " + theBuilder + " returned to pool"));
            }
        }
        LOG.debug((Object)"decode(): exit");
        return theDoc;
    }

    public byte[] encode(Document aDoc) throws EPPException {
        LOG.debug((Object)"encode(): enter");
        if (aDoc == null) {
            LOG.debug((Object)"encode(): aDoc == null");
            throw new EPPException("encode(): BAD ARGUMENT (aDoc)");
        }
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        Transformer trans = null;
        try {
            if (this.manager != null && this.manager.getPool(this.transformerPoolName) != null) {
                trans = (Transformer)this.manager.requestObject(this.transformerPoolName);
                LOG.debug((Object)("encode(): Transformer " + trans + " checked out from pool"));
            } else {
                TransformerFactory transFac = TransformerFactory.newInstance();
                trans = transFac.newTransformer();
                LOG.debug((Object)"encode(): Created new Transformer");
            }
            trans.transform(new DOMSource(aDoc.getDocumentElement()), new StreamResult(theBuffer));
            theBuffer.close();
        }
        catch (Exception ex) {
            LOG.debug((Object)("encode() : serialize() :" + ex.getMessage()), (Throwable)ex);
            throw new EPPException("encode: serialize() " + ex.getMessage());
        }
        finally {
            if (this.manager != null && this.manager.getPool(this.transformerPoolName) != null && trans != null) {
                this.manager.returnObject((Object)trans, this.transformerPoolName);
                LOG.debug((Object)("encode(): Transformer " + trans + " returned to pool"));
            }
        }
        if (PACKET_LOG.isDebugEnabled()) {
            PACKET_LOG.debug((Object)("encode() : epp packet [" + theBuffer + "]"));
        }
        byte[] thePacket = theBuffer.toByteArray();
        LOG.debug((Object)"encode(): exit");
        return thePacket;
    }
}

