/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPProxyServer;
import com.verisign.epp.transport.client.EPPProxyServersLocator;
import com.verisign.epp.transport.client.EPPSSLClientSocket;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSSLProxyClientSocket
extends EPPSSLClientSocket {
    private static Logger cat = Logger.getLogger((String)EPPSSLProxyClientSocket.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private List proxyServers;
    private boolean proxyServersRandomize;
    private static EPPProxyServersLocator locator = null;

    public EPPSSLProxyClientSocket() throws EPPConException {
        cat.debug((Object)"EPPSSLProxyClientSocket(): start");
        try {
            if (locator == null) {
                String theProxyServerLocatorProp = EPPEnv.getProxyServerLocator();
                Class<?> locatorClass = Class.forName(theProxyServerLocatorProp);
                if (!EPPProxyServersLocator.class.isAssignableFrom(locatorClass)) {
                    throw new EPPConException(theProxyServerLocatorProp + " does not implement EPPProxyServersLocator");
                }
                locator = (EPPProxyServersLocator)locatorClass.newInstance();
            }
            this.proxyServers = locator.getProxyServers();
            this.proxyServersRandomize = EPPEnv.getProxyServersRandomize();
        }
        catch (Exception ex) {
            cat.error((Object)("Connection Failed Due to : " + ex.getMessage()), (Throwable)ex);
            throw new EPPConException("Connection Failed Due to : " + ex.getMessage());
        }
        if (this.proxyServers.size() == 0) {
            throw new EPPConException("No proxy servers defined by EPP.ProxyServers configuration property");
        }
        cat.debug((Object)"EPPSSLProxyClientSocket(): exit");
    }

    @Override
    public void initialize() throws EPPConException {
        SSLSocket theSSLSocket;
        cat.debug((Object)"initialize(): start");
        if (super.getSslContext() == null) {
            EPPSSLImpl.initialize();
            super.setSslContext(EPPSSLImpl.getEPPSSLContext());
        }
        SSLSocketFactory theSSLSocketFactory = super.getSslContext().getSSLSocketFactory();
        boolean theConnectedToProxy = false;
        ArrayList theProxyList = new ArrayList(this.proxyServers);
        Random theRandom = new Random();
        Socket theSocket = null;
        EPPProxyServer theCurrProxy = null;
        cat.debug((Object)("initialize(): proxy server list size = " + theProxyList.size()));
        block8: while (!theConnectedToProxy && theProxyList.size() != 0) {
            int theCurrProxyIndex = this.proxyServersRandomize ? theRandom.nextInt(theProxyList.size()) : 0;
            cat.debug((Object)("initialize(): proxy server selected index " + theCurrProxyIndex + " of " + theProxyList.size() + " servers"));
            theCurrProxy = (EPPProxyServer)theProxyList.get(theCurrProxyIndex);
            theProxyList.remove(theCurrProxyIndex);
            cat.debug((Object)("initialize(): proxy server = " + theCurrProxy));
            InetSocketAddress theSocketAddress = new InetSocketAddress(theCurrProxy.getServerName(), theCurrProxy.getServerPort());
            theSocket = new Socket();
            try {
                if (super.getClientHostName() != null) {
                    cat.debug((Object)("initialize(): Binding to client address = " + super.getClientHostName()));
                    InetSocketAddress theClientSocketAddress = new InetSocketAddress(super.getClientHostName(), 0);
                    theSocket.bind(theClientSocketAddress);
                }
                cat.debug((Object)("initialize(): Attempting to connect proxy server = " + theCurrProxy));
                theSocket.connect(theSocketAddress, super.getConTimeout());
                theSocket.setSoTimeout(super.getConTimeout());
                OutputStream theStream = theSocket.getOutputStream();
                String theLine = "CONNECT " + super.getHostName() + ":" + super.getPortNumber() + " HTTP/1.1\r\n";
                cat.debug((Object)("Proxy Server Send [" + theLine + "]"));
                theStream.write(theLine.getBytes());
                theLine = "Host: " + super.getHostName() + ":" + super.getPortNumber() + "\r\n";
                cat.debug((Object)("Proxy Server Send [" + theLine + "]"));
                theStream.write(theLine.getBytes());
                theLine = "\r\n";
                cat.debug((Object)("Proxy Server Send [" + theLine + "]"));
                theStream.write(theLine.getBytes());
                theStream.flush();
                BufferedReader theInputStream = new BufferedReader(new InputStreamReader(theSocket.getInputStream()));
                int theLineNum = 1;
                do {
                    theLine = theInputStream.readLine();
                    cat.debug((Object)("Proxy output line [" + theLine + "]"));
                    if (theLineNum == 1) {
                        if (theLine != null && theLine.indexOf("Connection Established") != -1) {
                            theConnectedToProxy = true;
                            cat.info((Object)("Proxy Server " + theCurrProxy + " TCP connection established"));
                        } else {
                            cat.info((Object)("Proxy Server " + theCurrProxy + " TCP connection failed: " + theLine));
                            theSocket.close();
                            continue block8;
                        }
                    }
                    ++theLineNum;
                    if (theLine == null) continue block8;
                } while (theLine.length() != 0);
            }
            catch (IOException ex) {
                cat.info((Object)("Proxy Server " + theCurrProxy + " TCP connection failed: " + ex));
            }
        }
        if (!theConnectedToProxy) {
            cat.error((Object)"All Proxy Server connections failed");
            throw new EPPConException("All Proxy Server connections failed");
        }
        try {
            theSSLSocket = (SSLSocket)theSSLSocketFactory.createSocket(theSocket, super.getHostName(), super.getPortNumber(), true);
        }
        catch (IOException ex) {
            cat.error((Object)("Proxy Server " + theCurrProxy + " failure creating SSLSocket connection to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex));
            throw new EPPConException("Proxy Server " + theCurrProxy + " failure creating SSLSocket connection to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex);
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("EPPSSLClientSocket.initialize(): Supported Protocols = [" + this.getSSLPropertyListString(theSSLSocket.getSupportedProtocols()) + "], Supported Cipher Suites = [" + this.getSSLPropertyListString(theSSLSocket.getSupportedCipherSuites()) + "]"));
        }
        if (super.getSslContext().hasSSLEnabledProtocols()) {
            cat.debug((Object)("EPPSSLClientSocket.initialize(): Enabled Protocols = [" + this.getSSLPropertyListString(super.getSslContext().getSSLEnabledProtocols()) + "]"));
            theSSLSocket.setEnabledProtocols(super.getSslContext().getSSLEnabledProtocols());
        } else {
            cat.debug((Object)"EPPSSLClientSocket.initialize(): Enabled Protocols NOT specified, using providers default");
        }
        if (super.getSslContext().hasSSLEnabledCipherSuites()) {
            cat.debug((Object)("EPPSSLClientSocket.initialize(): Enabled Cipher Suites = [" + this.getSSLPropertyListString(super.getSslContext().getSSLEnabledCipherSuites()) + "]"));
            theSSLSocket.setEnabledCipherSuites(super.getSslContext().getSSLEnabledCipherSuites());
        } else {
            cat.debug((Object)"EPPSSLClientSocket.initialize(): Enabled Cipher Suites NOT specified, using providers default");
        }
        cat.debug((Object)"EPPSSLClientSocket.initialize(): SSL startHandshake");
        try {
            theSSLSocket.startHandshake();
        }
        catch (IOException ex) {
            cat.error((Object)("Proxy Server " + theCurrProxy + " failed with SSL handshake to " + super.getHostName() + ":" + super.getPortNumber()), (Throwable)ex);
            throw new EPPConException("Proxy Server " + theCurrProxy + " failed with SSL handshake to " + super.getHostName() + ":" + super.getPortNumber() + ": " + ex.getMessage());
        }
        try {
            super.setInputStream(theSSLSocket.getInputStream());
            super.setOutputStream(theSSLSocket.getOutputStream());
            super.setSocket(theSSLSocket);
            super.setConnected(true);
        }
        catch (IOException ex) {
            cat.error((Object)("Failed getting streams from SSL socket: " + ex.getMessage()));
            throw new EPPConException("Failed getting streams from SSL socket: " + ex.getMessage());
        }
        cat.debug((Object)"initialize(): exit");
    }

    public static EPPProxyServersLocator getLocator() {
        return locator;
    }

    public static void setLocator(EPPProxyServersLocator aLocator) {
        locator = aLocator;
    }
}

