/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.balance.EPPBalanceInfoCmd;
import com.verisign.epp.codec.balance.EPPBalanceInfoResp;
import com.verisign.epp.codec.balance.EPPCreditThreshold;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPBalanceHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class BalanceHandler
extends EPPBalanceHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = Logger.getLogger((String)BalanceHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doBalanceInfo(EPPEvent aEvent, Object aData) {
        EPPBalanceInfoCmd theMessage = (EPPBalanceInfoCmd)aEvent.getMessage();
        EPPBalanceInfoResp theResponse = new EPPBalanceInfoResp();
        theResponse.setTransId(new EPPTransId(theMessage.getTransId(), svrTransId));
        theResponse.setCreditLimit(new BigDecimal("1000.00"));
        theResponse.setBalance(new BigDecimal("200.00"));
        theResponse.setAvailableCredit(new BigDecimal("800.00"));
        theResponse.setCreditThreshold(new EPPCreditThreshold("FIXED", new BigDecimal("500.00")));
        return new EPPEventResponse(theResponse);
    }
}

