/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpExtRestore
implements EPPCodecComponent {
    public static final String REQUEST = "request";
    public static final String REPORT = "report";
    public static final String ELM_NAME = "rgp:restore";
    private static Logger cat = Logger.getLogger((String)EPPRgpExtRestore.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPRgpExtReport report;
    private String op;

    public EPPRgpExtRestore() {
        this.op = REQUEST;
    }

    public EPPRgpExtRestore(EPPRgpExtReport aReport) {
        this.op = REPORT;
        this.report = aReport;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpExtRestore.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpExtRestore invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtRestore.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        root.setAttribute("op", this.op);
        if (this.op.equals(REPORT)) {
            EPPUtil.encodeComp(aDocument, root, this.report);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.op = aElement.getAttribute("op");
        this.report = (EPPRgpExtReport)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "rgp:report", EPPRgpExtReport.class);
    }

    void validateState() throws EPPCodecException {
        if (this.op == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.op.equals(REPORT) && this.report == null) {
            throw new EPPCodecException("op attribute has value 'report' but no report object is set");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtRestore)) {
            return false;
        }
        EPPRgpExtRestore theComp = (EPPRgpExtRestore)aObject;
        if (this.op == null && theComp.op != null) {
            return false;
        }
        if (!this.op.equals(theComp.op)) {
            return false;
        }
        return !this.op.equals(REPORT) || this.report == null || this.report.equals(theComp.report);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtRestore clone = null;
        clone = (EPPRgpExtRestore)super.clone();
        clone.op = this.op;
        if (this.report != null) {
            clone.report = (EPPRgpExtReport)this.report.clone();
        }
        return clone;
    }

    public EPPRgpExtReport getReport() {
        return this.report;
    }

    public void setReport(EPPRgpExtReport report) {
        this.report = report;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }
}

