/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.reseller;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPResellerCheckResult
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPResellerCheckResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "reseller:cd";
    private static final String ELM_RESELLER_ID = "id";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private String resellerId;
    private boolean available;
    private String reason;
    private String reasonLang;

    public EPPResellerCheckResult() {
    }

    public EPPResellerCheckResult(String aResellerId, boolean aAvailable) {
        this.setResellerId(aResellerId);
        this.setAvailable(aAvailable);
    }

    public EPPResellerCheckResult(String aResellerId, String aReason) {
        this.setResellerId(aResellerId);
        this.setAvailable(false);
        this.setReason(aReason);
    }

    public EPPResellerCheckResult(String aResellerId, String aReason, String aReasonLang) {
        this.setResellerId(aResellerId);
        this.setAvailable(false);
        this.setReason(aReason);
        this.setReasonLang(aReasonLang);
    }

    public String getResellerId() {
        return this.resellerId;
    }

    public void setResellerId(String aResellerId) {
        this.resellerId = aResellerId;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean aAvailable) {
        this.available = aAvailable;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public boolean hasReasonLang() {
        return this.reasonLang != null;
    }

    public String getReasonLang() {
        return this.reasonLang;
    }

    public void setReasonLang(String aReasonLang) {
        this.reasonLang = aReasonLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.resellerId == null) {
            throw new EPPEncodeException("Undefined name in EPPResellerCheckResult");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", ELM_NAME);
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:id");
        theElm.appendChild(aDocument.createTextNode(this.resellerId));
        EPPUtil.encodeBooleanAttr(theElm, ATTR_AVAIL, this.available);
        root.appendChild(theElm);
        if (this.hasReason()) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:reseller-1.0", "reseller:reason");
            if (this.hasReasonLang()) {
                reasonElm.setAttribute(ATTR_LANG, this.reasonLang);
            }
            reasonElm.appendChild(aDocument.createTextNode(this.reason));
            root.appendChild(reasonElm);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theReasonElm;
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_RESELLER_ID);
        if (theNameElm != null) {
            Node textNode = theNameElm.getFirstChild();
            this.resellerId = textNode != null ? textNode.getNodeValue() : null;
            this.available = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_AVAIL);
        }
        if ((theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:reseller-1.0", ELM_REASON)) != null) {
            Node textNode = theReasonElm.getFirstChild();
            if (textNode != null) {
                this.reason = textNode.getNodeValue();
                String theReasonLang = theReasonElm.getAttribute(ATTR_LANG);
                this.reasonLang = theReasonLang != null && !theReasonLang.isEmpty() ? theReasonLang : null;
            } else {
                this.reason = null;
                this.reasonLang = null;
            }
        } else {
            this.reason = null;
            this.reasonLang = null;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPResellerCheckResult clone = (EPPResellerCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPResellerCheckResult)) {
            return false;
        }
        EPPResellerCheckResult other = (EPPResellerCheckResult)aObject;
        if (!EqualityUtil.equals(this.resellerId, other.resellerId)) {
            cat.error((Object)"EPPResellerCheckResult.equals(): resellerId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.available, other.available)) {
            cat.error((Object)"EPPResellerCheckResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPResellerCheckResult.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reasonLang, other.reasonLang)) {
            cat.error((Object)"EPPResellerCheckResult.equals(): reasonLang not equal");
            return false;
        }
        return true;
    }
}

