/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryDS;
import com.verisign.epp.codec.registry.EPPRegistryKey;
import com.verisign.epp.codec.registry.EPPRegistryMaxSig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDNSSEC
implements EPPCodecComponent {
    private static final long serialVersionUID = -8343531131323431532L;
    public static final String ELM_NAME = "registry:dnssec";
    public static final String ELM_URGENT = "registry:urgent";
    private EPPRegistryDS ds = null;
    private EPPRegistryKey key = null;
    private EPPRegistryMaxSig maxSigLife = null;
    private Boolean urgent = Boolean.FALSE;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDNSSEC.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        if (this.ds != null) {
            EPPUtil.encodeComp(aDocument, root, this.ds);
        } else {
            EPPUtil.encodeComp(aDocument, root, this.key);
        }
        EPPUtil.encodeComp(aDocument, root, this.maxSigLife);
        if (this.urgent == null) {
            this.urgent = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.urgent.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_URGENT);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.ds = (EPPRegistryDS)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:dsDataInterface", EPPRegistryDS.class);
        this.key = (EPPRegistryKey)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:keyDataInterface", EPPRegistryKey.class);
        this.maxSigLife = (EPPRegistryMaxSig)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:maxSigLife", EPPRegistryMaxSig.class);
        this.urgent = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_URGENT);
        if (this.urgent == null) {
            this.urgent = Boolean.FALSE;
        }
    }

    void validateState() throws EPPCodecException {
        if (this.ds == null && this.key == null || this.ds != null && this.key != null) {
            throw new EPPCodecException("only one of dsDataInterface or keyDataInterface element is required");
        }
        if (this.maxSigLife == null) {
            throw new EPPCodecException("maxSigLife element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDNSSEC clone = (EPPRegistryDNSSEC)super.clone();
        if (this.ds != null) {
            clone.ds = (EPPRegistryDS)this.ds.clone();
        }
        if (this.key != null) {
            clone.key = (EPPRegistryKey)this.key.clone();
        }
        if (this.maxSigLife != null) {
            clone.maxSigLife = (EPPRegistryMaxSig)this.maxSigLife.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDNSSEC)) {
            return false;
        }
        EPPRegistryDNSSEC theComp = (EPPRegistryDNSSEC)aObject;
        if (!(this.ds != null ? this.ds.equals(theComp.ds) : theComp.ds == null)) {
            return false;
        }
        if (!(this.key != null ? this.key.equals(theComp.key) : theComp.key == null)) {
            return false;
        }
        if (!(this.maxSigLife != null ? this.maxSigLife.equals(theComp.maxSigLife) : theComp.maxSigLife == null)) {
            return false;
        }
        return this.urgent != null ? this.urgent.equals(theComp.urgent) : theComp.urgent == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryDS getDs() {
        return this.ds;
    }

    public void setDs(EPPRegistryDS ds) {
        this.ds = ds;
    }

    public EPPRegistryKey getKey() {
        return this.key;
    }

    public void setKey(EPPRegistryKey key) {
        this.key = key;
    }

    public EPPRegistryMaxSig getMaxSigLife() {
        return this.maxSigLife;
    }

    public void setMaxSigLife(EPPRegistryMaxSig maxSigLife) {
        this.maxSigLife = maxSigLife;
    }

    public Boolean getUrgent() {
        return this.urgent;
    }

    public void setUrgent(Boolean urgent) {
        this.urgent = urgent;
    }
}

