/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.sql.PoolManResultSet;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.SQLUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SQLCache
implements Runnable {
    private Hashtable cache = new Hashtable(1);
    private Hashtable cacheArgs = new Hashtable(1);
    private JDBCPool mypool;
    protected long sleeptime;
    protected int max_size;
    protected Thread cachechecker;

    public SQLCache(JDBCPool jDBCPool) {
        this(jDBCPool, 5, 30);
    }

    public SQLCache(JDBCPool jDBCPool, int n, int n2) {
        this.mypool = jDBCPool;
        this.max_size = n;
        this.sleeptime = n2 * 1000;
        this.cachechecker = new Thread(this);
        this.cachechecker.setDaemon(true);
        this.cachechecker.start();
    }

    public synchronized Hashtable getRawCache() {
        return this.cache;
    }

    public JDBCPool getPool() {
        return this.mypool;
    }

    public void setPool(JDBCPool jDBCPool) {
        this.mypool = jDBCPool;
    }

    public synchronized ResultSet getResult(String string) {
        if (this.cache.containsKey(string = string.toLowerCase())) {
            try {
                this.mypool.debug("Returning a cached ResultSet for query: " + string);
                return ((PoolManResultSet)this.cache.get(string)).cloneSet();
            }
            catch (Exception exception) {
                this.mypool.log("Exception while attempting to return a cached ResultSet for query: " + string + " [query removed from cache]", exception);
                this.removeResult(string);
            }
        }
        return null;
    }

    public boolean removeResult(String string) {
        try {
            this.cache.remove(string.toLowerCase());
            this.cacheArgs.remove(string.toLowerCase());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized boolean cacheResult(String string, ResultSet resultSet) {
        String string2 = string.toLowerCase();
        if (resultSet instanceof PoolManResultSet && string2.startsWith("select") && this.cache.size() < this.max_size) {
            try {
                this.cache.put(string2, ((PoolManResultSet)resultSet).cloneSet());
                this.cacheArgs.put(string2, string);
                this.mypool.debug("Cached ResultSet for query: " + string2);
                return true;
            }
            catch (ClassCastException classCastException) {
                this.mypool.log("Only PoolMan ResultSets (no native sets) can be cached: " + classCastException.getMessage());
            }
        }
        return false;
    }

    public int size() {
        return this.cache.size();
    }

    public int getMaxSize() {
        return this.max_size;
    }

    public synchronized void forceRefresh() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.cacheArgs.get(string);
            try {
                this.removeResult(string);
                SQLUtil.getInstance().doJDBC(this.mypool.getPoolname(), string2, false);
                this.mypool.debug("Refreshed cache for pool " + this.mypool.getPoolname() + ", query: " + string2);
            }
            catch (SQLException sQLException) {
                this.mypool.log("Exception while refreshing cache for pool " + this.mypool.getPoolname(), sQLException);
                this.removeResult(string);
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.sleeptime);
                    this.forceRefresh();
                }
            }
            catch (InterruptedException interruptedException) {
                this.mypool.log("ERROR: Cache Checker Died:");
                continue;
            }
            break;
        }
    }
}

