/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.management.PoolManBootstrap;
import com.codestudio.sql.PoolManDataSource;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolManager;
import com.codestudio.util.PoolMetaData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;

public class SQLManager
extends PoolManager {
    private static SQLManager myself = new SQLManager();
    private String configFile = "poolman.xml";
    static /* synthetic */ Class class$com$codestudio$util$SQLManager;

    public static SQLManager getInstance() {
        return myself;
    }

    public static SQLManager getInstance(String string) {
        if (!string.equals(myself.getConfigFile())) {
            Class clazz = class$com$codestudio$util$SQLManager == null ? (class$com$codestudio$util$SQLManager = SQLManager.class$("com.codestudio.util.SQLManager")) : class$com$codestudio$util$SQLManager;
            synchronized (clazz) {
                if (!string.equals(myself.getConfigFile())) {
                    myself = null;
                    myself = new SQLManager();
                    myself.setConfigFile(string);
                }
            }
        }
        return myself;
    }

    private SQLManager() {
    }

    public JDBCPool createPool(PoolMetaData poolMetaData) {
        JDBCPool jDBCPool = new JDBCPool(poolMetaData);
        this.addPool(poolMetaData.getName(), jDBCPool);
        return jDBCPool;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    private void assertLoaded() {
        block6: {
            try {
                if (this.pools.size() >= 1) break block6;
                Class clazz = class$com$codestudio$util$SQLManager == null ? (class$com$codestudio$util$SQLManager = SQLManager.class$("com.codestudio.util.SQLManager")) : class$com$codestudio$util$SQLManager;
                synchronized (clazz) {
                    if (this.pools.size() < 1) {
                        new PoolManBootstrap(this.configFile);
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Fatal Error while attempting  to Configure PoolMan: " + exception.getMessage() + " " + exception.toString());
            }
        }
    }

    public ObjectPool getPool(String string) {
        this.assertLoaded();
        return super.getPool(string);
    }

    public ObjectPool getPoolByJNDIName(String string) {
        Object object;
        this.assertLoaded();
        Enumeration enumeration = this.pools.elements();
        while (enumeration.hasMoreElements()) {
            object = (JDBCPool)enumeration.nextElement();
            try {
                PoolManDataSource poolManDataSource = (PoolManDataSource)((JDBCPool)object).getDataSource();
                if (!poolManDataSource.getJNDIName().equals(string)) continue;
                return object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = "ERROR: " + string + " does not exist. " + "Please check your " + "poolman.xml";
        throw new NullPointerException((String)object);
    }

    public Enumeration getAllPoolnames() {
        this.assertLoaded();
        return super.getAllPoolnames();
    }

    public void checkCredentials(String string, String string2, String string3) throws SQLException {
        this.assertLoaded();
        JDBCPool jDBCPool = (JDBCPool)this.getPool(string);
        jDBCPool.checkCredentials(string2, string3);
    }

    public Connection requestConnection() throws SQLException {
        this.assertLoaded();
        try {
            JDBCPool jDBCPool = (JDBCPool)this.defaultpool;
            return jDBCPool.requestConnection();
        }
        catch (NullPointerException nullPointerException) {
            throw new SQLException("No default pool! Check your poolman.xml");
        }
    }

    public void returnConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection requestConnection(String string) throws SQLException {
        if (string == null || string.equals("")) {
            return this.requestConnection();
        }
        this.assertLoaded();
        try {
            JDBCPool jDBCPool = (JDBCPool)this.pools.get(string);
            return jDBCPool.requestConnection();
        }
        catch (NullPointerException nullPointerException) {
            throw new SQLException("No pool named " + string + "! Check your poolman.xml" + "\n** DEBUG: If the StackTrace contains an " + "InstanceAlreadyExistsException, then you have " + " encountered a ClassLoader linkage problem. " + " Please email poolman@codestudio.com **");
        }
    }

    public void returnConnection(String string, Connection connection) {
        this.returnConnection(connection);
    }

    public static void closeResources(Statement statement, ResultSet resultSet) {
        SQLManager.closeResultSet(resultSet);
        SQLManager.closeStatement(statement);
    }

    public void collectResources(Statement statement, ResultSet resultSet) {
        SQLManager.closeResources(statement, resultSet);
    }

    public static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

