/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.management;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;

public class ConfigParser
extends HandlerBase {
    private ArrayList dbProps;
    private ArrayList genericProps;
    private Properties adminProps;
    private boolean jmxManagement = false;
    private String currentSet;
    private String currentName;
    private StringBuffer currentValue = new StringBuffer();

    public ConfigParser() {
        this.dbProps = new ArrayList();
        this.genericProps = new ArrayList();
    }

    public ArrayList getDataSourceProperties() {
        return this.dbProps;
    }

    public ArrayList getGenericProperties() {
        return this.genericProps;
    }

    public Properties getAdminProps() {
        return this.adminProps;
    }

    public boolean isManagementJMX() {
        return this.jmxManagement;
    }

    public void startElement(String string, AttributeList attributeList) {
        this.currentValue.delete(0, this.currentValue.length());
        this.currentName = string;
        if (string.toLowerCase().equals("datasource")) {
            this.currentSet = "datasource";
            this.dbProps.add(new Properties());
        } else if (string.toLowerCase().equals("objectpool")) {
            this.currentSet = "generic";
            this.genericProps.add(new Properties());
        } else if (string.toLowerCase().equals("admin-agent")) {
            this.currentSet = "admin-agent";
            this.adminProps = new Properties();
        } else if (string.toLowerCase().equals("management-mode")) {
            this.currentSet = "management-mode";
        } else if (string.equals("poolman") || string.equals("MLET")) {
            this.currentSet = "ignorable";
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.currentValue.append(cArray, n, n2);
    }

    public void endElement(String string) {
        if (this.currentSet.equals("datasource")) {
            Properties properties = (Properties)this.dbProps.get(this.dbProps.size() - 1);
            ((Hashtable)properties).put(string.toLowerCase(), this.currentValue.toString().trim());
        } else if (this.currentSet.equals("generic")) {
            Properties properties = (Properties)this.genericProps.get(this.genericProps.size() - 1);
            ((Hashtable)properties).put(string.toLowerCase(), this.currentValue.toString().trim());
        } else if (this.currentSet.equals("admin-agent")) {
            this.adminProps.setProperty(string.toLowerCase(), this.currentValue.toString().trim());
        } else if (this.currentSet.equals("management-mode") && this.currentValue.toString().toLowerCase().trim().equals("jmx")) {
            this.jmxManagement = true;
        }
    }

    class ConfigElement {
        String name;
        String value;
        String datatype;
        ConfigElement parent;
        ArrayList children;

        ConfigElement(String string, String string2, String string3) {
            this.name = string;
            this.value = string2;
            this.datatype = string3;
            this.parent = null;
            this.children = new ArrayList();
        }

        String getValue() {
            return this.value;
        }

        void setValue(String string) {
            this.value = string;
        }

        boolean hasChildren() {
            return this.children.size() > 0;
        }

        ConfigElement getParent() {
            return this.parent;
        }

        ArrayList getChildren() {
            return this.children;
        }

        void addChild(ConfigElement configElement) {
            this.children.add(configElement);
        }
    }
}

