/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.PreviewFrame;
import de.hunsicker.jalopy.swing.ValidationException;
import de.hunsicker.swing.util.PopupSupport;
import de.hunsicker.util.Helper;
import de.hunsicker.util.ResourceBundleFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class SettingsContainer
extends JPanel {
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.swing.Bundle";
    private static final String EMPTY_STRING = "".intern();
    private static final String FILENAME_PAGE = "page.dat";
    private AbstractSettingsPage _curSettingsPanel;
    private Convention _settings;
    private JLabel _titleLabel;
    private JPanel _settingsPanel;
    private JTree _tree;
    private Map _panels = new HashMap(10);
    private Map _previews = new HashMap();
    private PopupSupport _popupSupport;
    private PreviewFrame _previewFrame;
    private boolean _disposed;
    static /* synthetic */ Class class$de$hunsicker$jalopy$swing$SettingsContainer;

    public SettingsContainer(PreviewFrame previewFrame) {
        this._previewFrame = previewFrame;
        this.initialize();
    }

    public void clearCache() {
        this._panels.clear();
    }

    public void dispose() {
        if (!this._disposed) {
            this.trackPanel();
            this.clearCache();
            this._popupSupport.setEnabled(false);
            this._popupSupport = null;
            this._disposed = true;
        }
    }

    public void updateSettings() throws ValidationException {
        Iterator i = this._panels.values().iterator();
        while (i.hasNext()) {
            AbstractSettingsPage page = (AbstractSettingsPage)i.next();
            page.validateSettings();
            page.updateSettings();
        }
    }

    protected DefaultMutableTreeNode createNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        SettingsNode general = new SettingsNode(new SettingsNodeInfo("general", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_GENERAL"), "de.hunsicker.jalopy.swing.GeneralSettingsPage"));
        SettingsNode printer = new SettingsNode(new SettingsNodeInfo("printer", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_PRINTER"), "de.hunsicker.jalopy.swing.DummyPanel"));
        SettingsNode braces = new SettingsNode(new SettingsNodeInfo("braces", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_BRACES"), "de.hunsicker.jalopy.swing.BracesSettingsPage"));
        SettingsNode header = new SettingsNode(new SettingsNodeInfo("header", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_HEADER"), "de.hunsicker.jalopy.swing.HeaderSettingsPage"));
        SettingsNode footer = new SettingsNode(new SettingsNodeInfo("footer", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_FOOTER"), "de.hunsicker.jalopy.swing.FooterSettingsPage"));
        SettingsNode imports = new SettingsNode(new SettingsNodeInfo("imports", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_IMPORTS"), "de.hunsicker.jalopy.swing.ImportsSettingsPage"));
        SettingsNode indentation = new SettingsNode(new SettingsNodeInfo("indentation", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_INDENTATION"), "de.hunsicker.jalopy.swing.IndentationSettingsPage"));
        SettingsNode separation = new SettingsNode(new SettingsNodeInfo("separation", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_BLANK_LINES"), "de.hunsicker.jalopy.swing.BlankLinesSettingsPage"));
        SettingsNode javadoc = new SettingsNode(new SettingsNodeInfo("javadoc", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_JAVADOC"), "de.hunsicker.jalopy.swing.JavadocSettingsPage"));
        SettingsNode messages = new SettingsNode(new SettingsNodeInfo("messages", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_MESSAGES"), "de.hunsicker.jalopy.swing.MessagesSettingsPage"));
        SettingsNode whitespace = new SettingsNode(new SettingsNodeInfo("whitespace", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_WHITESPACE"), "de.hunsicker.jalopy.swing.WhitespaceSettingsPage"));
        SettingsNode wrapping = new SettingsNode(new SettingsNodeInfo("wrapping", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_WRAPPING"), "de.hunsicker.jalopy.swing.WrappingSettingsPage"));
        SettingsNode comments = new SettingsNode(new SettingsNodeInfo("comments", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_COMMENTS"), "de.hunsicker.jalopy.swing.CommentsSettingsPage"));
        SettingsNode sort = new SettingsNode(new SettingsNodeInfo("sorting", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_SORTING"), "de.hunsicker.jalopy.swing.SortingSettingsPage"));
        SettingsNode misc = new SettingsNode(new SettingsNodeInfo("misc", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_MISC"), "de.hunsicker.jalopy.swing.MiscSettingsPage"));
        SettingsNode environment = new SettingsNode(new SettingsNodeInfo("environment", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_ENVIRONMENT"), "de.hunsicker.jalopy.swing.EnvironmentSettingsPage"));
        SettingsNode inspector = new SettingsNode(new SettingsNodeInfo("inspector", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_INSPECTOR"), "de.hunsicker.jalopy.swing.CodeInspectorSettingsPage"));
        SettingsNode naming = new SettingsNode(new SettingsNodeInfo("naming", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_NAMING"), "de.hunsicker.jalopy.swing.NamingSettingsPage"));
        SettingsNode projects = new SettingsNode(new SettingsNodeInfo("projects", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_PROJECTS"), "de.hunsicker.jalopy.swing.ProjectSettingsPage"));
        root.add(general);
        root.add(projects);
        root.add(printer);
        printer.add(braces);
        printer.add(whitespace);
        printer.add(indentation);
        printer.add(wrapping);
        printer.add(separation);
        printer.add(comments);
        printer.add(imports);
        printer.add(environment);
        printer.add(javadoc);
        printer.add(header);
        printer.add(footer);
        printer.add(sort);
        printer.add(misc);
        root.add(inspector);
        inspector.add(naming);
        root.add(messages);
        return root;
    }

    AbstractSettingsPage getCurrentPage() {
        return this._curSettingsPanel;
    }

    PreviewFrame getPreview() {
        return this._previewFrame;
    }

    void displayPreview() {
        this.displayPreview((SettingsNode)this._tree.getLastSelectedPathComponent());
    }

    void displayPreview(SettingsNode node) {
        if (this._previewFrame != null && node != null) {
            if (!((DefaultMutableTreeNode)node.getParent()).isRoot()) {
                if (this._previewFrame.customFile) {
                    if (!this._previewFrame.isVisible()) {
                        this._previewFrame.setVisible(true);
                    }
                } else {
                    SettingsNode parent = (SettingsNode)node.getParent();
                    if (parent.getInfo().key.equals("printer")) {
                        this._previewFrame.setCurrentPage(this._curSettingsPanel);
                        String text = this.loadPreview(this._curSettingsPanel.getPreviewFileName());
                        if (text != null) {
                            this._previewFrame.setText(text);
                            if (!this._previewFrame.isVisible()) {
                                this._previewFrame.setVisible(true);
                            }
                        } else {
                            this._previewFrame.setText(EMPTY_STRING);
                        }
                    } else if (!EMPTY_STRING.equals(this._previewFrame.getText())) {
                        this._previewFrame.setText(EMPTY_STRING);
                    }
                }
            } else if (this._previewFrame.isVisible() && !EMPTY_STRING.equals(this._previewFrame.getText())) {
                this._previewFrame.setText(EMPTY_STRING);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadPreview(String name) {
        block41: {
            block40: {
                block32: {
                    block39: {
                        block38: {
                            if (this._previewFrame.customFile) {
                                return null;
                            }
                            if (this._previews.containsKey(name)) {
                                return (String)this._previews.get(name);
                            }
                            in = null;
                            s = null;
                            out = null;
                            try {
                                try {
                                    s = this.getClass().getResourceAsStream("resources/" + name + ".java.tpl");
                                    if (s == null) break block32;
                                    in = new InputStreamReader(s);
                                    buf = new char[1024];
                                    buffer = new CharArrayWriter(1000);
                                    out = new BufferedWriter(buffer);
                                    i = 0;
                                    len = 0;
                                    while (true) {
                                        if ((len = in.read(buf, 0, 1024)) == -1) {
                                            out.flush();
                                            contents = buffer.toString();
                                            this._previews.put(name, contents);
                                            var10_11 = contents;
                                            var12_12 = null;
                                            break;
                                        }
                                        out.write(buf, 0, len);
                                        ++i;
                                    }
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                    var12_14 = null;
                                    try {
                                        if (s != null) {
                                            s.close();
                                        }
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                    try {
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                    try {
                                        if (out == null) return SettingsContainer.EMPTY_STRING;
                                        out.close();
                                        return SettingsContainer.EMPTY_STRING;
                                    }
                                    catch (IOException ignored) {
                                        return SettingsContainer.EMPTY_STRING;
                                    }
                                }
                            }
                            catch (Throwable var11_20) {
                                block37: {
                                    block36: {
                                        var12_15 = null;
                                        ** try [egrp 2[TRYBLOCK] [2 : 224->235)] { 
lbl59:
                                        // 1 sources

                                        if (s != null) {
                                            s.close();
                                        }
                                        break block36;
lbl62:
                                        // 1 sources

                                        catch (IOException ignored) {
                                            // empty catch block
                                        }
                                    }
                                    ** try [egrp 3[TRYBLOCK] [3 : 237->248)] { 
lbl66:
                                    // 1 sources

                                    if (in != null) {
                                        in.close();
                                    }
                                    break block37;
lbl69:
                                    // 1 sources

                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                }
                                ** try [egrp 4[TRYBLOCK] [4 : 250->263)] { 
lbl73:
                                // 1 sources

                                if (out == null) throw var11_20;
                                out.close();
                                throw var11_20;
lbl76:
                                // 1 sources

                                catch (IOException ignored) {
                                    // empty catch block
                                }
                                throw var11_20;
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 224->235)] { 
lbl81:
                            // 1 sources

                            if (s != null) {
                                s.close();
                            }
                            break block38;
lbl84:
                            // 1 sources

                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 237->248)] { 
lbl88:
                        // 1 sources

                        if (in != null) {
                            in.close();
                        }
                        break block39;
lbl91:
                        // 1 sources

                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [4 : 250->263)] { 
lbl95:
                    // 1 sources

                    if (out == null) return var10_11;
                    out.close();
                    return var10_11;
lbl98:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return var10_11;
                }
                var12_13 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 224->235)] { 
lbl104:
                // 1 sources

                if (s != null) {
                    s.close();
                }
                break block40;
lbl107:
                // 1 sources

                catch (IOException ignored) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 237->248)] { 
lbl111:
            // 1 sources

            if (in != null) {
                in.close();
            }
            break block41;
lbl114:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
        }
        try {}
        catch (IOException ignored) {}
        if (out == null) return SettingsContainer.EMPTY_STRING;
        out.close();
        return SettingsContainer.EMPTY_STRING;
        return SettingsContainer.EMPTY_STRING;
    }

    private SettingsNodeInfo getLast() {
        File file = new File(Convention.getProjectSettingsDirectory(), FILENAME_PAGE);
        if (file.exists() && file.isFile()) {
            try {
                return (SettingsNodeInfo)IoHelper.deserialize(file);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new SettingsNodeInfo("general", ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("LBL_GENERAL"), "de.hunsicker.jalopy.swing.GeneralSettingsPage");
    }

    private String getTitle(DefaultMutableTreeNode node) {
        TreeNode[] path = node.getPath();
        StringBuffer buf = new StringBuffer(30);
        int i = 0;
        while (i < path.length) {
            if (path[i].getParent() != null) {
                buf.append(path[i]);
                buf.append(" \u00b7 ");
            }
            ++i;
        }
        buf.setLength(buf.length() - 3);
        return buf.toString();
    }

    private void initialize() {
        this._settings = Convention.getInstance();
        ArrayList<String> supported = new ArrayList<String>(3);
        supported.add("javax.");
        supported.add("de.hunsicker.");
        this._popupSupport = new PopupSupport(supported);
        JPanel spacer = new JPanel();
        Dimension space = new Dimension(5, 5);
        spacer.setMaximumSize(space);
        spacer.setMinimumSize(space);
        spacer.setPreferredSize(space);
        SettingsNodeInfo info = this.getLast();
        this._titleLabel = new JLabel(info.title);
        this._titleLabel.setFont(new Font(this._titleLabel.getFont().getName(), 1, this._titleLabel.getFont().getSize()));
        this._titleLabel.setBackground(Color.white);
        this._titleLabel.setForeground(Color.black);
        JPanel titlePanel = new JPanel();
        titlePanel.add(this._titleLabel);
        titlePanel.setLayout(new FlowLayout(0));
        titlePanel.setBackground(Color.white);
        titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.white), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(132, 130, 132))));
        this._curSettingsPanel = this.loadPanel(info);
        this._panels.put(info.key, this._curSettingsPanel);
        this._settingsPanel = new JPanel();
        this._settingsPanel.setLayout(new BorderLayout());
        this._settingsPanel.add((Component)titlePanel, "North");
        this._settingsPanel.add((Component)this._curSettingsPanel, "Center");
        DefaultMutableTreeNode root = this.createNodes();
        this._tree = new JTree(root);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        this._tree.setBorder(BorderFactory.createCompoundBorder(this._tree.getBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 5)));
        DefaultTreeCellRenderer r = (DefaultTreeCellRenderer)this._tree.getCellRenderer();
        r.setClosedIcon(null);
        r.setOpenIcon(null);
        r.setLeafIcon(null);
        Enumeration<TreeNode> childs = root.preorderEnumeration();
        while (childs.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childs.nextElement();
            TreePath path = new TreePath(node.getPath());
            this._tree.expandPath(path);
            if (!node.getUserObject().equals(info.title)) continue;
            this._tree.setSelectionPath(path);
            this._titleLabel.setText(this.getTitle(node));
        }
        JScrollPane treeView = new JScrollPane();
        treeView.setPreferredSize(new Dimension(130, 400));
        treeView.getViewport().add((Component)this._tree, null);
        this._tree.addTreeSelectionListener(new TreeSelectionHandler());
        JPanel propertyView = new JPanel();
        propertyView.setLayout(new BorderLayout());
        propertyView.setPreferredSize(new Dimension(430, 450));
        propertyView.add((Component)spacer, "West");
        propertyView.add((Component)this._settingsPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)treeView, "West");
        this.add((Component)propertyView, "Center");
    }

    private AbstractSettingsPage loadPanel(SettingsNodeInfo info) {
        try {
            Class[] params = new Class[]{class$de$hunsicker$jalopy$swing$SettingsContainer == null ? (class$de$hunsicker$jalopy$swing$SettingsContainer = SettingsContainer.class$("de.hunsicker.jalopy.swing.SettingsContainer")) : class$de$hunsicker$jalopy$swing$SettingsContainer};
            Constructor c = info.getPanelClass().getDeclaredConstructor(params);
            Object[] args = new Object[]{this};
            AbstractSettingsPage panel = (AbstractSettingsPage)c.newInstance(args);
            panel.setTitle(info.title);
            panel.setCategory(info.key);
            return panel;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void trackPanel() {
        File directory = Convention.getProjectSettingsDirectory();
        File file = new File(directory, FILENAME_PAGE);
        if (IoHelper.ensureDirectoryExists(directory)) {
            try {
                SettingsNodeInfo info = new SettingsNodeInfo(this._curSettingsPanel.getCategory(), this._curSettingsPanel.getTitle(), this._curSettingsPanel.getClass().getName());
                IoHelper.serialize((Object)info, file);
            }
            catch (IOException ex) {
                file.delete();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        boolean armed = true;

        private TreeSelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent ev) {
            if (this.armed) {
                SettingsNode node = (SettingsNode)SettingsContainer.this._tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                try {
                    SettingsContainer.this._curSettingsPanel.validateSettings();
                }
                catch (ValidationException ex) {
                    this.armed = false;
                    SettingsContainer.this._tree.setSelectionPath(ev.getOldLeadSelectionPath());
                    return;
                }
                String title = SettingsContainer.this.getTitle(node);
                SettingsContainer.this._titleLabel.setText(title);
                SettingsContainer.this._settingsPanel.remove(SettingsContainer.this._curSettingsPanel);
                SettingsNodeInfo info = node.getInfo();
                if (SettingsContainer.this._panels.containsKey(info.key)) {
                    SettingsContainer.this._curSettingsPanel = (AbstractSettingsPage)SettingsContainer.this._panels.get(info.key);
                } else {
                    SettingsContainer.this._curSettingsPanel = SettingsContainer.this.loadPanel(info);
                    SettingsContainer.this._panels.put(info.key, SettingsContainer.this._curSettingsPanel);
                }
                SettingsContainer.this.displayPreview(node);
                SettingsContainer.this._settingsPanel.add((Component)SettingsContainer.this._curSettingsPanel, "Center");
                SettingsContainer.this._settingsPanel.repaint();
            } else {
                this.armed = true;
            }
        }
    }

    private static class SettingsNodeInfo
    implements Serializable {
        static final long serialVersionUID = 4496045479306791488L;
        transient Class panelClass;
        String className;
        String key;
        String title;
        int hashCode;
        static /* synthetic */ Class class$de$hunsicker$jalopy$swing$GeneralSettingsPage;

        public SettingsNodeInfo(String key, String title, String className) {
            this.key = key;
            this.className = className;
            this.title = title;
            this.hashCode = title.hashCode();
        }

        public Class getPanelClass() {
            if (this.panelClass == null) {
                try {
                    this.panelClass = Helper.loadClass(this.className, this);
                }
                catch (ClassNotFoundException ex) {
                    this.panelClass = class$de$hunsicker$jalopy$swing$GeneralSettingsPage == null ? (class$de$hunsicker$jalopy$swing$GeneralSettingsPage = SettingsNodeInfo.class$("de.hunsicker.jalopy.swing.GeneralSettingsPage")) : class$de$hunsicker$jalopy$swing$GeneralSettingsPage;
                }
            }
            return this.panelClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof String) {
                return this.title.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.title;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class SettingsNode
    extends DefaultMutableTreeNode {
        public SettingsNode(Object userObj) {
            super(userObj);
        }

        public SettingsNodeInfo getInfo() {
            return (SettingsNodeInfo)this.getUserObject();
        }
    }
}

