/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.sql.PoolManResultSetMetaData;
import com.codestudio.sql.PoolManStatement;
import com.codestudio.sql.Result;
import com.codestudio.util.JDBCPool;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class PoolManResultSet
implements ResultSet {
    private Statement statement;
    private ArrayList rowlist;
    private int pos;
    private int lastColIndex;
    private int scrollableType = 1003;
    private int concurType = 1007;
    private int fetchDirection = 1002;
    private int fetchSize = 1;
    private ResultSetMetaData metaData;
    private ArrayList updatedResults;
    private ArrayList updatedIndexes;
    private ArrayList insertRow;
    private boolean onInsertRow = false;
    private ArrayList insertedIndexes;
    private boolean closed = false;

    public PoolManResultSet() {
    }

    public PoolManResultSet(Statement statement, ArrayList arrayList, ResultSetMetaData resultSetMetaData, int n, int n2) throws SQLException {
        this.pos = 0;
        this.statement = statement;
        this.rowlist = arrayList;
        this.metaData = PoolManResultSetMetaData.getCopy(resultSetMetaData);
        this.scrollableType = n;
        this.concurType = n2;
        this.updatedResults = new ArrayList();
        this.composeInsertRow();
        this.updatedIndexes = new ArrayList();
        this.insertedIndexes = new ArrayList();
    }

    public void setScrollableType(int n) {
        this.scrollableType = n;
    }

    public void setConcurrencyType(int n) {
        this.concurType = n;
    }

    public ResultSet cloneSet() {
        try {
            PoolManResultSet poolManResultSet = new PoolManResultSet(this.statement, this.rowlist, this.metaData, this.scrollableType, this.concurType);
            return poolManResultSet;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public boolean absolute(int n) throws SQLException {
        this.clearUpdates();
        if (n == 0) {
            throw new SQLException("Invalid Row Number 0");
        }
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for this ResultSet type");
        }
        if (n < 0) {
            if (Math.abs(n) > this.rowlist.size()) {
                this.beforeFirst();
                return false;
            }
            this.pos = this.rowlist.size() + n + 1;
            return true;
        }
        if (n > this.rowlist.size()) {
            this.afterLast();
            return false;
        }
        this.pos = n;
        return true;
    }

    public void afterLast() throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Illegal Operation when ResultSet is TYPE_FORWARD_ONLY");
        }
        this.clearUpdates();
        this.pos = this.rowlist.size() + 1;
    }

    public void beforeFirst() throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Illegal Operation when ResultSet is TYPE_FORWARD_ONLY");
        }
        this.clearUpdates();
        this.pos = 0;
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.concurType == 1007) {
            throw new SQLException("Illegal Operation when ResultSet is CONCUR_READ_ONLY");
        }
        this.clearUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.assertNotInserting();
    }

    public void close() throws SQLException {
        this.assertNotInserting();
        this.updatedResults = null;
        this.insertRow = null;
        this.rowlist = null;
        ((PoolManStatement)this.statement).removeOpenResultSet(this);
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void deleteRow() throws SQLException {
        Serializable serializable;
        ArrayList arrayList;
        if (this.pos > this.rowlist.size()) {
            throw new SQLException("Illegal Operation, cursor is after the last row");
        }
        if (this.pos < 1) {
            throw new SQLException("Illegal Operation, cursor is before the first row");
        }
        this.assertNotInserting();
        ArrayList arrayList2 = this.rowlist;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.rowlist.get(this.pos - 1);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>(1);
        int n = 0;
        while (n < arrayList.size()) {
            serializable = (Result)arrayList.get(n);
            if (!arrayList3.contains(((Result)serializable).tableName)) {
                String string = ((Result)serializable).colValue instanceof String ? "DELETE FROM " + ((Result)serializable).tableName + " WHERE " + ((Result)serializable).colName + " = '" + ((Result)serializable).colValue.toString() + "'" : "DELETE FROM " + ((Result)serializable).tableName + " WHERE " + ((Result)serializable).colName + " = " + ((Result)serializable).colValue.toString();
                PoolManStatement poolManStatement = (PoolManStatement)this.statement;
                Connection connection = poolManStatement.getConnection();
                Statement statement = connection.createStatement();
                statement.execute(string);
                arrayList3.add(((Result)serializable).tableName);
            }
            ++n;
        }
        serializable = this.rowlist;
        synchronized (serializable) {
            this.rowlist.set(this.pos - 1, null);
            arrayList = null;
        }
    }

    public int findColumn(String string) throws SQLException {
        try {
            ArrayList arrayList = (ArrayList)this.rowlist.get(0);
            int n = 0;
            while (n < arrayList.size()) {
                Result result = (Result)arrayList.get(n);
                if (result.colName.equalsIgnoreCase(string)) {
                    return 1 + n;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("COLUMN NAME INVALID: " + string);
    }

    public boolean first() throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for this ResultSet type TYPE_FORWARD_ONLY");
        }
        this.clearUpdates();
        this.pos = 1;
        return true;
    }

    public Array getArray(int n) throws SQLException {
        try {
            return (Array)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Array getArray(String string) throws SQLException {
        try {
            return (Array)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            return (InputStream)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        try {
            return (InputStream)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            return (BigDecimal)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            return (BigDecimal)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            return (BigDecimal)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        try {
            return (BigDecimal)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            return (InputStream)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            return (InputStream)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Blob getBlob(int n) throws SQLException {
        try {
            return (Blob)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        try {
            return (Blob)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        try {
            Boolean bl = (Boolean)this.getObject(n);
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        try {
            Boolean bl = (Boolean)this.getObject(string);
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public byte getByte(int n) throws SQLException {
        try {
            Byte by = (Byte)this.getObject(n);
            return by;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public byte getByte(String string) throws SQLException {
        try {
            Byte by = (Byte)this.getObject(string);
            return by;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            try {
                return (byte[])this.getObject(n);
            }
            catch (ClassCastException classCastException) {
                return ((String)this.getObject(n)).getBytes();
            }
        }
        catch (NullPointerException nullPointerException) {
            return new byte[]{-1};
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        try {
            try {
                return (byte[])this.getObject(string);
            }
            catch (ClassCastException classCastException) {
                return ((String)this.getObject(string)).getBytes();
            }
        }
        catch (NullPointerException nullPointerException) {
            return new byte[]{-1};
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            return (Reader)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        try {
            return (Reader)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Clob getClob(int n) throws SQLException {
        try {
            return (Clob)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Clob getClob(String string) throws SQLException {
        try {
            return (Clob)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getConcurrency() throws SQLException {
        return this.concurType;
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("The PoolMan Library Does Not Support Named Cursors");
    }

    public Date getDate(int n) throws SQLException {
        try {
            if (this.getObject(n) instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.getObject(n);
                return new Date(((java.util.Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000));
            }
            return (Date)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            Date date = this.getDate(n);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date2 = dateFormat.parse(date.toString());
            return new Date(date2.getTime());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public Date getDate(String string) throws SQLException {
        try {
            if (this.getObject(string) instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.getObject(string);
                return new Date(((java.util.Date)timestamp).getTime() + (long)(timestamp.getNanos() / 1000000));
            }
            return (Date)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            Date date = this.getDate(string);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date2 = dateFormat.parse(date.toString());
            return new Date(date2.getTime());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public double getDouble(int n) throws SQLException {
        try {
            Number number = (Number)this.getObject(n);
            return number.doubleValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
    }

    public double getDouble(String string) throws SQLException {
        try {
            Number number = (Number)this.getObject(string);
            return number.doubleValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0.0;
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public float getFloat(int n) throws SQLException {
        try {
            Number number = (Number)this.getObject(n);
            return number.floatValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0.0f;
        }
    }

    public float getFloat(String string) throws SQLException {
        try {
            Number number = (Number)this.getObject(string);
            return number.floatValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0.0f;
        }
    }

    public int getInt(int n) throws SQLException {
        try {
            Number number = (Number)this.getObject(n);
            return number.intValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public int getInt(String string) throws SQLException {
        try {
            Number number = (Number)this.getObject(string);
            return number.intValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        try {
            Number number = (Number)this.getObject(n);
            return number.longValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0L;
        }
    }

    public long getLong(String string) throws SQLException {
        try {
            Number number = (Number)this.getObject(string);
            return number.longValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0L;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return PoolManResultSetMetaData.getCopy(this.metaData);
    }

    public Object getObject(int n) throws SQLException {
        this.lastColIndex = n;
        ArrayList arrayList = (ArrayList)this.rowlist.get(this.pos - 1);
        try {
            Result result = (Result)arrayList.get(n - 1);
            return result.colValue;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedOperationException("PoolMan does not support custom UDT mapping");
    }

    public Object getObject(String string) throws SQLException {
        ArrayList arrayList = (ArrayList)this.rowlist.get(this.pos - 1);
        try {
            int n = 0;
            while (n < arrayList.size()) {
                Result result = (Result)arrayList.get(n);
                if (result.colName.equalsIgnoreCase(string)) {
                    this.lastColIndex = n + 1;
                    return result.colValue;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Ref getRef(int n) throws SQLException {
        try {
            return (Ref)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Ref getRef(String string) throws SQLException {
        try {
            return (Ref)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getRow() throws SQLException {
        if (this.pos > this.rowlist.size()) {
            return 0;
        }
        return this.pos;
    }

    public short getShort(int n) throws SQLException {
        try {
            Number number = (Number)this.getObject(n);
            return number.shortValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public short getShort(String string) throws SQLException {
        try {
            Number number = (Number)this.getObject(string);
            return number.shortValue();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public String getString(int n) throws SQLException {
        try {
            return this.getObject(n).toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getString(String string) throws SQLException {
        try {
            return this.getObject(string).toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            return (Time)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            Time time = (Time)this.getObject(n);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date = dateFormat.parse(time.toString());
            return new Time(date.getTime());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public Time getTime(String string) throws SQLException {
        try {
            return (Time)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            Time time = (Time)this.getObject(string);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date = dateFormat.parse(time.toString());
            return new Time(date.getTime());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            return (Timestamp)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            Timestamp timestamp = (Timestamp)this.getObject(n);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date = dateFormat.parse(timestamp.toString());
            return (Timestamp)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            return (Timestamp)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            Timestamp timestamp = (Timestamp)this.getObject(string);
            DateFormat dateFormat = DateFormat.getInstance();
            dateFormat.setCalendar(calendar);
            java.util.Date date = dateFormat.parse(timestamp.toString());
            return new Timestamp(date.getTime());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return null;
    }

    public int getType() throws SQLException {
        return this.scrollableType;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        try {
            return (InputStream)this.getObject(n);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            return (InputStream)this.getObject(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        Serializable serializable;
        Result result = (Result)this.insertRow.get(0);
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(result.tableName);
        stringBuffer.append(" VALUES(");
        int n = 0;
        while (n < this.insertRow.size()) {
            serializable = (Result)this.insertRow.get(n);
            if (((Result)serializable).colValue instanceof String) {
                stringBuffer.append("'");
                stringBuffer.append(((Result)serializable).colValue.toString());
                stringBuffer.append("'");
            } else if (((Result)serializable).type == 0) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(((Result)serializable).colValue.toString());
            }
            if (n != this.insertRow.size() - 1) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(")");
        serializable = (PoolManStatement)this.statement;
        Connection connection = ((PoolManStatement)serializable).getConnection();
        Statement statement = connection.createStatement();
        statement.execute(stringBuffer.toString());
        this.rowlist.add(new ArrayList(this.insertRow));
        this.insertedIndexes.add(new Integer(this.pos));
        this.moveToCurrentRow();
        this.composeInsertRow();
        PoolManStatement poolManStatement = (PoolManStatement)this.statement;
        JDBCPool jDBCPool = (JDBCPool)poolManStatement.getPool();
        jDBCPool.refreshCache();
    }

    public boolean isAfterLast() throws SQLException {
        this.assertNotInserting();
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for this ResultSet type TYPE_FORWARD_ONLY");
        }
        return this.pos > this.rowlist.size();
    }

    public boolean isBeforeFirst() throws SQLException {
        this.assertNotInserting();
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for ResultSet type TYPE_FORWARD_ONLY");
        }
        return this.pos == 0;
    }

    public boolean isFirst() throws SQLException {
        this.assertNotInserting();
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for ResultSet type TYPE_FORWARD_ONLY");
        }
        return this.pos == 1;
    }

    public boolean isLast() throws SQLException {
        this.assertNotInserting();
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for ResultSet type TYPE_FORWARD_ONLY");
        }
        return this.pos == this.rowlist.size();
    }

    public boolean last() throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Invalid method call for ResultSet type TYPE_FORWARD_ONLY");
        }
        this.clearUpdates();
        this.pos = this.rowlist.size();
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.concurType == 1007) {
            throw new SQLException("ResultSet not updatable");
        }
        this.onInsertRow = false;
    }

    public void moveToInsertRow() throws SQLException {
        if (this.concurType == 1007) {
            throw new SQLException("ResultSet not updatable");
        }
        if (this.insertRow == null) {
            throw new SQLException("Unable to create insert row, incomplete metadata from driver");
        }
        this.onInsertRow = true;
    }

    public boolean next() throws SQLException {
        ++this.pos;
        this.clearUpdates();
        return this.pos <= this.rowlist.size();
    }

    public boolean previous() throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Operation not permitted when ResultSet is TYPE_FORWARD_ONLY");
        }
        --this.pos;
        this.clearUpdates();
        if (this.pos < 1) {
            this.beforeFirst();
            return false;
        }
        return true;
    }

    public void refreshRow() throws SQLException {
        this.assertNotInserting();
        if (this.scrollableType == 1003) {
            throw new SQLException("Operation not permitted when ResultSet is TYPE_FORWARD_ONLY");
        }
        if (this.scrollableType == 1004) {
            return;
        }
        this.invokeRowRefresh();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeRowRefresh() throws SQLException {
        this.clearUpdates();
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            PoolManStatement poolManStatement = (PoolManStatement)this.statement;
            Connection connection = poolManStatement.getConnection();
            statement = ((PoolManStatement)connection.createStatement()).getNativeStatement();
            resultSet = statement.executeQuery(poolManStatement.getSQL());
            ResultSetMetaData resultSetMetaData = PoolManResultSetMetaData.getCopy(resultSet.getMetaData());
            int n = 0;
            int n2 = resultSetMetaData.getColumnCount();
            block9: while (resultSet.next()) {
                if (++n != this.pos) continue;
                ArrayList<Result> arrayList = new ArrayList<Result>(1);
                int n3 = 1;
                while (true) {
                    if (n3 >= n2) {
                        this.rowlist.set(this.pos - 1, arrayList);
                        continue block9;
                    }
                    String string = null;
                    try {
                        string = resultSetMetaData.getTableName(n3);
                        if (string.trim().length() < 1) {
                            string = null;
                        }
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    if (null == string) {
                        string = poolManStatement.fabricateTableName(poolManStatement.getSQL(), n3);
                    }
                    Result result = new Result(string, resultSetMetaData.getColumnLabel(n3), resultSet.getObject(n3), resultSetMetaData.getColumnType(n3));
                    arrayList.add(result);
                    ++n3;
                }
            }
            Object var13_14 = null;
            if (null == resultSet) return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (null == resultSet) throw throwable;
            try {
                JDBCPool.closeResources(statement, resultSet);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        JDBCPool.closeResources(statement, resultSet);
        return;
    }

    public boolean relative(int n) throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Operation Not permitted when ResultSet is TYPE_FORWARD_ONLY");
        }
        if (this.pos == 0 || this.pos > this.rowlist.size()) {
            throw new SQLException("Operation not permitted when cursor is not on a valid row:  Cursor was either before the first or after the last row");
        }
        this.clearUpdates();
        this.pos += n;
        if (this.pos < 1) {
            this.beforeFirst();
            return false;
        }
        if (this.pos > this.rowlist.size()) {
            this.afterLast();
            return false;
        }
        return true;
    }

    public boolean rowDeleted() throws SQLException {
        this.assertNotInserting();
        if (this.concurType == 1007) {
            throw new SQLException("Illegal Operation when ResultSet is CONCUR_READ_ONLY");
        }
        return null == this.rowlist.get(this.pos - 1);
    }

    public boolean rowInserted() throws SQLException {
        this.assertNotInserting();
        if (this.concurType == 1007) {
            throw new SQLException("Illegal Operation when ResultSet is CONCUR_READ_ONLY");
        }
        int n = 0;
        while (n < this.insertedIndexes.size()) {
            Integer n2 = (Integer)this.insertedIndexes.get(n);
            if (n2 == this.pos) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.assertNotInserting();
        if (this.concurType == 1007) {
            throw new SQLException("Illegal Operation when ResultSet is CONCUR_READ_ONLY");
        }
        int n = 0;
        while (n < this.updatedIndexes.size()) {
            Integer n2 = (Integer)this.updatedIndexes.get(n);
            if (n2 == this.pos) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.scrollableType == 1003) {
            throw new SQLException("Operation Not permitted when ResultSet is TYPE_FORWARD_ONLY");
        }
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 2 || result.type == 3) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.add(n - 1, new Result(result.tableName, result.colName, bigDecimal, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, bigDecimal, result.type));
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl2 = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == -7) {
            bl2 = true;
        }
        if (!bl2) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Boolean(bl), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Boolean(bl), result.type));
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == -6) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Byte(by), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Byte(by), result.type));
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException("PoolMan doesn't support this method, use native ResultSet (configurable in your poolman.xml) or execute the query using the native Statement returned from PoolManStatement.getNativeStatement() if your underlying driver supports it");
    }

    public void updateDate(int n, Date date) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 91) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, date, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, date, result.type));
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 8) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Double(d), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Double(d), result.type));
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 6) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Float(f), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Float(f), result.type));
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 4) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("UpdateInt Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Integer(n2), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Integer(n2), result.type));
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == -5 || result.type == 4 || result.type == 5 || result.type == 7 || result.type == 6 || result.type == 8 || result.type == 3 || result.type == 2) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Long(l), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Long(l), result.type));
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        Result result = (Result)arrayList.get(n - 1);
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, null, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, null, result.type));
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        Result result = (Result)arrayList.get(n - 1);
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, object, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, object, result.type));
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateRow() throws SQLException {
        Serializable serializable;
        Serializable serializable2;
        ArrayList arrayList = (ArrayList)this.rowlist.get(this.pos - 1);
        int n = 0;
        while (n < this.updatedResults.size()) {
            Object object;
            serializable2 = (Result)this.updatedResults.get(n);
            serializable = null;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                object = (Result)arrayList.get(n2);
                if (((Result)object).colName.equalsIgnoreCase(((Result)serializable2).colName)) {
                    serializable = object;
                }
                ++n2;
            }
            object = ((Result)serializable2).colValue instanceof String ? "UPDATE " + ((Result)serializable2).tableName + " SET " + ((Result)serializable2).colName + " = '" + ((Result)serializable2).colValue.toString() + "' " + "WHERE " + ((Result)serializable).colName + " = '" + ((Result)serializable).colValue.toString() + "'" : (((Result)serializable2).type == 0 ? "UPDATE " + ((Result)serializable2).tableName + " SET " + ((Result)serializable2).colName + " = null " + " WHERE " + ((Result)serializable).colName + " = " + ((Result)serializable).colValue.toString() : "UPDATE " + ((Result)serializable2).tableName + " SET " + ((Result)serializable2).colName + " = " + ((Result)serializable2).colValue.toString() + " WHERE " + ((Result)serializable).colName + " = " + ((Result)serializable).colValue.toString());
            PoolManStatement poolManStatement = (PoolManStatement)this.statement;
            Connection connection = poolManStatement.getConnection();
            Statement statement = connection.createStatement();
            statement.execute((String)object);
            ++n;
        }
        this.updatedIndexes.add(new Integer(this.pos));
        this.invokeRowRefresh();
        serializable2 = (PoolManStatement)this.statement;
        serializable = (JDBCPool)((PoolManStatement)serializable2).getPool();
        serializable.refreshCache();
    }

    public void updateShort(int n, short s) throws SQLException {
        ArrayList arrayList = this.getTrueRow();
        boolean bl = false;
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 5 || result.type == -6 || result.type == 4) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, new Short(s), result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, new Short(s), result.type));
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        boolean bl = false;
        ArrayList arrayList = this.getTrueRow();
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 1 || result.type == 12 || result.type == -1) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, string, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, string, result.type));
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        boolean bl = false;
        ArrayList arrayList = this.getTrueRow();
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 92) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, time, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, time, result.type));
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        boolean bl = false;
        ArrayList arrayList = this.getTrueRow();
        Result result = (Result)arrayList.get(n - 1);
        if (result.type == 93) {
            bl = true;
        }
        if (!bl) {
            throw new SQLException("Update Error: Check column name and argument type");
        }
        if (this.onInsertRow) {
            arrayList.set(n - 1, new Result(result.tableName, result.colName, timestamp, result.type));
        } else {
            this.updatedResults.add(new Result(result.tableName, result.colName, timestamp, result.type));
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.getObject(this.lastColIndex) == null;
    }

    private void clearUpdates() {
        this.updatedResults.clear();
        if (this.insertRow != null) {
            this.insertRow.clear();
        }
    }

    private void composeInsertRow() {
        try {
            ResultSetMetaData resultSetMetaData = PoolManResultSetMetaData.getCopy(this.getMetaData());
            this.insertRow = new ArrayList();
            int n = 1;
            while (n <= resultSetMetaData.getColumnCount()) {
                String string = null;
                try {
                    string = resultSetMetaData.getTableName(n);
                    if (string.trim().length() < 1) {
                        string = null;
                    }
                }
                catch (Exception exception) {
                    string = null;
                }
                if (string == null) {
                    PoolManStatement poolManStatement = (PoolManStatement)this.statement;
                    string = poolManStatement.fabricateTableName(poolManStatement.getSQL(), n);
                }
                this.insertRow.add(n - 1, new Result(string, resultSetMetaData.getColumnName(n), null, resultSetMetaData.getColumnType(n)));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            this.insertRow = null;
        }
    }

    private void assertNotInserting() throws SQLException {
        if (this.onInsertRow) {
            throw new SQLException("Operation not permitted while cursor is on the insert row");
        }
    }

    private ArrayList getTrueRow() {
        if (this.onInsertRow) {
            return this.insertRow;
        }
        return (ArrayList)this.rowlist.get(this.pos - 1);
    }
}

