/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPConFactorySingle;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import com.verisign.epp.util.EPPXMLStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.w3c.dom.Document;

public class EPPXMLStreamTst {
    public static void main(String[] args) {
        Object myString = null;
        EPPXMLStreamTst myInstance = new EPPXMLStreamTst();
        Object socket = null;
        InputStream myInputStream = null;
        OutputStream myOutputStream = null;
        Document myDoc = null;
        EPPXMLStream myStream = null;
        EPPClientCon myConnection = null;
        EPPEnvSingle env = EPPEnvSingle.getInstance();
        try {
            env.initialize("epp.config");
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEvnException is thrown :" + e.getMessage());
            return;
        }
        try {
            Logger root = Logger.getRootLogger();
            root.setLevel(EPPEnv.getLogLevel());
            root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), EPPEnv.getLogFile(), true));
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEnvException When intializing Log " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("IOException When intializing Log " + e.getMessage());
            System.exit(1);
        }
        EPPConFactorySingle myCon = EPPConFactorySingle.getInstance();
        myStream = new EPPXMLStream();
        try {
            myConnection = myCon.getEPPConnection();
        }
        catch (EPPConException myException) {
            System.out.println("EPPApplication.initialze():  " + myException.getMessage());
            return;
        }
        try {
            myConnection.initialize();
        }
        catch (EPPConException myException) {
            System.out.println("EPPApplication.initialze():  " + myException.getMessage());
            return;
        }
        try {
            myInputStream = myConnection.getInputStream();
            myOutputStream = myConnection.getOutputStream();
        }
        catch (EPPConException myException) {
            System.out.println("EPPConException When getting Streams" + myException.getMessage());
            return;
        }
        try {
            boolean theDocFound = false;
            while (!theDocFound) {
                try {
                    myDoc = myStream.read(myInputStream);
                    theDocFound = true;
                }
                catch (InterruptedIOException ex) {
                    System.out.println("InterruptedIOException, continueing to read: " + ex.getMessage());
                }
            }
        }
        catch (EPPException myException) {
            System.out.println("EPPException: " + myException.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getMessage());
            return;
        }
        try {
            myStream.write(myDoc, myOutputStream);
        }
        catch (EPPException myException) {
            System.out.println("Exception " + myException.getMessage());
            return;
        }
        try {
            myInputStream.close();
            myOutputStream.close();
            myConnection.close();
        }
        catch (EPPConException myException) {
            System.out.println("EPPApplication.endApplication() : " + myException.getMessage());
            return;
        }
        catch (IOException myException) {
            System.out.println("Exception " + myException.getMessage());
            return;
        }
    }
}

