/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPParserException;
import com.verisign.epp.util.EPPSchemaCacher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EPPSchemaCachingEntityResolver
implements XMLEntityResolver,
EntityResolver {
    private static int count;
    private static Logger cat;
    private EPPSchemaCacher schemaCache;

    public EPPSchemaCachingEntityResolver(EPPSchemaCacher aSchemaCache) {
        cat.debug((Object)"EPPSchemaCachingEntityResolver(EPPSchemaCacher) enter");
        this.schemaCache = aSchemaCache;
        cat.debug((Object)"EPPSchemaCachingEntityResolver(EPPSchemaCacher) exit");
    }

    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        cat.debug((Object)"resolveEntity(String aPublicId, String aSystemId) enter");
        cat.info((Object)("Entity not found in grammar pool - public Id: " + aPublicId + " systemId: " + aSystemId));
        File tmpFile = new File(aSystemId);
        String literalId = tmpFile.getName();
        InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        try {
            this.schemaCache.addSchemaToCache(new XMLInputSource(literalId, literalId, aSystemId, schemaStream, null));
        }
        catch (EPPParserException e) {
            cat.error((Object)"EPPParserException caught while trying to add schema to cache");
            throw new XNIException((Exception)e);
        }
        InputStream retStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (retStream == null) {
            throw new SAXException("Couldn't locate resource: " + literalId);
        }
        InputSource retSource = new InputSource(retStream);
        cat.debug((Object)"resolveEntity(aPublicId, aSystemId) exit");
        return retSource;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier aResourceIdentifier) throws XNIException, IOException {
        cat.debug((Object)"resolvEntity(XMLResourceIdentifier) enter");
        String publicId = aResourceIdentifier.getPublicId();
        String systemId = aResourceIdentifier.getBaseSystemId();
        String literalId = aResourceIdentifier.getLiteralSystemId();
        cat.info((Object)("Entity not found in grammar pool - public Id: " + publicId + " systemId: " + systemId + " literalId: " + literalId));
        InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (schemaStream == null) {
            throw new XNIException("Couldn't locate resource: " + literalId);
        }
        try {
            this.schemaCache.addSchemaToCache(new XMLInputSource(literalId, literalId, systemId, schemaStream, null));
        }
        catch (EPPParserException e) {
            cat.error((Object)"EPPParserException caught while trying to add schema to cache");
            throw new XNIException((Exception)e);
        }
        InputStream retStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        XMLInputSource retSource = new XMLInputSource(literalId, literalId, systemId, retStream, null);
        cat.debug((Object)"resolveEntity(aPublicId, aSystemId) exit");
        return retSource;
    }

    static {
        cat = Logger.getLogger((String)EPPSchemaCachingEntityResolver.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

