/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPCatFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EPPEntityResolver
implements EntityResolver {
    private static Logger _cat = Logger.getLogger((String)EPPEntityResolver.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static HashMap _cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        _cat.debug((Object)("resolveEntity([" + aPublicId + "], [" + aSystemId + "]: enter"));
        String theEntityStr = null;
        if (aSystemId != null) {
            aSystemId = aSystemId.trim();
        }
        if ((theEntityStr = (String)_cache.get(aSystemId)) == null) {
            HashMap hashMap = _cache;
            synchronized (hashMap) {
                theEntityStr = (String)_cache.get(aSystemId);
                if (theEntityStr == null) {
                    int currChar;
                    _cat.debug((Object)(aSystemId + " not in cache, attempting to open"));
                    InputStream theEntity = ClassLoader.getSystemResourceAsStream("schemas/" + aSystemId);
                    if (theEntity == null) {
                        theEntity = EPPEntityResolver.class.getClassLoader().getResourceAsStream("schemas/" + aSystemId);
                    }
                    if (theEntity == null) {
                        _cat.error((Object)(aSystemId + " could not be opened.  Check the classpath"));
                        throw new SAXException(aSystemId + " could not be opened.  Check the classpath");
                    }
                    _cat.debug((Object)(aSystemId + " opened, adding to cache"));
                    StringBuffer entityBuffer = new StringBuffer();
                    while ((currChar = theEntity.read()) != -1) {
                        entityBuffer.append((char)currChar);
                    }
                    theEntityStr = entityBuffer.toString();
                    _cache.put(aSystemId, theEntityStr);
                    theEntity.close();
                } else {
                    _cat.debug((Object)(aSystemId + "synchronized() in cache"));
                }
            }
        } else {
            _cat.debug((Object)(aSystemId + " in cache"));
        }
        _cat.debug((Object)("resolveEntity(" + aPublicId + ", " + aSystemId + ": return"));
        InputSource retSource = new InputSource(new StringReader(theEntityStr));
        retSource.setPublicId(aPublicId);
        retSource.setSystemId(aSystemId);
        return retSource;
    }
}

