/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.framework.EPPPollDataRecord;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueException;

public class LaunchPollHandler
implements EPPPollHandler {
    public static final String KIND = "LaunchPollHandler";

    @Override
    public String getKind() {
        return KIND;
    }

    @Override
    public EPPResponse toResponse(EPPPollDataRecord aRecord) throws EPPPollQueueException {
        if (!aRecord.getKind().equals(this.getKind())) {
            throw new EPPPollQueueException("Handler for kind " + aRecord.getKind() + " does not match");
        }
        EPPResponse theResponse = (EPPResponse)aRecord.getData();
        if (theResponse instanceof EPPDomainInfoResp) {
            String theDesc = "Undefined";
            if (theResponse.hasExtension(EPPLaunchInfData.class)) {
                EPPLaunchInfData launchExt = (EPPLaunchInfData)theResponse.getExtension(EPPLaunchInfData.class);
                theDesc = "Application " + launchExt.getStatus().getStatus();
            }
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), theDesc));
        } else if (theResponse instanceof EPPDomainPendActionMsg) {
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Pending action completed successfully."));
        } else {
            throw new EPPPollQueueException("Unable to handle message class <" + theResponse.getClass().getName());
        }
        theResponse.setResult(1301);
        return theResponse;
    }
}

