/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.registry.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.EPPRegistryContact;
import com.verisign.epp.codec.registry.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.EPPRegistryContactName;
import com.verisign.epp.codec.registry.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.EPPRegistryDomain;
import com.verisign.epp.codec.registry.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.EPPRegistryHost;
import com.verisign.epp.codec.registry.EPPRegistryIDN;
import com.verisign.epp.codec.registry.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.EPPRegistryKey;
import com.verisign.epp.codec.registry.EPPRegistryKeyValue;
import com.verisign.epp.codec.registry.EPPRegistryLanguageType;
import com.verisign.epp.codec.registry.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.EPPRegistryPhase;
import com.verisign.epp.codec.registry.EPPRegistryPostal;
import com.verisign.epp.codec.registry.EPPRegistryRGP;
import com.verisign.epp.codec.registry.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.EPPRegistrySLA;
import com.verisign.epp.codec.registry.EPPRegistrySLAInfo;
import com.verisign.epp.codec.registry.EPPRegistryServices;
import com.verisign.epp.codec.registry.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.EPPRegistryZoneInfo;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EPPRegistry {
    private EPPSession session = null;
    private String transId = null;
    private boolean allTlds = false;
    private List zoneList = null;
    private String authString;
    private String authRoid;

    public EPPRegistry(EPPSession aSession) {
        this.session = aSession;
    }

    public EPPRegistryCheckResp sendCheck() throws EPPCommandException {
        EPPRegistryCheckCmd theCommand = new EPPRegistryCheckCmd(this.transId, this.zoneList);
        this.resetRegistry();
        return (EPPRegistryCheckResp)this.session.processDocument(theCommand, EPPRegistryCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.size() != 1) {
            throw new EPPCommandException("One Tld Name is required for sendDelete()");
        }
        EPPRegistryDeleteCmd theCommand = new EPPRegistryDeleteCmd(this.transId, (String)this.zoneList.get(0));
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPRegistryInfoResp sendInfo() throws EPPCommandException {
        if (!(this.zoneList != null && this.zoneList.size() == 1 || this.allTlds)) {
            throw new EPPCommandException("One Tld Name is required for sendInfo(), unless allTlds is set to true");
        }
        EPPRegistryInfoCmd theCommand = null;
        theCommand = !this.allTlds ? new EPPRegistryInfoCmd("ABC-12349", (String)this.zoneList.get(0)) : new EPPRegistryInfoCmd("ABC-12349", true);
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
        }
        this.resetRegistry();
        return (EPPRegistryInfoResp)this.session.processDocument(theCommand, EPPRegistryInfoResp.class);
    }

    public EPPRegistryCreateResp sendCreate() throws EPPCommandException {
        EPPRegistryServicesExt svcExt;
        EPPRegistryServices services;
        if (this.zoneList == null || this.zoneList.size() != 1) {
            throw new EPPCommandException("One Tld Name is required for sendCreate()");
        }
        EPPRegistryZoneInfo tld = new EPPRegistryZoneInfo();
        tld.setName((String)this.zoneList.get(0));
        EPPRegistryCreateCmd theCommand = null;
        theCommand = new EPPRegistryCreateCmd("ABC-12349", tld);
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
        }
        tld.setDomain(this.buildDomain());
        tld.setHost(this.buildHost());
        tld.setContact(this.buildContact());
        if ("com".equals((String)this.zoneList.get(0))) {
            services = new EPPRegistryServices();
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/rgp-poll-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:host-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:contact-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:domain-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/lowbalance-poll-1.0", Boolean.FALSE));
            svcExt = new EPPRegistryServicesExt();
            services.setExtension(svcExt);
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign-grs.com/epp/namestoreExt-1.1", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:rgp-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/sync-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/idnLang-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/jobsContact-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/premiumdomain-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:secDNS-1.1", Boolean.FALSE));
            tld.setServices(services);
        } else {
            services = new EPPRegistryServices();
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/registry-1.0", Boolean.TRUE));
            svcExt = new EPPRegistryServicesExt();
            services.setExtension(svcExt);
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/registry-1.0", Boolean.TRUE));
            tld.setServices(services);
        }
        EPPRegistrySLAInfo slaInfo = new EPPRegistrySLAInfo();
        slaInfo.addSla(new EPPRegistrySLA("response", "ext", "create", 500.0, "ms"));
        slaInfo.addSla(new EPPRegistrySLA("availability", null, "create", 99.9, "percent"));
        tld.setSlaInfo(slaInfo);
        tld.setCreatedBy("crId");
        tld.setCreatedDate(new Date());
        EPPRegistryPhase phase = new EPPRegistryPhase("sunrise", new Date(), new Date());
        phase.setMode("pending-application");
        tld.addPhase(phase);
        phase = new EPPRegistryPhase("pre-delegation", new Date(), new Date());
        phase.setMode("pending-registration");
        tld.addPhase(phase);
        tld.addPhase(new EPPRegistryPhase("landrush", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("pre-delegation", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("claims", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("open", new Date()));
        tld.addPhase(new EPPRegistryPhase("custom", "userDefined", new Date()));
        this.resetRegistry();
        return (EPPRegistryCreateResp)this.session.processDocument(theCommand, EPPRegistryCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.zoneList == null || this.zoneList.size() != 1) {
            throw new EPPCommandException("One Tld Name is required for sendUpdate()");
        }
        EPPRegistryZoneInfo tld = new EPPRegistryZoneInfo();
        tld.setName((String)this.zoneList.get(0));
        EPPRegistryUpdateCmd theCommand = null;
        theCommand = new EPPRegistryUpdateCmd("ABC-12349", tld);
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
        }
        tld.setDomain(this.buildDomain());
        tld.setHost(this.buildHost());
        tld.setContact(this.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.2", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:registry-1.1", Boolean.FALSE));
        tld.setServices(services);
        EPPRegistrySLAInfo slaInfo = new EPPRegistrySLAInfo();
        slaInfo.addSla(new EPPRegistrySLA("response", "ext", "create", 500.0, "ms"));
        slaInfo.addSla(new EPPRegistrySLA("availability", null, "create", 99.9, "percent"));
        tld.setSlaInfo(slaInfo);
        tld.setCreatedBy("crId");
        tld.setCreatedDate(new Date());
        EPPRegistryPhase phase = new EPPRegistryPhase("sunrise", new Date(), new Date());
        phase.setMode("pending-application");
        tld.addPhase(phase);
        phase = new EPPRegistryPhase("pre-delegation", new Date(), new Date());
        phase.setMode("pending-registration");
        tld.addPhase(phase);
        tld.addPhase(new EPPRegistryPhase("landrush", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("pre-delegation", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("claims", new Date(), new Date()));
        tld.addPhase(new EPPRegistryPhase("open", new Date()));
        tld.addPhase(new EPPRegistryPhase("custom", "userDefined", new Date()));
        this.resetRegistry();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    private EPPRegistryDomain buildDomain() {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(new Integer(2));
        domainName.setMinLength(new Integer(5));
        domainName.setMaxLength(new Integer(50));
        domainName.setAlphaNumStart(new Boolean(true));
        domainName.setAlphaNumEnd(new Boolean(false));
        domainName.setOnlyDnsChars(new Boolean(true));
        ArrayList<EPPRegistryRegex> regex = new ArrayList<EPPRegistryRegex>();
        EPPRegistryRegex r = new EPPRegistryRegex("^\\w+.*$", "test regex");
        regex.add(r);
        r = new EPPRegistryRegex("^\\d+.*$");
        regex.add(r);
        domainName.setRegex(regex);
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved1");
        rNames.add("reserved2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(new Integer(3));
            domainName.getReservedNames().setReservedNames(new ArrayList());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguageType("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", "restricted"));
        idn.addLanguage(new EPPRegistryLanguageType("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", "blocked"));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(new Boolean(true));
        domain.setContactsSupported(new Boolean(false));
        domain.addContact(new EPPRegistryDomainContact("admin", 1, 4));
        domain.addContact(new EPPRegistryDomainContact("billing", 2, 5));
        domain.addContact(new EPPRegistryDomainContact("tech", 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        domain.setChildHostLimit(new EPPRegistryDomainHostLimit(2, 32));
        domain.addPeriod(new EPPRegistryDomainPeriod("create", Boolean.TRUE));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, "y", 10, "y", 2, "y"));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, "y", 8, "y", 3, "y"));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(1, "y"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, "m"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, "h"));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, "d"));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, "m"));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, "m"));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, "m"));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        EPPRegistryKey key = new EPPRegistryKey(2, 4, null);
        key.addAlgorithm("algKey1");
        key.addAlgorithm("algKey2");
        key.addAlgorithm("algKey3");
        dnssec.setKey(key);
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(new Integer(12));
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("dk1", "dv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("dk2", "dv2"));
        domain.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        return domain;
    }

    private EPPRegistryHost buildHost() {
        EPPRegistryHost host = new EPPRegistryHost();
        host.setInternal(new EPPRegistryInternalHost(5, 15, "perZone"));
        host.setExternal(new EPPRegistryExternalHost(2, 12, "perZone"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp1"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp2"));
        host.setMaxCheckHost(new Integer(15));
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("hk1", "hv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("hk2", "hv2"));
        host.setCustomData(customData);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        host.setSupportedStatus(supportedStatus);
        return host;
    }

    private EPPRegistryContact buildContact() {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setSharePolicy("perZone");
        contact.setLocSupport(Boolean.TRUE);
        contact.setIntSupport(Boolean.FALSE);
        EPPRegistryCustomData customData = new EPPRegistryCustomData();
        customData.addKeyValue(new EPPRegistryKeyValue("ck1", "cv1"));
        customData.addKeyValue(new EPPRegistryKeyValue("ck2", "cv2"));
        contact.setCustomData(customData);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(new Integer(15));
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setName(new EPPRegistryContactName(5, 15));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        ArrayList<EPPRegistryRegex> emailRegex = new ArrayList<EPPRegistryRegex>();
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp"));
        emailRegex.add(new EPPRegistryRegex("^.*$", "exp in ch", "ch"));
        postalInfo.setEmailRegex(emailRegex);
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        contact.setMaxCheckContact(new Integer(5));
        contact.setPostalInfo(postalInfo);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        return contact;
    }

    public EPPSession getSession() {
        return this.session;
    }

    public void setSession(EPPSession session) {
        this.session = session;
    }

    public String getTransId() {
        return this.transId;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public List getZoneList() {
        return this.zoneList;
    }

    public void setZoneList(List zoneList) {
        this.zoneList = zoneList;
    }

    public void addTld(String tld) {
        if (this.zoneList == null) {
            this.zoneList = new ArrayList();
        }
        this.zoneList.add(tld);
        this.allTlds = false;
    }

    public boolean isAllTlds() {
        return this.allTlds;
    }

    public void setAllTlds(boolean allTlds) {
        this.allTlds = allTlds;
        if (allTlds) {
            this.zoneList = new ArrayList();
        }
    }

    public void resetRegistry() {
        this.transId = null;
        this.zoneList = new ArrayList();
        this.authRoid = null;
        this.authRoid = null;
        this.allTlds = false;
    }

    public String getAuthString() {
        return this.authString;
    }

    public void setAuthString(String authString) {
        this.authString = authString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String authRoid) {
        this.authRoid = authRoid;
    }
}

