/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCheckResult;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchCodeMark;
import com.verisign.epp.codec.launch.EPPLaunchCreData;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchDelete;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchNotice;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import com.verisign.epp.codec.mark.EPPCourt;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.mark.EPPMarkAddress;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.codec.mark.EPPProtection;
import com.verisign.epp.codec.mark.EPPTrademark;
import com.verisign.epp.codec.mark.EPPTreatyOrStatute;
import com.verisign.epp.codec.signedMark.EPPEncodedSignedMark;
import com.verisign.epp.codec.signedMark.EPPIssuer;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPLaunch;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;

public class EPPLaunchTst
extends TestCase {
    private static PKIXParameters pkixParameters;
    private static String smdsDir;
    private EPPDomain domain = null;
    private EPPLaunch launch = null;
    private EPPSession session = null;
    private int iteration = 0;
    private PrivateKey privateKey;
    private Certificate[] certChain;
    private static EPPApplicationSingle app;
    private static String configFileName;
    private Random rd = new Random(System.currentTimeMillis());
    private static final Logger cat;

    public EPPLaunchTst(String aName) {
        super(aName);
    }

    public void testLaunchPhase() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.launchCreateActiveSMD();
            this.launchCreateGeneric();
            this.launchCreateSignedMark();
            this.launchCreateCodeMark();
            this.launchCreateNotice();
            this.launchCheck();
            this.launchInfo();
            this.launchUpdate();
            this.launchDelete();
            this.launchPollMessaging();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void launchCheck() {
        this.printStart("launchCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("launchCheck: Claims Check for example1.tld with implicit type");
            this.launch.setTransId("ABC-12345");
            this.launch.addDomainName("example1.tld");
            this.launch.setPhase("claims");
            EPPResponse claimsCheckResp = this.launch.sendCheck();
            System.out.println("Response Type = " + claimsCheckResp.getType());
            System.out.println("Response.TransId.ServerTransId = " + claimsCheckResp.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + claimsCheckResp.getTransId().getClientTransId());
            System.out.println("\nlaunchCheck: Response = [" + claimsCheckResp + "]");
            if (!claimsCheckResp.hasExtension(EPPLaunchChkData.class)) {
                Assert.fail((String)"launchCheck: No EPPLaunchChkData extension found in claims check response");
            }
            EPPLaunchChkData theExt = (EPPLaunchChkData)claimsCheckResp.getExtension(EPPLaunchChkData.class);
            List<EPPLaunchCheckResult> results = theExt.getCheckResults();
            for (EPPLaunchCheckResult result : results) {
                if (result.isExists()) {
                    System.out.println("launchCheck: Domain + " + result.getName() + ", mark exists, claimKey = [" + result.getClaimKey() + "]");
                    continue;
                }
                System.out.println("launchCheck: Domain + " + result.getName() + ", mark DOES NOT exist");
            }
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("launchCheck: Claims Check for example1.tld and example2.tld with explicit type");
            this.launch.setTransId("ABC-12345");
            this.launch.addDomainName("example1.tld");
            this.launch.addDomainName("example2.tld");
            this.launch.setPhase("claims");
            this.launch.setType("claims");
            claimsCheckResp = this.launch.sendCheck();
            System.out.println("Response Type = " + claimsCheckResp.getType());
            System.out.println("Response.TransId.ServerTransId = " + claimsCheckResp.getTransId().getServerTransId());
            System.out.println("Response.TransId.ServerTransId = " + claimsCheckResp.getTransId().getClientTransId());
            System.out.println("\nlaunchCheck: Response = [" + claimsCheckResp + "]");
            if (!claimsCheckResp.hasExtension(EPPLaunchChkData.class)) {
                Assert.fail((String)"launchCheck: No EPPLaunchChkData extension found in claims check response");
            }
            theExt = (EPPLaunchChkData)claimsCheckResp.getExtension(EPPLaunchChkData.class);
            results = theExt.getCheckResults();
            for (EPPLaunchCheckResult result : results) {
                if (result.isExists()) {
                    System.out.println("launchCheck: Domain + " + result.getName() + ", mark exists, claimKey = [" + result.getClaimKey() + "]");
                    continue;
                }
                System.out.println("launchCheck: Domain + " + result.getName() + ", mark DOES NOT exist");
            }
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("launchCheck: Availability Check for example1.tld and example2.tld with idn-release custom phase");
            this.launch.setTransId("ABC-12345");
            this.launch.addDomainName("example1.tld");
            this.launch.addDomainName("example2.tld");
            this.launch.setPhase("custom");
            this.launch.setPhaseName("idn-release");
            this.launch.setType("avail");
            EPPDomainCheckResp availCheckResp = (EPPDomainCheckResp)this.launch.sendCheck();
            System.out.println("\nlaunchCheck: Response = [" + availCheckResp + "]");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.printEnd("launchCheck");
    }

    public void launchInfo() {
        this.printStart("launchInfo");
        try {
            EPPResponse response;
            EPPLaunchInfData infData;
            EPPLaunchInfData infData2;
            System.out.println("launchInfo: Info command for Sunrise Application \"abc123\"");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("sunrise"), "abc123"));
            EPPDomainInfoResp domainResponse = this.domain.sendInfo();
            System.out.println("launchInfo: Sunrise Application Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPLaunchInfData.class)) {
                infData2 = (EPPLaunchInfData)domainResponse.getExtension(EPPLaunchInfData.class);
                if (!infData2.getPhase().getPhase().equals("sunrise")) {
                    Assert.fail((String)("launchInfo: phase " + infData2.getPhase().getPhase() + " != " + "sunrise"));
                }
                System.out.println("Sunrise Application Id = " + infData2.getApplicationId());
                System.out.println("Sunrise Application Status = " + infData2.getStatus().getStatus());
                System.out.println("Sunrise Application Mark = " + infData2.getMark());
            }
            System.out.println("launchInfo: Info command for Sunrise Registration");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("sunrise")));
            domainResponse = this.domain.sendInfo();
            System.out.println("launchInfo: Sunrise Registration Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPLaunchInfData.class)) {
                infData2 = (EPPLaunchInfData)domainResponse.getExtension(EPPLaunchInfData.class);
                if (!infData2.getPhase().getPhase().equals("sunrise")) {
                    Assert.fail((String)("launchInfo: phase " + infData2.getPhase().getPhase() + " != " + "sunrise"));
                }
                if (infData2.getApplicationId() != null) {
                    Assert.fail((String)"launchInfo: applicationId should be null for sunrise registration");
                }
                if (infData2.getStatus() != null) {
                    Assert.fail((String)"launchInfo: status should be null for sunrise registration");
                }
                if (infData2.getMark() != null) {
                    Assert.fail((String)"launchInfo: Mark should be null with includeMark = false");
                }
            }
            System.out.println("launchInfo: Info command for Sunrise Registration with includeMark = true");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            EPPLaunchInfo theExt = new EPPLaunchInfo(new EPPLaunchPhase("sunrise"));
            theExt.setIncludeMark(true);
            this.domain.addExtension(theExt);
            domainResponse = this.domain.sendInfo();
            System.out.println("launchInfo: Sunrise Registration with includeMark=true Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPLaunchInfData.class)) {
                infData = (EPPLaunchInfData)domainResponse.getExtension(EPPLaunchInfData.class);
                if (!infData.getPhase().getPhase().equals("sunrise")) {
                    Assert.fail((String)("launchInfo: phase " + infData.getPhase().getPhase() + " != " + "sunrise"));
                }
                if (infData.getApplicationId() != null) {
                    Assert.fail((String)"launchInfo: applicationId should be null for sunrise registration");
                }
                if (infData.getStatus() != null) {
                    Assert.fail((String)"launchInfo: status should be null for sunrise registration");
                }
                if (infData.getMark() == null) {
                    Assert.fail((String)"launchInfo: mark should not be null");
                }
                System.out.println("Sunrise Registration Mark = " + infData.getMark());
            }
            System.out.println("launchInfo: Info command for landrush application \"abc123\"");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("landrush"), "abc123"));
            domainResponse = this.domain.sendInfo();
            System.out.println("launchInfo: Landrush Application Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPLaunchInfData.class)) {
                infData = (EPPLaunchInfData)domainResponse.getExtension(EPPLaunchInfData.class);
                if (!infData.getPhase().getPhase().equals("landrush")) {
                    Assert.fail((String)("EPPLaunchInfData phase " + infData.getPhase().getPhase() + " != " + "landrush"));
                }
                System.out.println("Landrush Application Id = " + infData.getApplicationId());
                System.out.println("Landrush Application Status = " + infData.getStatus().getStatus());
                if (infData.getMark() != null) {
                    Assert.fail((String)"launchInfo: mark should be null for landrush application");
                }
            }
            System.out.println("launchInfo: Info command for unsupported landrush registration");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("landrush")));
            domainResponse = null;
            try {
                domainResponse = this.domain.sendInfo();
            }
            catch (EPPCommandException ex) {
                response = ex.getResponse();
                System.out.println("launchInfo: Landrush Registration Expected Error Response = [" + response + "]\n\n");
            }
            if (domainResponse != null) {
                Assert.fail((String)"launchInfo: landrush registration info should have failed");
            }
            System.out.println("launchInfo: Info command for unsupported phase \"CLAIMS\"");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("claims")));
            domainResponse = null;
            try {
                domainResponse = this.domain.sendInfo();
            }
            catch (EPPCommandException ex) {
                response = ex.getResponse();
                System.out.println("launchInfo: Info with Unsupported Phase Expected Error Response = [" + response + "]\n\n");
            }
            if (domainResponse != null) {
                Assert.fail((String)"launchInfo: Info with unsupported Phase should have failed");
            }
            System.out.println("launchInfo: Info command for unsupported phase \"CLAIMS\"");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("example.tld");
            this.domain.addExtension(new EPPLaunchInfo(new EPPLaunchPhase("claims")));
            domainResponse = null;
            try {
                domainResponse = this.domain.sendInfo();
            }
            catch (EPPCommandException ex) {
                response = ex.getResponse();
                System.out.println("launchInfo: Info with Unsupported Phase Expected Error Response = [" + response + "]\n\n");
            }
            if (domainResponse != null) {
                Assert.fail((String)"launchInfo: Info with unsupported Phase should have failed");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("launchInfo");
    }

    public void launchCreateCodeMark() {
        this.printStart("launchCreateCodeMark");
        try {
            EPPMarkContact holder = new EPPMarkContact();
            holder.setEntitlement("owner");
            holder.setOrg("Example Inc.");
            EPPMarkAddress holderAddress = new EPPMarkAddress();
            holderAddress.addStreet("123 Example Dr.");
            holderAddress.addStreet("Suite 100");
            holderAddress.setCity("Reston");
            holderAddress.setSp("VA");
            holderAddress.setPc("20190");
            holderAddress.setCc("US");
            holder.setAddress(holderAddress);
            EPPMarkContact contact = new EPPMarkContact();
            contact.setType("owner");
            contact.setName("John Doe");
            contact.setOrg("Example Inc.");
            EPPMarkAddress contactAddress = new EPPMarkAddress();
            contactAddress.addStreet("123 Example Dr.");
            contactAddress.addStreet("Suite 100");
            contactAddress.setCity("Reston");
            contactAddress.setSp("VA");
            contactAddress.setPc("20166-6503");
            contactAddress.setCc("US");
            contact.setAddress(contactAddress);
            contact.setVoice("+1.7035555555");
            contact.setVoiceExt("1234");
            contact.setFax("+1.7035555556");
            contact.setEmail("jdoe@example.tld");
            EPPTrademark trademark = new EPPTrademark();
            trademark.setId("1234-2");
            trademark.setName("Example One");
            trademark.addHolder(holder);
            trademark.addContact(contact);
            trademark.setJurisdiction("US");
            trademark.addClass("35");
            trademark.addClass("36");
            trademark.addLabel("example-one");
            trademark.addLabel("exampleone");
            trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            trademark.setRegNum("234235");
            trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
            trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
            EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
            treatyOrStatute.setId("1234-2");
            treatyOrStatute.setName("Example One");
            treatyOrStatute.addHolder(holder);
            treatyOrStatute.addContact(contact);
            treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
            treatyOrStatute.addLabel("example-one");
            treatyOrStatute.addLabel("exampleone");
            treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            treatyOrStatute.setRefNum("234235");
            treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
            treatyOrStatute.setTitle("Example Title");
            treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
            EPPCourt court = new EPPCourt();
            court.setId("1234-2");
            court.setName("Example One");
            court.addHolder(holder);
            court.addContact(contact);
            court.addLabel("example-one");
            court.addLabel("exampleone");
            court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            court.setRefNum("234235");
            court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
            court.setCc("US");
            court.addRegions("Reston");
            court.setCourtName("Test Court");
            EPPMark mark = new EPPMark();
            mark.addTrademark(trademark);
            mark.addTreatyOrStatute(treatyOrStatute);
            mark.addCourt(court);
            EPPTrademark trademark2 = (EPPTrademark)trademark.clone();
            trademark2.setName("Hello World 2");
            trademark2.setLabels(null);
            trademark2.addLabel("helloworld2");
            trademark2.addLabel("hello-world2");
            trademark2.addLabel("hello-world-2");
            EPPMark mark2 = new EPPMark();
            mark2.addTrademark(trademark2);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with code.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC"), "application"));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: sunrise application with code: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with list of codes.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            EPPLaunchCreate theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "application");
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample1"));
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AD", "sample2"));
            this.domain.addExtension(theExt);
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: Sunrise application with list of codes: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with mark.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark(mark), "application"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: sunrise application with mark: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with list of marks.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "application");
            theExt.addCodeMark(new EPPLaunchCodeMark(mark));
            theExt.addCodeMark(new EPPLaunchCodeMark(mark2));
            this.domain.addExtension(theExt);
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: Sunrise application with list of codes: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with code and mark.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample", mark), "application"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: sunrise application with code and mark: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise application with list of codes and marks.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "application");
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample", mark));
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AD", mark2));
            this.domain.addExtension(theExt);
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: Sunrise application with list of codes and marks: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateCodeMark: Create command for sunrise registration with list of codes and marks.");
            this.domain.addDomainName("REG1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "registration");
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AC", "sample", mark));
            theExt.addCodeMark(new EPPLaunchCodeMark("49FD46E6C4B45C55D4AD", mark2));
            this.domain.addExtension(theExt);
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: Sunrise registration with list of codes and marks: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1000);
            assert (!response.hasExtension(EPPLaunchCreData.class));
            System.out.println("\nlaunchCreateCodeMark: Create command for mix of sunrise and claims create model.");
            this.domain.addDomainName("APP1.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            EPPLaunchCreate createExt = new EPPLaunchCreate(new EPPLaunchPhase("custom", "non-tmch-sunrise"), "application");
            createExt.addCodeMark(new EPPLaunchCodeMark(mark));
            createExt.setNotice(new EPPLaunchNotice("49FD46E6C4B45C55D4AC", new Date(), new Date(), "custom"));
            this.domain.addExtension(createExt);
            response = this.domain.sendCreate();
            System.out.println("launchCreateCodeMark: Create command for mix of sunrise and claims create model: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (CloneNotSupportedException e) {
            this.handleException(e);
        }
        this.printEnd("launchCreateCodeMark");
    }

    public void launchCreateSignedMark() {
        this.printStart("launchCreateSignedMark");
        try {
            block24: {
                EPPMarkContact holder = new EPPMarkContact();
                holder.setEntitlement("owner");
                holder.setOrg("Example Inc.");
                EPPMarkAddress holderAddress = new EPPMarkAddress();
                holderAddress.addStreet("123 Example Dr.");
                holderAddress.addStreet("Suite 100");
                holderAddress.setCity("Reston");
                holderAddress.setSp("VA");
                holderAddress.setPc("20190");
                holderAddress.setCc("US");
                holder.setAddress(holderAddress);
                EPPMarkContact contact = new EPPMarkContact();
                contact.setType("owner");
                contact.setName("John Doe");
                contact.setOrg("Example Inc.");
                EPPMarkAddress contactAddress = new EPPMarkAddress();
                contactAddress.addStreet("123 Example Dr.");
                contactAddress.addStreet("Suite 100");
                contactAddress.setCity("Reston");
                contactAddress.setSp("VA");
                contactAddress.setPc("20166-6503");
                contactAddress.setCc("US");
                contact.setAddress(contactAddress);
                contact.setVoice("+1.7035555555");
                contact.setVoiceExt("1234");
                contact.setFax("+1.7035555556");
                contact.setEmail("jdoe@example.tld");
                EPPTrademark trademark = new EPPTrademark();
                trademark.setId("1234-2");
                trademark.setName("Example One");
                trademark.addHolder(holder);
                trademark.addContact(contact);
                trademark.setJurisdiction("US");
                trademark.addClass("35");
                trademark.addClass("36");
                trademark.addLabel("example-one");
                trademark.addLabel("exampleone");
                trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
                trademark.setRegNum("234235");
                trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
                trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
                EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
                treatyOrStatute.setId("1234-2");
                treatyOrStatute.setName("Example One");
                treatyOrStatute.addHolder(holder);
                treatyOrStatute.addContact(contact);
                treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
                treatyOrStatute.addLabel("example-one");
                treatyOrStatute.addLabel("exampleone");
                treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
                treatyOrStatute.setRefNum("234235");
                treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
                treatyOrStatute.setTitle("Example Title");
                treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
                EPPCourt court = new EPPCourt();
                court.setId("1234-2");
                court.setName("Example One");
                court.addHolder(holder);
                court.addContact(contact);
                court.addLabel("example-one");
                court.addLabel("exampleone");
                court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
                court.setRefNum("234235");
                court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
                court.setCc("US");
                court.addRegions("Reston");
                court.setCourtName("Test Court");
                EPPMark mark = new EPPMark();
                mark.addTrademark(trademark);
                mark.addTreatyOrStatute(treatyOrStatute);
                mark.addCourt(court);
                EPPIssuer issuer = new EPPIssuer("2", "Example Inc.", "support@example.tld");
                issuer.setUrl("http://www.example.tld");
                issuer.setVoice("+1.7035555555");
                issuer.setVoiceExt("1234");
                EPPSignedMark signedMark = new EPPSignedMark("1-2", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
                signedMark.sign(this.privateKey, this.certChain);
                EPPTrademark trademark2 = (EPPTrademark)trademark.clone();
                trademark2.setName("Hello World 2");
                trademark2.setLabels(null);
                trademark2.addLabel("helloworld2");
                trademark2.addLabel("hello-world2");
                trademark2.addLabel("hello-world-2");
                EPPMark mark2 = new EPPMark();
                mark2.addTrademark(trademark2);
                EPPSignedMark signedMark2 = new EPPSignedMark("123457-1", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark2);
                signedMark2.sign(this.privateKey, this.certChain);
                System.out.println("\nlaunchCreateSignedMark: Create command for sunrise application with signed mark in XML.");
                this.domain.addDomainName("XMLSIGNEDMARK.TLD");
                this.domain.setTransId("ABC-12345");
                this.domain.setAuthString("ClientX");
                if (!signedMark.validate(pkixParameters)) {
                    Assert.fail((String)"launchCreateSignedMark(): XML signed mark signature is NOT valid");
                }
                DocumentImpl doc = new DocumentImpl();
                String signedMarkXML = EPPUtil.toStringNoIndent(signedMark.encode((Document)doc));
                System.out.println("\nlaunchCreateSignedMark: signed mark = \n" + signedMarkXML);
                System.out.println("\nlaunchCreateSignedMark: base64 signed mark = \n" + new String(Base64.encodeBase64((byte[])signedMarkXML.getBytes(), (boolean)true)));
                this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
                EPPDomainCreateResp response = this.domain.sendCreate();
                System.out.println("launchCreateSignedMark: sunrise application with signed mark in XML: Response = [" + response + "]\n\n");
                assert (response.getResult().getCode() == 1001);
                assert (response.hasExtension(EPPLaunchCreData.class));
                assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
                System.out.println("\nlaunchCreateSignedMark: Create command for sunrise application with signed mark in Base64.");
                this.domain.addDomainName("BASE64SIGNEDMARK.TLD");
                this.domain.setTransId("ABC-12345");
                this.domain.setAuthString("ClientX");
                EPPEncodedSignedMark encodedSignedMark = new EPPEncodedSignedMark(signedMark);
                if (!encodedSignedMark.validate(pkixParameters)) {
                    Assert.fail((String)"launchCreateSignedMark(): Encoded signed mark signature is NOT valid");
                }
                this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), encodedSignedMark, "application"));
                response = this.domain.sendCreate();
                System.out.println("launchCreateSignedMark: sunrise application with signed mark in Base64: Response = [" + response + "]\n\n");
                assert (response.getResult().getCode() == 1001);
                assert (response.hasExtension(EPPLaunchCreData.class));
                assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
                System.out.println("\nlaunchCreateSignedMark: Create command for sunrise application with list of signed marks in Base64.");
                this.domain.addDomainName("BASE64SIGNEDMARKLIST.TLD");
                this.domain.setTransId("ABC-12345");
                this.domain.setAuthString("ClientX");
                EPPLaunchCreate theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "application");
                theExt.addSignedMark(new EPPEncodedSignedMark(signedMark));
                theExt.addSignedMark(new EPPEncodedSignedMark(signedMark2));
                this.domain.addExtension(theExt);
                response = this.domain.sendCreate();
                System.out.println("launchCreateSignedMark: Sunrise application with list of signed marks in Base64: Response = [" + response + "]\n\n");
                assert (response.getResult().getCode() == 1001);
                assert (response.hasExtension(EPPLaunchCreData.class));
                assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
                System.out.println("\nlaunchCreateSignedMark: Create command for sunrise registration with list of signed marks in Base64.");
                this.domain.addDomainName("REG1.TLD");
                this.domain.setTransId("ABC-12345");
                this.domain.setAuthString("ClientX");
                theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "registration");
                theExt.addSignedMark(new EPPEncodedSignedMark(signedMark));
                theExt.addSignedMark(new EPPEncodedSignedMark(signedMark2));
                this.domain.addExtension(theExt);
                response = this.domain.sendCreate();
                System.out.println("launchCreateSignedMark: Sunrise registration with list of signed marks in Base64: Response = [" + response + "]\n\n");
                assert (response.getResult().getCode() == 1000);
                assert (!response.hasExtension(EPPLaunchCreData.class));
                System.out.println("\nlaunchCreateSignedMark: Create command for sunrise registration with revoked certificate.");
                this.domain.addDomainName("REVOKEDCERT.TLD");
                this.domain.setTransId("ABC-12345");
                this.domain.setAuthString("ClientX");
                String revokedKeystore = Environment.getProperty("EPP.SignedMark.revokedKeystore");
                assert (revokedKeystore != null);
                String keyAlias = Environment.getOption("EPP.SignedMark.keyAlias");
                assert (keyAlias != null);
                String passphrase = Environment.getOption("EPP.SignedMark.passphrase");
                PrivateKey revokedPrivateKey = null;
                Certificate[] revokedCertChain = null;
                assert (passphrase != null);
                try {
                    KeyStore.PrivateKeyEntry keyEntry = EPPLaunchTst.loadPrivateKeyEntry(revokedKeystore, keyAlias, passphrase);
                    revokedPrivateKey = keyEntry.getPrivateKey();
                    revokedCertChain = keyEntry.getCertificateChain();
                }
                catch (Exception ex) {
                    Assert.fail((String)("launchCreateSignedMark: Error loading the revoked private key and certificate chain: + " + ex));
                }
                EPPSignedMark signedMark3 = new EPPSignedMark("1-2", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
                signedMark3.sign(revokedPrivateKey, revokedCertChain);
                theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "registration");
                theExt.addSignedMark(signedMark3);
                this.domain.addExtension(theExt);
                try {
                    response = this.domain.sendCreate();
                    Assert.fail((String)"launchCreateSignedMark: Create command with revoked certificate should have failed");
                }
                catch (EPPCommandException e) {
                    if ($assertionsDisabled || e.getResponse().getResult().getCode() == 2004) break block24;
                    throw new AssertionError();
                }
            }
            System.out.println("launchCreateSignedMark: Create command for sunrise registration with revoked certificate successful\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (CloneNotSupportedException e) {
            this.handleException(e);
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        this.printEnd("launchCreateSignedMark");
    }

    public void launchCreateActiveSMD() {
        this.printStart("launchCreateActiveSMD");
        try {
            FileInputStream activeSMDStream = new FileInputStream(smdsDir + "/smd-active/smd-active-25nov13-en.smd");
            EPPEncodedSignedMark encodedSignedMark = new EPPEncodedSignedMark(activeSMDStream);
            System.out.println("\nlaunchCreateActiveSMD: Create command for ACTIVESMD.TLD sunrise application with encoded signed mark.");
            this.domain.addDomainName("ACTIVESMD.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            if (!encodedSignedMark.validate(pkixParameters)) {
                Assert.fail((String)"launchCreateActiveSMD(): Active encoded signed mark NOT valid");
            }
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), encodedSignedMark, "application"));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("launchCreateActiveSMD: sunrise application with active encoded signed mark: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            System.out.println("\nlaunchCreateActiveSMD: Create command for ACTIVESMD.TLD sunrise application with signed mark.");
            EPPSignedMark signedMark = new EPPSignedMark(encodedSignedMark);
            System.out.println("\nlaunchCreateActiveSMD: Signed mark XML = [" + new String(signedMark.encode()) + "]");
            this.domain.addDomainName("ACTIVESMD.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            if (!signedMark.validate(pkixParameters)) {
                Assert.fail((String)"launchCreateActiveSMD(): Active signed mark NOT valid");
            }
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateActiveSMD: sunrise application with active signed mark: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        catch (FileNotFoundException e) {
            this.handleException(e);
        }
        this.printEnd("launchCreateActiveSMD");
    }

    public void launchPollMessaging() {
        this.printStart("launchPollMessaging");
        try {
            this.session.setPollOp("req");
            EPPResponse response = this.session.sendPoll();
            while (response.getResult().getCode() == 1301) {
                this.session.setPollOp("ack");
                this.session.setMsgID(response.getMsgQueue().getId());
                response = this.session.sendPoll();
            }
            EPPMarkContact holder = new EPPMarkContact();
            holder.setEntitlement("owner");
            holder.setOrg("Example Inc.");
            EPPMarkAddress holderAddress = new EPPMarkAddress();
            holderAddress.addStreet("123 Example Dr.");
            holderAddress.addStreet("Suite 100");
            holderAddress.setCity("Reston");
            holderAddress.setSp("VA");
            holderAddress.setPc("20190");
            holderAddress.setCc("US");
            holder.setAddress(holderAddress);
            EPPMarkContact contact = new EPPMarkContact();
            contact.setType("owner");
            contact.setName("John Doe");
            contact.setOrg("Example Inc.");
            EPPMarkAddress contactAddress = new EPPMarkAddress();
            contactAddress.addStreet("123 Example Dr.");
            contactAddress.addStreet("Suite 100");
            contactAddress.setCity("Reston");
            contactAddress.setSp("VA");
            contactAddress.setPc("20166-6503");
            contactAddress.setCc("US");
            contact.setAddress(contactAddress);
            contact.setVoice("+1.7035555555");
            contact.setVoiceExt("1234");
            contact.setFax("+1.7035555556");
            contact.setEmail("jdoe@example.tld");
            EPPTrademark trademark = new EPPTrademark();
            trademark.setId("1234-2");
            trademark.setName("Example One");
            trademark.addHolder(holder);
            trademark.addContact(contact);
            trademark.setJurisdiction("US");
            trademark.addClass("35");
            trademark.addClass("36");
            trademark.addLabel("example-one");
            trademark.addLabel("exampleone");
            trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            trademark.setRegNum("234235");
            trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
            trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
            EPPMark mark = new EPPMark();
            mark.addTrademark(trademark);
            EPPIssuer issuer = new EPPIssuer("2", "Example Inc.", "support@example.tld");
            issuer.setUrl("http://www.example.tld");
            issuer.setVoice("+1.7035555555");
            issuer.setVoiceExt("1234");
            EPPSignedMark signedMark = new EPPSignedMark("1-2", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
            signedMark.sign(this.privateKey, this.certChain);
            System.out.println("\nlaunchPollMessaging: Create a sunrise application APPPENDINGALLOCATION.TLD.");
            this.domain.addDomainName("APPPENDINGALLOCATION.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
            response = this.domain.sendCreate();
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response.getMsgQueue().getCount() == 2L);
            assert (response instanceof EPPDomainInfoResp);
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("validated"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response instanceof EPPDomainInfoResp);
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("pendingAllocation"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            System.out.println("launchPollMessaging: Create a sunrise application APPPENDINGALLOCATION.TLD successful\n\n");
            System.out.println("\nlaunchPollMessaging: Create a sunrise application APPREJECTEDINVALID.TLD.");
            this.domain.addDomainName("APPREJECTEDINVALID.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
            response = this.domain.sendCreate();
            String createServerTransId = response.getTransId().getServerTransId();
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response.getMsgQueue().getCount() == 2L);
            assert (response instanceof EPPDomainInfoResp);
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("invalid"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response instanceof EPPDomainPendActionMsg);
            EPPDomainPendActionMsg pendActionMsg = (EPPDomainPendActionMsg)response;
            assert (!pendActionMsg.isPASuccess());
            assert (pendActionMsg.getPendingTransId().getServerTransId().equals(createServerTransId));
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("rejected"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            System.out.println("launchPollMessaging: Create a sunrise application APPREJECTEDINVALID.TLD successful\n\n");
            System.out.println("\nlaunchPollMessaging: Create a sunrise application APPALLOCATEDALLSTATES.TLD.");
            this.domain.addDomainName("APPALLOCATEDALLSTATES.TLD");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
            response = this.domain.sendCreate();
            createServerTransId = response.getTransId().getServerTransId();
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response.getMsgQueue().getCount() == 3L);
            assert (response instanceof EPPDomainInfoResp);
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("validated"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response instanceof EPPDomainInfoResp);
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("pendingValidation"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            assert (response instanceof EPPDomainPendActionMsg);
            pendActionMsg = (EPPDomainPendActionMsg)response;
            assert (pendActionMsg.isPASuccess());
            assert (pendActionMsg.getPendingTransId().getServerTransId().equals(createServerTransId));
            assert (response.hasExtension(EPPLaunchInfData.class));
            assert (((EPPLaunchInfData)response.getExtension(EPPLaunchInfData.class)).getStatus().getStatus().equals("allocated"));
            this.session.setPollOp("ack");
            this.session.setMsgID(response.getMsgQueue().getId());
            response = this.session.sendPoll();
            System.out.println("launchPollMessaging: Create a sunrise application APPALLOCATEDALLSTATES.TLD successful\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        this.printEnd("launchPollMessaging");
    }

    public void launchCreateGeneric() {
        this.printStart("launchCreateGeneric");
        try {
            System.out.println("launchCreateGeneric: Create command for landrush with no type defined.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush")));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("launchCreateGeneric: landrush with no type defined: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1000);
            System.out.println("launchCreateGeneric: Create create command for a landrush application.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush"), "application"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateGeneric: Create create command for a landrush application: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            System.out.println("launchCreateGeneric: Create create command for a landrush registration.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("landrush"), "registration"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateGeneric: Create create command for a landrush application: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1000);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("launchCreateGeneric");
    }

    public void launchCreateNotice() {
        this.printStart("launchCreateNotice");
        try {
            System.out.println("\nlaunchCreateNotice: Create command for CLAIMS with notice information.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("claims"), new EPPLaunchNotice("49FD46E6C4B45C55D4AC", new Date(), new Date()), "registration"));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("\nlaunchCreateNotice: Create command for CLAIMS with notice information and validatorID's.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            EPPLaunchCreate launchCreate = new EPPLaunchCreate(new EPPLaunchPhase("claims"));
            launchCreate.setType("registration");
            launchCreate.addNotice(new EPPLaunchNotice("370d0b7c9223372036854775807", new Date(), new Date(), "tmch"));
            launchCreate.addNotice(new EPPLaunchNotice("470d0b7c9223654313275808", new Date(), new Date(), "custom-tmch"));
            this.domain.addExtension(launchCreate);
            response = this.domain.sendCreate();
            System.out.println("launchCreateNotice: CLAIMS registration with notice information: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1000);
            System.out.println("launchCreateNotice: Create command for CLAIMS application without notice information.");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("claims"), "application"));
            response = this.domain.sendCreate();
            System.out.println("launchCreateNotice: Create command for CLAIMS without notice information: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("launchCreateNotice");
    }

    public void launchUpdate() {
        this.printStart("launchUpdate");
        try {
            System.out.println("\nlaunchUpdate: Update command for sunrise application \"abc123\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setUpdateAttrib(0, "ns2.example.tld", 1);
            this.domain.setUpdateAttrib(0, "ns1.example.tld", 2);
            this.domain.addExtension(new EPPLaunchUpdate(new EPPLaunchPhase("sunrise"), "abc123"));
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("launchUpdate: Sunrise application update response = [" + response + "]\n\n");
            System.out.println("\nlaunchUpdate: Update command for landrush application \"abc123\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.setUpdateAttrib(0, "ns1.example.tld", 1);
            this.domain.setUpdateAttrib(0, "ns2.example.tld", 2);
            this.domain.addExtension(new EPPLaunchUpdate(new EPPLaunchPhase("landrush"), "abc123"));
            response = this.domain.sendUpdate();
            System.out.println("launchUpdate: Landrush application update response = [" + response + "]\n\n");
            System.out.println("\nlaunchUpdate: Update command for unsupported phase \"CLAIMS\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.addExtension(new EPPLaunchUpdate(new EPPLaunchPhase("claims"), "abc123"));
            response = null;
            try {
                response = this.domain.sendUpdate();
            }
            catch (EPPCommandException ex) {
                System.out.println("launchUpdate: Update with Unsupported Phase Expected Error Response = [" + ex.getResponse() + "]\n\n");
            }
            if (response != null) {
                Assert.fail((String)"launchUpdate: Update with unsupported Phase should have failed");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("launchUpdate");
    }

    public void launchDelete() {
        this.printStart("launchDelete");
        try {
            System.out.println("\nlaunchDelete: Update command for sunrise application \"abc123\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.addExtension(new EPPLaunchDelete(new EPPLaunchPhase("sunrise"), "abc123"));
            EPPResponse response = this.domain.sendDelete();
            System.out.println("launchUpdate: Sunrise application delete response = [" + response + "]\n\n");
            System.out.println("\nlaunchUpdate: Delete command for landrush application \"abc123\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.addExtension(new EPPLaunchDelete(new EPPLaunchPhase("landrush"), "abc123"));
            response = this.domain.sendDelete();
            System.out.println("launchUpdate: Landrush application delete response = [" + response + "]\n\n");
            System.out.println("\nlaunchUpdate: Delete command for unsupported phase \"CLAIMS\"");
            this.domain.addDomainName("example.tld");
            this.domain.setTransId("ABC-12345");
            this.domain.addExtension(new EPPLaunchDelete(new EPPLaunchPhase("claims"), "abc123"));
            response = null;
            try {
                response = this.domain.sendDelete();
            }
            catch (EPPCommandException ex) {
                System.out.println("launchUpdate: Delete with Unsupported Phase Expected Error Response = [" + ex.getResponse() + "]\n\n");
            }
            if (response != null) {
                Assert.fail((String)"launchUpdate: Delete with unsupported Phase should have failed");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("launchDelete");
    }

    public void launchTMCHPendingSunrise() {
        this.printStart("launchTMCHPendingSunrise");
        String domainName = "APPTMCHPENDINGSUNRISE.TLD";
        try {
            EPPMarkContact holder = new EPPMarkContact();
            holder.setEntitlement("owner");
            holder.setOrg("Example Inc.");
            EPPMarkAddress holderAddress = new EPPMarkAddress();
            holderAddress.addStreet("123 Example Dr.");
            holderAddress.addStreet("Suite 100");
            holderAddress.setCity("Reston");
            holderAddress.setSp("VA");
            holderAddress.setPc("20190");
            holderAddress.setCc("US");
            holder.setAddress(holderAddress);
            EPPMarkContact contact = new EPPMarkContact();
            contact.setType("owner");
            contact.setName("John Doe");
            contact.setOrg("Example Inc.");
            EPPMarkAddress contactAddress = new EPPMarkAddress();
            contactAddress.addStreet("123 Example Dr.");
            contactAddress.addStreet("Suite 100");
            contactAddress.setCity("Reston");
            contactAddress.setSp("VA");
            contactAddress.setPc("20166-6503");
            contactAddress.setCc("US");
            contact.setAddress(contactAddress);
            contact.setVoice("+1.7035555555");
            contact.setVoiceExt("1234");
            contact.setFax("+1.7035555556");
            contact.setEmail("jdoe@example.tld");
            EPPTrademark trademark = new EPPTrademark();
            trademark.setId("1234-2");
            trademark.setName("Example One");
            trademark.addHolder(holder);
            trademark.addContact(contact);
            trademark.setJurisdiction("US");
            trademark.addClass("35");
            trademark.addClass("36");
            trademark.addLabel("example-one");
            trademark.addLabel("exampleone");
            trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            trademark.setRegNum("234235");
            trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
            trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
            EPPTreatyOrStatute treatyOrStatute = new EPPTreatyOrStatute();
            treatyOrStatute.setId("1234-2");
            treatyOrStatute.setName("Example One");
            treatyOrStatute.addHolder(holder);
            treatyOrStatute.addContact(contact);
            treatyOrStatute.addProtection(new EPPProtection("US", "Reston", "US"));
            treatyOrStatute.addLabel("example-one");
            treatyOrStatute.addLabel("exampleone");
            treatyOrStatute.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            treatyOrStatute.setRefNum("234235");
            treatyOrStatute.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
            treatyOrStatute.setTitle("Example Title");
            treatyOrStatute.setExecDate(new GregorianCalendar(2015, 8, 16).getTime());
            EPPCourt court = new EPPCourt();
            court.setId("1234-2");
            court.setName("Example One");
            court.addHolder(holder);
            court.addContact(contact);
            court.addLabel("example-one");
            court.addLabel("exampleone");
            court.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
            court.setRefNum("234235");
            court.setProDate(new GregorianCalendar(2009, 8, 16).getTime());
            court.setCc("US");
            court.addRegions("Reston");
            court.setCourtName("Test Court");
            EPPMark mark = new EPPMark();
            mark.addTrademark(trademark);
            mark.addTreatyOrStatute(treatyOrStatute);
            mark.addCourt(court);
            EPPIssuer issuer = new EPPIssuer("2", "Example Inc.", "support@example.tld");
            issuer.setUrl("http://www.example.tld");
            issuer.setVoice("+1.7035555555");
            issuer.setVoiceExt("1234");
            EPPSignedMark signedMark = new EPPSignedMark("1-2", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark);
            signedMark.sign(this.privateKey, this.certChain);
            EPPTrademark trademark2 = (EPPTrademark)mark.clone();
            trademark2.setId("1234-21");
            EPPMark mark2 = new EPPMark();
            mark2.addTrademark(trademark2);
            EPPSignedMark signedMark2 = new EPPSignedMark("123457", issuer, new GregorianCalendar(2012, 8, 16).getTime(), new GregorianCalendar(2013, 8, 16).getTime(), mark2);
            signedMark2.sign(this.privateKey, this.certChain);
            System.out.println("\nlaunchTMCHPendingSunrise: Create command for sunrise application 1 with signed mark in XML.");
            this.domain.addDomainName(domainName);
            this.domain.setTransId("ABC-123451");
            this.domain.setAuthString("ClientX");
            this.domain.addExtension(new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), signedMark, "application"));
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("launchTMCHPendingSunrise: sunrise application 1 with signed mark in XML: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            String applicationId1 = ((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId();
            System.out.println("\nlaunchTMCHPendingSunrise: Create command for sunrise application 2 with signed mark in Base64.");
            this.domain.addDomainName(domainName);
            this.domain.setTransId("ABC-123452");
            this.domain.setAuthString("ClientX");
            EPPLaunchCreate theExt = new EPPLaunchCreate(new EPPLaunchPhase("sunrise"), "application");
            theExt.addSignedMark(new EPPEncodedSignedMark(signedMark));
            this.domain.addExtension(theExt);
            response = this.domain.sendCreate();
            System.out.println("launchTMCHPendingSunrise: Sunrise application 2 with signed mark in Base64: Response = [" + response + "]\n\n");
            assert (response.getResult().getCode() == 1001);
            assert (response.hasExtension(EPPLaunchCreData.class));
            assert (((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId() != null);
            String applicationId2 = ((EPPLaunchCreData)response.getExtension(EPPLaunchCreData.class)).getApplicationId();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        catch (CloneNotSupportedException e) {
            this.handleException(e);
        }
        catch (EPPException e) {
            this.handleException(e);
        }
        this.printEnd("launchTMCHPendingSunrise");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
            String keystore = Environment.getProperty("EPP.SignedMark.keystore");
            assert (keystore != null);
            String keyAlias = Environment.getOption("EPP.SignedMark.keyAlias");
            assert (keyAlias != null);
            String passphrase = Environment.getOption("EPP.SignedMark.passphrase");
            assert (passphrase != null);
            try {
                KeyStore.PrivateKeyEntry keyEntry = EPPLaunchTst.loadPrivateKeyEntry(keystore, keyAlias, passphrase);
                this.privateKey = keyEntry.getPrivateKey();
                this.certChain = keyEntry.getCertificateChain();
            }
            catch (Exception ex) {
                cat.error((Object)("LaunchDomainHandler.LaunchDomainHandler(): Error loading the private key and certificate chain: " + ex));
                ex.printStackTrace();
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
        this.launch = new EPPLaunch(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPLaunchTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        try {
            ArrayList<String> crls = new ArrayList<String>();
            crls.add("eppsdk.crl");
            crls.add("tmch-pilot.crl");
            pkixParameters = com.verisign.epp.codec.launch.EPPLaunchTst.loadPKIXParameters("signedMarkTrust.jks", crls);
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading trust store: " + ex));
        }
        smdsDir = Environment.getProperty("EPP.SMD.dir");
        assert (smdsDir != null);
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse domainResponse = this.session.getResponse();
        aException.printStackTrace();
        if (domainResponse != null && !domainResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + domainResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPLaunchTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLaunchTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".tld");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }

    static {
        app = EPPApplicationSingle.getInstance();
        configFileName = "epp.config";
        cat = Logger.getLogger((String)EPPLaunchTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    }
}

