/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoCmd;
import com.verisign.epp.codec.suggestion.EPPSuggestionMapFactory;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPSuggestionHandler
implements EPPEventHandler {
    private static final String NS = "http://www.verisign-grs.com/epp/suggestion-1.1";
    private static final Logger cat = Logger.getLogger((String)EPPSuggestionHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPSuggestionHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPSuggestionMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory for the Suggestion Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (!(message instanceof EPPSuggestionInfoCmd)) {
            throw new EPPEventException("In EPPSuggestionHandler an unsupported event was found");
        }
        EPPEventResponse response = this.doSuggestionInfo(aEvent, aData);
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doSuggestionInfo(EPPEvent var1, Object var2);
}

