/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.syncext;

import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.syncext.EPPSyncExtUpdate;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPSyncExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPSyncExtTst(String name) {
        super(name);
    }

    public void testDomainUpdateCommandWithSyncExt() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithSyncExt");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345-XYZ");
        EPPSyncExtUpdate syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(11);
        syncUpdate.setDay(30);
        theCommand.addExtension(syncUpdate);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example2.com");
        theCommand.setTransId("ABC-12345-XYZ");
        syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(0);
        syncUpdate.setDay(1);
        theCommand.addExtension(syncUpdate);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example3.com");
        theCommand.setTransId("ABC-12345-XYZ");
        syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(1);
        syncUpdate.setDay(29);
        theCommand.addExtension(syncUpdate);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithSyncExt");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPSyncExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.syncext.EPPSyncExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPSyncExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSyncExtTst Thread " + i, EPPSyncExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSyncExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

