/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion.util;

import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import java.io.Serializable;

public abstract class Enum
implements Serializable {
    private static final long serialVersionUID = -2861077875297605836L;
    public static int NONE = -1;
    public static String NONE_STRING = "";
    protected int key = NONE;

    public Enum() {
    }

    public Enum(String aValue) throws InvalidValueException {
        this.set(aValue);
    }

    protected Enum(int aKey) throws InvalidValueException {
        this.set(aKey);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            Enum other = (Enum)o;
            return this.key == other.key;
        }
        return false;
    }

    public int get() {
        return this.key;
    }

    public boolean isSet() {
        return this.key != NONE;
    }

    public void set(int aKey) throws InvalidValueException {
        String[] data = this.getData();
        if (aKey < 0 || aKey >= data.length) {
            throw new InvalidValueException((long)aKey);
        }
        this.key = aKey;
    }

    public void set(String aValue) throws InvalidValueException {
        this.key = this.decode(aValue);
    }

    public String toLogString() {
        if (this.isSet()) {
            return "" + this.getData()[this.key].charAt(0);
        }
        return NONE_STRING;
    }

    public String toString() {
        if (this.isSet()) {
            return this.getData()[this.key];
        }
        return NONE_STRING;
    }

    public void unset() {
        this.key = NONE;
    }

    public abstract String[] getData();

    private int decode(String aValue) throws InvalidValueException {
        if (aValue == null || aValue.length() == 0) {
            return NONE;
        }
        String[] data = this.getData();
        for (int i = 0; i < data.length; ++i) {
            if (!aValue.equalsIgnoreCase(data[i])) continue;
            return i;
        }
        throw new InvalidValueException((Object)aValue);
    }
}

