/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionRecord;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EPPSuggestionGrid
implements EPPCodecComponent {
    private static final long serialVersionUID = -1986013047045847256L;
    static final String ELM_NAME = "suggestion:grid";
    private List<EPPSuggestionRecord> records = null;

    public EPPSuggestionGrid() {
    }

    public EPPSuggestionGrid(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public List<EPPSuggestionRecord> getRecords() {
        return this.records;
    }

    public void addRecord(EPPSuggestionRecord aRecord) throws InvalidValueException {
        if (aRecord == null) {
            throw new InvalidValueException((Object)"Cannot add a null Record");
        }
        if (this.records == null) {
            this.resetRecords();
        }
        this.records.add(aRecord);
    }

    public void resetRecords() {
        this.records = new ArrayList<EPPSuggestionRecord>();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionGrid)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        NodeList nodes = aElement.getChildNodes();
        Node node = null;
        this.resetRecords();
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.records.add(new EPPSuggestionRecord((Element)node));
        }
        if (this.records.size() == 0) {
            this.records = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.records != null) {
            EPPUtil.encodeCompList(aDocument, root, this.records);
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionGrid other = (EPPSuggestionGrid)o;
            return EqualityUtil.equals(this.records, other.records);
        }
        return false;
    }
}

