/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionCoordinates
implements EPPCodecComponent {
    private static final long serialVersionUID = -8207657241760578301L;
    private static final String ATT_LAT = "lat";
    private static final String ATT_LNG = "lng";
    static final String ELM_NAME = "suggestion:coordinates";
    private Double lat = null;
    private Double lng = null;

    public EPPSuggestionCoordinates() {
    }

    public EPPSuggestionCoordinates(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public EPPSuggestionCoordinates(double aLat, double aLng) throws InvalidValueException {
        this();
        this.setLat(aLat);
        this.setLng(aLng);
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLng() {
        return this.lng;
    }

    public void setLat(Double aLat) {
        this.lat = aLat;
    }

    public void setLng(Double aLng) {
        this.lng = aLng;
    }

    public void setLat(String aLatAsString) {
        if (aLatAsString != null && aLatAsString.length() > 0) {
            this.lat = new Double(Double.parseDouble(aLatAsString));
        }
    }

    public void setLng(String aLngAsString) {
        if (aLngAsString != null && aLngAsString.length() > 0) {
            this.lng = new Double(Double.parseDouble(aLngAsString));
        }
    }

    public String toLogString() {
        return "lat=" + this.lat + ",lng=" + this.lng;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionCoordinates)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.setLat(aElement.getAttribute(ATT_LAT));
        if (this.lat == null) {
            ExceptionUtil.missingDuringDecode(ATT_LAT);
        }
        this.setLng(aElement.getAttribute(ATT_LNG));
        if (this.lng == null) {
            ExceptionUtil.missingDuringDecode(ATT_LNG);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.lat == null) {
            ExceptionUtil.missingDuringEncode(ATT_LAT);
        }
        if (this.lng == null) {
            ExceptionUtil.missingDuringEncode(ATT_LNG);
        }
        root.setAttribute(ATT_LAT, this.lat.toString());
        root.setAttribute(ATT_LNG, this.lng.toString());
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionCoordinates other = (EPPSuggestionCoordinates)o;
            if (!EqualityUtil.equals(this.lat, other.lat)) {
                return false;
            }
            return EqualityUtil.equals(this.lng, other.lng);
        }
        return false;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

