/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.signedMark.EPPEncodedSignedMark;
import com.verisign.epp.codec.signedMark.EPPIssuer;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.EPPXMLErrorHandler;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPSignedMark
implements EPPCodecComponent {
    private static final long serialVersionUID = 3210389145062853193L;
    private static Logger cat = Logger.getLogger((String)EPPSignedMark.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String NS = "urn:ietf:params:xml:ns:signedMark-1.0";
    public static final String NS_PREFIX = "signedMark";
    public static final String NS_SCHEMA = "urn:ietf:params:xml:ns:signedMark-1.0 signedMark-1.0.xsd";
    public static final String ELM_SIGNED_MARK_LOCALNAME = "signedMark";
    public static final String ELM_SIGNED_MARK_NAME = "signedMark:signedMark";
    private static final String ELM_ID = "id";
    private static final String ELM_NOT_BEFORE = "notBefore";
    private static final String ELM_NOT_AFTER = "notAfter";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ID_VALUE = "signedMark";
    private static XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");
    private static final boolean IGNORE_XML_PARSE_EXCEPTION = true;
    private static final boolean DO_NOT_IGNORE_XML_PARSE_EXCEPTION = false;
    private String localName = "signedMark";
    private String attrIdValue = "signedMark";
    private String id;
    private EPPIssuer issuer;
    private Date notBefore;
    private Date notAfter;
    private EPPMark mark;
    private Element signedMarkElement = null;

    public EPPSignedMark() {
    }

    public EPPSignedMark(EPPEncodedSignedMark aEncodedSignedMark) {
        EPPEncodedSignedMark encodedSignedMark = aEncodedSignedMark;
        this.id = encodedSignedMark.id;
        this.issuer = encodedSignedMark.issuer;
        this.notAfter = encodedSignedMark.notAfter;
        this.notBefore = encodedSignedMark.notBefore;
        this.mark = encodedSignedMark.mark;
        this.signedMarkElement = encodedSignedMark.signedMarkElement;
    }

    public EPPSignedMark(String aId, EPPIssuer aIssuer, Date aNotBefore, Date aNotAfter, EPPMark aMark) throws EPPEncodeException, EPPDecodeException {
        this.parseAndSetSignedMarkElement(aId, aIssuer, aNotBefore, aNotAfter, aMark);
    }

    public EPPSignedMark(byte[] aSignedMarkArray) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedMark(byte[]): enter");
        this.decode(aSignedMarkArray);
        cat.debug((Object)"EPPSignedMark.decode(byte[]): exit");
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedMark.decode(Element): enter");
        this.decodeSignedMarkElement(aElement);
        cat.debug((Object)"EPPSignedMark.decode(Element): exit - normal");
    }

    protected void decode(byte[] aSignedMarkArray) throws EPPDecodeException {
        Element elm = this.parseAndGetDocElement(aSignedMarkArray);
        this.initializeObject(elm);
        this.signedMarkElement = elm;
    }

    private void initializeObject(Element aElement) throws EPPDecodeException {
        this.localName = aElement.getLocalName();
        this.attrIdValue = aElement.getAttribute("id");
        this.id = EPPUtil.decodeString(aElement, NS, "id");
        this.issuer = (EPPIssuer)EPPUtil.decodeComp(aElement, NS, "issuerInfo", EPPIssuer.class);
        this.notBefore = EPPUtil.decodeTimeInstant(aElement, NS, ELM_NOT_BEFORE);
        this.notAfter = EPPUtil.decodeTimeInstant(aElement, NS, ELM_NOT_AFTER);
        this.mark = (EPPMark)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark", EPPMark.class);
    }

    private void decodeSignedMarkElement(Element aElement) throws EPPDecodeException {
        this.initializeObject(aElement);
        try {
            this.signedMarkElement = this.parseAndGetDocElement(this.getByteArrayForElement(aElement));
        }
        catch (EPPEncodeException e) {
            throw new EPPDecodeException(e);
        }
    }

    public byte[] encode() throws EPPEncodeException {
        return this.getByteArrayForElement(this.signedMarkElement);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug((Object)"EPPSignedMark.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedMark.encode(Document)");
        }
        if (this.signedMarkElement == null) {
            throw new EPPEncodeException("Signed mark is not decoded properly.");
        }
        Node newAddedNode = aDocument.importNode(this.signedMarkElement, true);
        cat.debug((Object)"EPPSignedMark.encode(Document): exit - normal");
        return (Element)newAddedNode;
    }

    private void validateRequiredAttributes() throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("Signed mark id is required.");
        }
        if (this.issuer == null) {
            throw new EPPEncodeException("Signed mark issuer is required.");
        }
        if (this.notBefore == null) {
            throw new EPPEncodeException("Signed mark notBefore is required.");
        }
        if (this.notAfter == null) {
            throw new EPPEncodeException("Signed mark notAfter is required.");
        }
        if (this.mark == null) {
            throw new EPPEncodeException("Signed mark mark is required.");
        }
    }

    private void parseAndSetSignedMarkElement(String aId, EPPIssuer aIssuer, Date aNotBefore, Date aNotAfter, EPPMark aMark) throws EPPEncodeException {
        this.id = aId;
        this.issuer = aIssuer;
        this.notBefore = aNotBefore;
        this.notAfter = aNotAfter;
        this.mark = aMark;
        this.validateRequiredAttributes();
        DocumentImpl document = new DocumentImpl();
        Element root = document.createElementNS(NS, "signedMark:" + this.localName);
        root.setAttribute("id", this.attrIdValue);
        root.setIdAttribute("id", true);
        EPPUtil.encodeString((Document)document, root, this.id, NS, "signedMark:id");
        EPPUtil.encodeComp((Document)document, root, this.issuer);
        EPPUtil.encodeTimeInstant((Document)document, root, this.notBefore, NS, "signedMark:notBefore");
        EPPUtil.encodeTimeInstant((Document)document, root, this.notAfter, NS, "signedMark:notAfter");
        EPPUtil.encodeComp((Document)document, root, this.mark);
        document.appendChild(root);
        byte[] xmlBytes = this.getByteArrayForElement(root);
        try {
            this.signedMarkElement = this.parseAndGetDocElement(xmlBytes, true);
        }
        catch (EPPDecodeException e) {
            throw new EPPEncodeException(e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSignedMark clone = (EPPSignedMark)super.clone();
        if (this.issuer != null) {
            clone.issuer = (EPPIssuer)this.issuer.clone();
        }
        if (this.mark != null) {
            clone.mark = (EPPMark)this.mark.clone();
        }
        return clone;
    }

    public void sign(PrivateKey aPrivateKey) throws EPPException {
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey): enter");
        this.sign(aPrivateKey, null);
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey): exit");
    }

    public void sign(PrivateKey aPrivateKey, Certificate[] aCertChain) throws EPPException {
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): enter");
        if (aPrivateKey == null) {
            throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): null aPrivateKey parameter");
        }
        try {
            DigestMethod digestMethod = sigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            ArrayList<Transform> transforms = new ArrayList<Transform>();
            transforms.add(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference xmlSigRef = sigFactory.newReference("#" + this.attrIdValue, digestMethod, transforms, null, null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(xmlSigRef));
            KeyInfo keyInfo = null;
            if (aCertChain != null) {
                cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): certificate chain passed");
                KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                for (Certificate cert : aCertChain) {
                    if (cert == null || !(cert instanceof X509Certificate)) {
                        throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): Null or invalid certificate type");
                    }
                    certChain.add((X509Certificate)cert);
                    cat.debug((Object)("EPPSignedMark.sign(PrivateKey, Certificate[]): Added certificate [" + cert + "] to X509Certificate list"));
                }
                ArrayList<X509Data> certDataList = new ArrayList<X509Data>();
                certDataList.add(keyInfoFactory.newX509Data(certChain));
                keyInfo = keyInfoFactory.newKeyInfo(certDataList);
            } else {
                cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): null certificate chain passed, no certificates added");
            }
            DOMSignContext signContext = new DOMSignContext(aPrivateKey, (Node)this.signedMarkElement);
            signContext.setDefaultNamespacePrefix("dsig");
            XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            signature.sign(signContext);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cat.error((Object)("Error signing the EPPSignedMark: " + ex));
            throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): Error signing the EPPSignedMark");
        }
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): exit");
    }

    public boolean validate(PKIXParameters aPKIXParameters) {
        return this.validate(aPKIXParameters, true);
    }

    private Element findSignatureElement() {
        return EPPUtil.getElementByTagNameNS(this.signedMarkElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(PKIXParameters aPKIXParameters, boolean aSynchronizePKIXParameters) {
        cat.debug((Object)"validate(PKIXParameters): enter");
        boolean valid = false;
        try {
            Element sigElement = this.findSignatureElement();
            DOMStructure domStructure = new DOMStructure(sigElement);
            XMLSignature signature = sigFactory.unmarshalXMLSignature(domStructure);
            if (signature.getKeyInfo() == null) {
                throw new Exception("No key info found in Signature");
            }
            ArrayList<X509Certificate> certificates = null;
            List<XMLStructure> keyContent = signature.getKeyInfo().getContent();
            for (XMLStructure currInfo : keyContent) {
                if (currInfo instanceof X509Data) {
                    List<?> x509Data = ((X509Data)currInfo).getContent();
                    if (x509Data == null) continue;
                    for (Object currX509Data : x509Data) {
                        if (!(currX509Data instanceof X509Certificate)) continue;
                        if (certificates == null) {
                            certificates = new ArrayList<X509Certificate>();
                        }
                        X509Certificate x509Cert = (X509Certificate)currX509Data;
                        x509Cert.checkValidity();
                        cat.debug((Object)("validate(PKIXParameters): Found X509Certificate [" + x509Cert + "]"));
                        certificates.add(x509Cert);
                    }
                }
                if (certificates == null || certificates.isEmpty()) {
                    throw new Exception("No certificates found in Signature");
                }
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certFactory.generateCertPath((List<? extends Certificate>)certificates);
                CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX");
                if (aSynchronizePKIXParameters) {
                    PKIXParameters pKIXParameters = aPKIXParameters;
                    synchronized (pKIXParameters) {
                        pathValidator.validate(certPath, aPKIXParameters);
                        continue;
                    }
                }
                pathValidator.validate(certPath, aPKIXParameters);
            }
            X509Certificate cert = (X509Certificate)certificates.get(0);
            cat.debug((Object)("validate(PKIXParameters): Getting public key from top certificate [" + cert + "]"));
            PublicKey publicKey = cert.getPublicKey();
            valid = this.validate(sigElement, publicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PKIXParameters): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PKIXParameters): exit, valid = " + valid));
        return valid;
    }

    public boolean validate(PublicKey aPublicKey) {
        cat.debug((Object)"validate(PublicKey): enter");
        boolean valid = false;
        try {
            Element sigElm = this.findSignatureElement();
            valid = this.validate(sigElm, aPublicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PublicKey): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PublicKey): exit, valid = " + valid));
        return valid;
    }

    private byte[] getByteArrayForElement(Element aElement) throws EPPEncodeException {
        cat.debug((Object)"EPPSignedMark.getByteArrayForElement(): enter");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(aElement), new StreamResult(os));
        }
        catch (Exception ex) {
            cat.error((Object)("Error encoding signed mark to byte[]: " + ex));
            throw new EPPEncodeException("Error encoding signed mark to byte[]");
        }
        cat.debug((Object)"EPPSignedMark.getByteArrayForElement(): exit");
        return os.toByteArray();
    }

    private Element parseAndGetDocElement(byte[] aSignedMarkArray) throws EPPDecodeException {
        return this.parseAndGetDocElement(aSignedMarkArray, false);
    }

    private Element parseAndGetDocElement(byte[] aSignedMarkArray, boolean aIgnoreParsingError) throws EPPDecodeException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(aSignedMarkArray);
            EPPSchemaCachingParser parser = new EPPSchemaCachingParser();
            parser.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            if (!aIgnoreParsingError) {
                parser.setErrorHandler(new EPPXMLErrorHandler());
            }
            Document doc = parser.parse(is);
            Element elm = doc.getDocumentElement();
            elm.setIdAttribute("id", true);
            Element element = elm;
            return element;
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding signed mark array: " + ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSignedMark)) {
            cat.error((Object)"EPPSignedMark.equals(): aObject is not an EPPSignedMark");
            return false;
        }
        EPPSignedMark other = (EPPSignedMark)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error((Object)"EPPSignedMark.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.issuer, other.issuer)) {
            cat.error((Object)"EPPSignedMark.equals(): issuer not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notBefore, other.notBefore)) {
            cat.error((Object)"EPPSignedMark.equals(): notBefore not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notAfter, other.notAfter)) {
            cat.error((Object)"EPPSignedMark.equals(): notAfter not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.mark, other.mark)) {
            cat.error((Object)"EPPSignedMark.equals(): mark not equal");
            return false;
        }
        return true;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getId() {
        return this.id;
    }

    public EPPIssuer getIssuer() {
        return this.issuer;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public EPPMark getMark() {
        return this.mark;
    }

    public String getAttrIdValue() {
        return this.attrIdValue;
    }

    private boolean validate(Element aSigElm, PublicKey aPublicKey) {
        cat.debug((Object)"validate(Element, PublicKey): enter");
        boolean valid = false;
        try {
            DOMValidateContext valContext = new DOMValidateContext(aPublicKey, (Node)aSigElm);
            XMLSignature signature = sigFactory.unmarshalXMLSignature(valContext);
            if (signature.validate(valContext)) {
                valid = true;
            } else {
                valid = false;
                cat.error((Object)("validate(Element, PublicKey): validation status = " + signature.getSignatureValue().validate(valContext)));
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    Reference next = i.next();
                    cat.error((Object)("validate(Element, PublicKey): ref[" + j + "], URI = " + next.getURI() + ", validity status = " + next.validate(valContext)));
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            cat.error((Object)("validate(Element, PublicKey): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(Element, PublicKey): exit, valid = " + valid));
        return valid;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

