/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.premiumdomain;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPPremiumDomainCheckResult
implements EPPCodecComponent {
    private static final long serialVersionUID = 8455818254352957139L;
    public static final String PRICE_UNIT_USD = "USD";
    public static final String ELM_NAME = "premiumdomain:cd";
    private static final String ELM_DOMAIN_NAME = "premiumdomain:name";
    private static final String ELM_DOMAIN_PRICE = "premiumdomain:price";
    private static final String ELM_DOMAIN_RENEWAL_PRICE = "premiumdomain:renewalPrice";
    private static final String ATTR_PREMIUM = "premium";
    private static final String ATTR_PRICE_UNIT = "unit";
    private String name;
    private boolean isPremium = true;
    private BigDecimal price = null;
    private BigDecimal renewalPrice = null;
    private String priceUnit = "USD";

    public EPPPremiumDomainCheckResult() {
        this.name = null;
        this.isPremium = true;
    }

    public EPPPremiumDomainCheckResult(String aName, boolean aIsPremium) {
        this.name = aName;
        this.isPremium = aIsPremium;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPPremiumDomainCheckResult clone = (EPPPremiumDomainCheckResult)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPPremiumDomainCheckResp.encode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/premiumdomain-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_NAME);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_PREMIUM, this.isPremium);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.price != null) {
            Element priceElm = aDocument.createElementNS("http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_PRICE);
            root.appendChild(priceElm);
            DecimalFormat decFormat = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US));
            Text priceTextNode = aDocument.createTextNode(decFormat.format(this.price));
            priceElm.appendChild(priceTextNode);
            priceElm.setAttribute(ATTR_PRICE_UNIT, this.priceUnit);
            Element renewalPriceElm = aDocument.createElementNS("http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_RENEWAL_PRICE);
            root.appendChild(renewalPriceElm);
            Text renewalPriceTextNode = aDocument.createTextNode(decFormat.format(this.renewalPrice));
            renewalPriceElm.appendChild(renewalPriceTextNode);
            renewalPriceElm.setAttribute(ATTR_PRICE_UNIT, this.priceUnit);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_NAME);
        this.name = theNameElm.getFirstChild().getNodeValue();
        this.isPremium = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_PREMIUM);
        this.price = EPPUtil.decodeBigDecimal(aElement, "http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_PRICE);
        Element thePriceElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_PRICE);
        if (thePriceElm != null) {
            this.priceUnit = thePriceElm.getAttribute(ATTR_PRICE_UNIT);
        }
        this.renewalPrice = EPPUtil.decodeBigDecimal(aElement, "http://www.verisign.com/epp/premiumdomain-1.0", ELM_DOMAIN_RENEWAL_PRICE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPPremiumDomainCheckResult)) {
            return false;
        }
        EPPPremiumDomainCheckResult theComp = (EPPPremiumDomainCheckResult)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            return false;
        }
        if (this.isPremium != theComp.isPremium) {
            return false;
        }
        if (!EqualityUtil.equals(this.price, theComp.price)) {
            return false;
        }
        if (!EqualityUtil.equals(this.renewalPrice, theComp.renewalPrice)) {
            return false;
        }
        return EqualityUtil.equals(this.priceUnit, theComp.priceUnit);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public void setIsPremium(boolean aIsPremium) {
        this.isPremium = aIsPremium;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal aPrice) {
        this.price = aPrice;
    }

    public BigDecimal getRenewalPrice() {
        return this.renewalPrice;
    }

    public void setRenewalPrice(BigDecimal aRenewalPrice) {
        this.renewalPrice = aRenewalPrice;
    }

    public String getPriceUnit() {
        return this.priceUnit;
    }

    public void setPriceUnit(String aPriceUnit) {
        this.priceUnit = aPriceUnit;
    }
}

