/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.codec.mark.EPPProtection;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPTreatyOrStatute
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPTreatyOrStatute.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "treatyOrStatute";
    public static final String ELM_NAME = "mark:treatyOrStatute";
    private static final String ELM_ID = "id";
    private static final String ELM_MARK_NAME = "markName";
    private static final String ELM_LABEL = "label";
    private static final String ELM_GOODS_AND_SERVICES = "goodsAndServices";
    private static final String ELM_REF_NUM = "refNum";
    private static final String ELM_PRO_DATE = "proDate";
    private static final String ELM_TITLE = "title";
    private static final String ELM_EXEC_DATE = "execDate";
    private String id;
    private String name;
    private List<EPPMarkContact> holders = new ArrayList<EPPMarkContact>();
    private List<EPPMarkContact> contacts = new ArrayList<EPPMarkContact>();
    private List<EPPProtection> protections = new ArrayList<EPPProtection>();
    private List<String> labels = new ArrayList<String>();
    private String goodsAndServices;
    private String refNum;
    private Date proDate;
    private String title;
    private Date execDate;

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTreatyOrStatute clone = (EPPTreatyOrStatute)super.clone();
        return clone;
    }

    public byte[] encode() throws EPPEncodeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error((Object)("Error encoding treaty or statute to byte[]: " + ex));
            throw new EPPEncodeException("Error encoding treaty or statute to byte[]");
        }
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPTreatyOrStatute.encode(Document)");
        }
        if (this.id == null) {
            throw new EPPEncodeException("id is required for treaty or statute");
        }
        if (this.name == null) {
            throw new EPPEncodeException("name is required for treaty or statute");
        }
        if (this.holders == null || this.holders.isEmpty()) {
            throw new EPPEncodeException("one holder is required for treaty or statute");
        }
        if (this.protections == null || this.protections.isEmpty()) {
            throw new EPPEncodeException("one protection is required for treaty or statute");
        }
        if (this.goodsAndServices == null) {
            throw new EPPEncodeException("goodsAndServices is required for treaty or statute");
        }
        if (this.refNum == null) {
            throw new EPPEncodeException("refNum is required for treaty or statute");
        }
        if (this.proDate == null) {
            throw new EPPEncodeException("proDate is required for treaty or statute");
        }
        if (this.title == null) {
            throw new EPPEncodeException("title is required for treaty or statute");
        }
        if (this.proDate == null) {
            throw new EPPEncodeException("proDate is required for treaty or statute");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:mark-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:mark-1.0", "mark:id");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:mark-1.0", "mark:markName");
        EPPUtil.encodeCompList(aDocument, root, this.holders);
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        EPPUtil.encodeCompList(aDocument, root, this.protections);
        EPPUtil.encodeList(aDocument, root, this.labels, "urn:ietf:params:xml:ns:mark-1.0", "mark:label");
        EPPUtil.encodeString(aDocument, root, this.goodsAndServices, "urn:ietf:params:xml:ns:mark-1.0", "mark:goodsAndServices");
        EPPUtil.encodeString(aDocument, root, this.refNum, "urn:ietf:params:xml:ns:mark-1.0", "mark:refNum");
        EPPUtil.encodeTimeInstant(aDocument, root, this.proDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:proDate");
        EPPUtil.encodeString(aDocument, root, this.title, "urn:ietf:params:xml:ns:mark-1.0", "mark:title");
        EPPUtil.encodeTimeInstant(aDocument, root, this.execDate, "urn:ietf:params:xml:ns:mark-1.0", "mark:execDate");
        return root;
    }

    public void decode(byte[] aMarkArray) throws EPPDecodeException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(aMarkArray);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            this.decode(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding treaty or statute array: " + ex);
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_ID);
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_MARK_NAME);
        this.holders = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "holder", EPPMarkContact.class);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "contact", EPPMarkContact.class);
        this.protections = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "protection", EPPProtection.class);
        this.labels = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_LABEL);
        this.goodsAndServices = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_GOODS_AND_SERVICES);
        this.refNum = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_REF_NUM);
        this.proDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_PRO_DATE);
        this.title = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_TITLE);
        this.execDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:mark-1.0", ELM_EXEC_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTreatyOrStatute)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): aObject is not an EPPTreatyOrStatute");
            return false;
        }
        EPPTreatyOrStatute other = (EPPTreatyOrStatute)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.holders, other.holders)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): holders not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contacts, other.contacts)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): contacts not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.protections, other.protections)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): protections not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.labels, other.labels)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): labels not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.goodsAndServices, other.goodsAndServices)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): goodsAndServices not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.refNum, other.refNum)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): refNum not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.proDate, other.proDate)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): proDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.title, other.title)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): title not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.execDate, other.execDate)) {
            cat.error((Object)"EPPTreatyOrStatute.equals(): execDate not equal");
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public List<EPPMarkContact> getHolders() {
        return this.holders;
    }

    public void setHolders(List<EPPMarkContact> aHolders) {
        this.holders = aHolders;
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact holder : this.holders) {
            holder.setLocalName("holder");
        }
    }

    public void addHolder(EPPMarkContact aHolder) {
        if (aHolder == null) {
            return;
        }
        aHolder.setLocalName("holder");
        if (this.holders == null) {
            this.holders = new ArrayList<EPPMarkContact>();
        }
        this.holders.add(aHolder);
    }

    public List<EPPMarkContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPMarkContact> aContacts) {
        this.contacts = aContacts;
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        for (EPPMarkContact contact : this.contacts) {
            contact.setLocalName("contact");
        }
    }

    public void addContact(EPPMarkContact aContact) {
        if (aContact == null) {
            return;
        }
        aContact.setLocalName("contact");
        if (this.contacts == null) {
            this.contacts = new ArrayList<EPPMarkContact>();
        }
        this.contacts.add(aContact);
    }

    public List<EPPProtection> getProtections() {
        return this.protections;
    }

    public void setProtections(List<EPPProtection> aProtections) {
        this.protections = aProtections;
        if (this.protections == null) {
            this.protections = new ArrayList<EPPProtection>();
        }
    }

    public void addProtection(EPPProtection aProtection) {
        if (aProtection == null) {
            return;
        }
        if (this.protections == null) {
            this.protections = new ArrayList<EPPProtection>();
        }
        this.protections.add(aProtection);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> aLabels) {
        this.labels = aLabels;
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
    }

    public void addLabel(String aLabel) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(aLabel);
    }

    public String getGoodsAndServices() {
        return this.goodsAndServices;
    }

    public void setGoodsAndServices(String aGoodsAndServices) {
        this.goodsAndServices = aGoodsAndServices;
    }

    public String getRefNum() {
        return this.refNum;
    }

    public void setRefNum(String aRefNum) {
        this.refNum = aRefNum;
    }

    public Date getProDate() {
        return this.proDate;
    }

    public void setProDate(Date aProDate) {
        this.proDate = aProDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    public Date getExecDate() {
        return this.execDate;
    }

    public void setExecDate(Date aExecDate) {
        this.execDate = aExecDate;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

