/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchCodeMark
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCodeMark.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "codeMark";
    public static final String ELM_NAME = "launch:codeMark";
    private static final String ELM_CODE = "code";
    private static final String ATTR_VALIDATOR_ID = "validatorID";
    String code;
    private String validatorId = null;
    EPPMark mark;

    public EPPLaunchCodeMark() {
    }

    public EPPLaunchCodeMark(String aCode) {
        this.code = aCode;
    }

    public EPPLaunchCodeMark(String aCode, String aValidatorId) {
        this.code = aCode;
        this.validatorId = aValidatorId;
    }

    public EPPLaunchCodeMark(EPPMark aMark) {
        this.mark = aMark;
    }

    public EPPLaunchCodeMark(String aCode, EPPMark aMark) {
        this.code = aCode;
        this.mark = aMark;
    }

    public EPPLaunchCodeMark(String aCode, String aValidatorId, EPPMark aMark) {
        this.code = aCode;
        this.validatorId = aValidatorId;
        this.mark = aMark;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCodeMark clone = (EPPLaunchCodeMark)super.clone();
        if (this.mark != null) {
            clone.mark = (EPPMark)this.mark.clone();
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCodeMark.encode(Document)");
        }
        if (this.code == null && this.mark == null) {
            throw new EPPEncodeException("Both the codeMark attributes are not set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        if (this.code != null) {
            Element codeElm = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", "launch:code");
            root.appendChild(codeElm);
            Text textNode = aDocument.createTextNode(this.code);
            codeElm.appendChild(textNode);
            if (this.validatorId != null) {
                codeElm.setAttribute(ATTR_VALIDATOR_ID, this.validatorId);
            }
        }
        EPPUtil.encodeComp(aDocument, root, this.mark);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_CODE);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_CODE);
        if (currElm != null && currElm.hasAttribute(ATTR_VALIDATOR_ID)) {
            this.validatorId = currElm.getAttribute(ATTR_VALIDATOR_ID);
            if (this.validatorId != null && this.validatorId.length() == 0) {
                this.validatorId = null;
            }
        } else {
            this.validatorId = null;
        }
        this.mark = (EPPMark)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark", EPPMark.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCodeMark)) {
            cat.error((Object)"EPPLaunchCodeMark.equals(): aObject is not an EPPLaunchCodeMark");
            return false;
        }
        EPPLaunchCodeMark other = (EPPLaunchCodeMark)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPLaunchCodeMark.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.validatorId, other.validatorId)) {
            cat.error((Object)"EPPLaunchCodeMark.equals(): validatorId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.mark, other.mark)) {
            cat.error((Object)"EPPMark.equals(): mark not equal");
            return false;
        }
        return true;
    }

    public boolean hasCodeMark() {
        return this.code != null && this.mark != null;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String aValidatorId) {
        this.validatorId = aValidatorId;
    }

    public boolean hasValidatorId() {
        return this.validatorId != null;
    }

    public boolean hasMark() {
        return this.mark != null;
    }

    public EPPMark getMark() {
        return this.mark;
    }

    public void setMark(EPPMark aMark) {
        this.mark = aMark;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

