/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchClaimKey;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchCheckResult
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCheckResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "launch:cd";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ATTR_EXISTS = "exists";
    private String name;
    private boolean exists = true;
    private List<EPPLaunchClaimKey> claimKeys = new ArrayList<EPPLaunchClaimKey>();

    public EPPLaunchCheckResult() {
    }

    public EPPLaunchCheckResult(String aName, boolean aExists) {
        this.name = aName;
        this.exists = aExists;
    }

    public EPPLaunchCheckResult(String aName, boolean aExists, String aClaimKey) {
        this(aName, aExists);
        this.addClaimKey(aClaimKey);
    }

    public EPPLaunchCheckResult(String aName, boolean aExists, String aClaimKey, String aValidatorId) {
        this(aName, aExists);
        this.addClaimKey(aClaimKey, aValidatorId);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCheckResult.encode(Document)");
        }
        if (this.name == null) {
            throw new EPPEncodeException("EPPLaunchCheckResult name attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", "launch:name");
        root.appendChild(nameElm);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_EXISTS, this.exists);
        EPPUtil.encodeCompList(aDocument, root, this.claimKeys);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_DOMAIN_NAME);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_DOMAIN_NAME);
        if (currElm != null) {
            this.exists = EPPUtil.decodeBooleanAttr(currElm, ATTR_EXISTS);
        }
        this.claimKeys = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:claimKey", EPPLaunchClaimKey.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCheckResult)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): aObject is not an EPPLaunchCheckResult");
            return false;
        }
        EPPLaunchCheckResult other = (EPPLaunchCheckResult)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exists, other.exists)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): exists not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.claimKeys, other.claimKeys)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): claimKeys not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCheckResult clone = null;
        clone = (EPPLaunchCheckResult)super.clone();
        clone.claimKeys = new ArrayList<EPPLaunchClaimKey>();
        for (EPPLaunchClaimKey claimKey : this.claimKeys) {
            clone.claimKeys.add((EPPLaunchClaimKey)claimKey.clone());
        }
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean aExists) {
        this.exists = aExists;
    }

    public String getClaimKey() {
        if (!this.claimKeys.isEmpty()) {
            return this.claimKeys.get(0).getClaimKey();
        }
        return null;
    }

    public void clearClaimKeys() {
        this.claimKeys = new ArrayList<EPPLaunchClaimKey>();
    }

    public void setClaimKey(String aClaimKey) {
        this.clearClaimKeys();
        this.addClaimKey(aClaimKey);
    }

    public List<EPPLaunchClaimKey> getClaimKeys() {
        return this.claimKeys;
    }

    public void setClaimKeys(List<EPPLaunchClaimKey> aClaimKeys) {
        if (aClaimKeys != null) {
            this.claimKeys = aClaimKeys;
        } else {
            this.clearClaimKeys();
        }
    }

    public void addClaimKey(EPPLaunchClaimKey aClaimKey) {
        this.claimKeys.add(aClaimKey);
    }

    public void addClaimKey(String aClaimKey) {
        this.claimKeys.add(new EPPLaunchClaimKey(aClaimKey));
    }

    public void addClaimKey(String aClaimKey, String aValidatorIdentifier) {
        this.claimKeys.add(new EPPLaunchClaimKey(aClaimKey, aValidatorIdentifier));
    }

    public String getValidatorId() {
        if (!this.claimKeys.isEmpty()) {
            return this.claimKeys.get(0).getValidatorId();
        }
        return null;
    }

    public void setValidatorId(String aValidatorId) {
        if (!this.claimKeys.isEmpty()) {
            this.claimKeys.get(0).setValidatorId(aValidatorId);
        }
    }

    public boolean hasValidatorId() {
        return this.getValidatorId() != null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

