/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckResp;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckTable;
import com.verisign.epp.codec.idntable.EPPIdnTableDomainLabel;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoCmd;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomainTable;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoListItem;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoResp;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoTable;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPIdnTableTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPIdnTableTst(String name) {
        super(name);
    }

    public void testCheckCommand() {
        EPPCodecTst.printStart("testCheckCommand");
        EPPIdnTableCheckCmd theCommand = new EPPIdnTableCheckCmd("ABC-12345");
        theCommand.addDomain(new EPPIdnTableDomainLabel("idn1.example", EPPIdnTableDomainLabel.Form.U_LABEL));
        theCommand.addDomain(new EPPIdnTableDomainLabel("idn2.example", EPPIdnTableDomainLabel.Form.A_LABEL));
        theCommand.addDomain(new EPPIdnTableDomainLabel("idn3.example"));
        Assert.assertEquals((Object)((Object)theCommand.getForm()), (Object)((Object)EPPIdnTableCheckCmd.Form.DOMAIN_FORM));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableCheckCmd("ABC-12345");
        theCommand.addTable("CHI");
        theCommand.addTable("JPN");
        theCommand.addTable("INVALID");
        Assert.assertEquals((Object)((Object)theCommand.getForm()), (Object)((Object)EPPIdnTableCheckCmd.Form.TABLE_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckCommand");
    }

    public void testCheckResponse() {
        EPPCodecTst.printStart("testCheckResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPIdnTableCheckResp theResp = new EPPIdnTableCheckResp(theTransId);
        EPPIdnTableCheckDomain theCheckDomain = new EPPIdnTableCheckDomain("idn1.example", true);
        theCheckDomain.addTable("CHI");
        theResp.addDomain(theCheckDomain);
        theCheckDomain = new EPPIdnTableCheckDomain("idn2.example", true);
        theCheckDomain.setIdnmap(true);
        theCheckDomain.addTable("CHI");
        theCheckDomain.addTable("JPN");
        theResp.addDomain(theCheckDomain);
        theCheckDomain = new EPPIdnTableCheckDomain("idn3.example", "Commingled scripts");
        theResp.addDomain(theCheckDomain);
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableCheckResp.Form.DOMAIN_FORM));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPIdnTableCheckResp(theTransId);
        theResp.addTable(new EPPIdnTableCheckTable("CHI", true));
        theResp.addTable(new EPPIdnTableCheckTable("JPN", true));
        theResp.addTable(new EPPIdnTableCheckTable("INVALID", false));
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableCheckResp.Form.TABLE_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckResponse");
    }

    public void testInfoCommand() {
        EPPCodecTst.printStart("testInfoCommand");
        EPPIdnTableInfoCmd theCommand = new EPPIdnTableInfoCmd("ABC-12345", EPPIdnTableInfoCmd.Form.DOMAIN_FORM, "idn1.example");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableInfoCmd("ABC-12345");
        theCommand.setDomain("xn--idn1.example");
        Assert.assertEquals((Object)((Object)theCommand.getForm()), (Object)((Object)EPPIdnTableInfoCmd.Form.DOMAIN_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableInfoCmd("ABC-12345", EPPIdnTableInfoCmd.Form.TABLE_FORM, "CHI");
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableInfoCmd("ABC-12345");
        theCommand.setTable("THAI");
        Assert.assertEquals((Object)((Object)theCommand.getForm()), (Object)((Object)EPPIdnTableInfoCmd.Form.TABLE_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableInfoCmd("ABC-12345", EPPIdnTableInfoCmd.Form.LIST_FORM, null);
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPIdnTableInfoCmd("ABC-54321");
        theCommand.setForm(EPPIdnTableInfoCmd.Form.LIST_FORM);
        Assert.assertEquals((Object)((Object)theCommand.getForm()), (Object)((Object)EPPIdnTableInfoCmd.Form.LIST_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommand");
    }

    public void testInfoResponse() {
        EPPCodecTst.printStart("testInfoResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPIdnTableInfoDomain theDomain = new EPPIdnTableInfoDomain("idn1.example", true);
        theDomain.addTable(new EPPIdnTableInfoDomainTable("THAI", EPPIdnTableInfoDomainTable.Type.SCRIPT, "THAI", "en", false));
        EPPIdnTableInfoResp theResp = new EPPIdnTableInfoResp(theTransId, theDomain);
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableInfoResp.Form.DOMAIN_FORM));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theDomain = new EPPIdnTableInfoDomain("xn--idn1.example", true);
        theDomain.setIdnmap(true);
        theDomain.setUname("idn1.example");
        theDomain.addTable(new EPPIdnTableInfoDomainTable("CHI", EPPIdnTableInfoDomainTable.Type.LANGUAGE, "Chinese (CHI)", "en", true));
        theDomain.addTable(new EPPIdnTableInfoDomainTable("JPN", EPPIdnTableInfoDomainTable.Type.LANGUAGE, "Japanese (JPN)", "en", false));
        theResp = new EPPIdnTableInfoResp(theTransId, theDomain);
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableInfoResp.Form.DOMAIN_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPIdnTableInfoTable theTable = new EPPIdnTableInfoTable("CHI", EPPIdnTableInfoTable.Type.LANGUAGE, "Chinese (CHI)", new GregorianCalendar(2014, 11, 24, 9, 30).getTime());
        theTable.setVersion("1.0");
        theTable.setEffectiveDate(new GregorianCalendar(2014, 11, 24).getTime());
        theTable.setVariantGen(new Boolean(true));
        theTable.setUrl("https://www.iana.org/domains/idn-tables/tables/tld_chi_1.0.txt");
        theResp = new EPPIdnTableInfoResp(theTransId, theTable);
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableInfoResp.Form.TABLE_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theTable = new EPPIdnTableInfoTable("THAI", EPPIdnTableInfoTable.Type.SCRIPT, "Thai", new GregorianCalendar(2014, 8, 16, 9, 20).getTime());
        theTable.setVersion("1.0");
        theTable.setEffectiveDate(new GregorianCalendar(2014, 11, 24).getTime());
        theTable.setVariantGen(new Boolean(false));
        theTable.setUrl("https://www.iana.org/domains/idn-tables/tables/tld_thai_1.0.txt");
        theResp = new EPPIdnTableInfoResp(theTransId, theTable);
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableInfoResp.Form.TABLE_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPIdnTableInfoResp(theTransId);
        theResp.addListItem(new EPPIdnTableInfoListItem("CHI", new GregorianCalendar(2015, 2, 4, 9, 30).getTime()));
        theResp.addListItem(new EPPIdnTableInfoListItem("JPN", new GregorianCalendar(2015, 1, 1, 9, 40).getTime()));
        theResp.addListItem(new EPPIdnTableInfoListItem("THAI", new GregorianCalendar(2014, 8, 16, 9, 20).getTime()));
        Assert.assertEquals((Object)((Object)theResp.getForm()), (Object)((Object)EPPIdnTableInfoResp.Form.LIST_FORM));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponse");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPIdnTableTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.idntable.EPPIdnTableMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPIdnTableTst Thread " + i, EPPIdnTableTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPIdnTableTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

