/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPService
implements EPPCodecComponent {
    public static final int OBJ_SERVICE = 0;
    public static final int EXT_SERVICE = 1;
    static final String ELM_OBJ_URI = "objURI";
    static final String ELM_EXT_URI = "extURI";
    public int serviceType = 0;
    private String namespacePrefix;
    private String namespaceURI;
    private String schemaLocation;

    public EPPService() {
    }

    public EPPService(String aNamespacePrefix, String aNamespaceURI, String aSchemaLocation) {
        this.namespacePrefix = aNamespacePrefix;
        this.namespaceURI = aNamespaceURI;
        this.schemaLocation = aSchemaLocation;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String aNamespaceURI) {
        this.namespaceURI = aNamespaceURI;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String aNamespacePrefix) {
        this.namespacePrefix = aNamespacePrefix;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String aSchemaLocation) {
        this.schemaLocation = aSchemaLocation;
    }

    public void setServiceType(int aServiceType) {
        this.serviceType = aServiceType;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = null;
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPService invalid state: " + e);
        }
        if (this.serviceType == 0) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OBJ_URI);
            root.appendChild(aDocument.createTextNode(this.namespaceURI));
        } else if (this.serviceType == 1) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_EXT_URI);
            root.appendChild(aDocument.createTextNode(this.namespaceURI));
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (this.serviceType == 0) {
            this.namespaceURI = aElement.getFirstChild().getNodeValue();
        } else if (this.serviceType == 1) {
            this.namespaceURI = aElement.getFirstChild().getNodeValue();
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPService)) {
            return false;
        }
        EPPService theService = (EPPService)aObject;
        return this.namespaceURI != null ? this.namespaceURI.equals(theService.namespaceURI) : theService.namespaceURI == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPService clone = null;
        clone = (EPPService)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    private void validateState() throws EPPCodecException {
        if (this.namespaceURI == null) {
            throw new EPPCodecException("Required attribute \"namespaceURI\" is null");
        }
    }
}

