/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v07;

import com.verisign.epp.codec.fee.v07.EPPFeeCommand;
import com.verisign.epp.codec.fee.v07.EPPFeeCredit;
import com.verisign.epp.codec.fee.v07.EPPFeePeriod;
import com.verisign.epp.codec.fee.v07.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeInfData
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "fee:infData";
    private static Logger cat = Logger.getLogger((String)EPPFeeInfData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_CLASSIFICATION = "class";
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period;
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private List<EPPFeeCredit> credits = new ArrayList<EPPFeeCredit>();
    private String classification;

    public EPPFeeInfData() {
    }

    public EPPFeeInfData(String aCurrency, EPPFeeCommand aCommand, EPPFeeValue aFee) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.addFee(aFee);
    }

    public EPPFeeInfData(String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, List<EPPFeeValue> aFees, List<EPPFeeCredit> aCredits, String aClassification) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.setFees(aFees);
        this.setCredits(aCredits);
        this.setClassification(aClassification);
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasCredits() {
        return !this.credits.isEmpty();
    }

    public List<EPPFeeCredit> getCredits() {
        return this.credits;
    }

    public void addCredit(EPPFeeCredit aCredit) {
        if (aCredit == null) {
            return;
        }
        this.credits.add(aCredit);
    }

    public void setCredits(List<EPPFeeCredit> aCredits) {
        this.credits = aCredits == null ? new ArrayList<EPPFeeCredit>() : aCredits;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeInfData.encode(Document)");
        }
        if (this.currency == null) {
            throw new EPPEncodeException("Required currency attribute is null in EPPFeeInfData.encode(Document).");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeInfData.encode(Document).");
        }
        if (!this.hasFees()) {
            throw new EPPEncodeException("There must be at least one fee in EPPFeeInfData.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.7", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.7", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeCompList(aDocument, root, this.credits);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.7", "fee:class");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.7", ELM_CURRENCY);
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.7", "fee:command", EPPFeeCommand.class);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.7", "fee:period", EPPFeePeriod.class);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.7", "fee", EPPFeeValue.class);
        this.credits = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.7", "credit", EPPFeeCredit.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.7", ELM_CLASSIFICATION);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeInfData clone = (EPPFeeInfData)super.clone();
        clone.currency = this.currency;
        clone.command = (EPPFeeCommand)this.command.clone();
        if (this.period != null) {
            clone.period = (EPPFeePeriod)this.period.clone();
        }
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.credits = new ArrayList<EPPFeeCredit>();
        for (EPPFeeCredit credit : this.credits) {
            clone.credits.add((EPPFeeCredit)credit.clone());
        }
        clone.classification = this.classification;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeInfData)) {
            cat.error((Object)("EPPFeeInfData.equals(): " + aObject.getClass().getName() + " not EPPFeeInfData instance"));
            return false;
        }
        EPPFeeInfData other = (EPPFeeInfData)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeInfData.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeInfData.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeInfData.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeInfData.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credits, other.credits)) {
            cat.error((Object)"EPPFeeInfData.equals(): credits not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeInfData.equals(): classification not equal");
            return false;
        }
        return true;
    }
}

