/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v06;

import com.verisign.epp.codec.fee.v06.EPPFeeCommand;
import com.verisign.epp.codec.fee.v06.EPPFeePeriod;
import com.verisign.epp.codec.fee.v06.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeInfData
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "fee:infData";
    private static Logger cat = Logger.getLogger((String)EPPFeeInfData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_CLASSIFICATION = "class";
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period = new EPPFeePeriod(1);
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private String classification;

    public EPPFeeInfData() {
    }

    public EPPFeeInfData(String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
    }

    public EPPFeeInfData(String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, EPPFeeValue aFee) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.addFee(aFee);
    }

    public EPPFeeInfData(String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, List<EPPFeeValue> aFees, String aClassification) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.setFees(aFees);
        this.setClassification(aClassification);
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod != null ? aPeriod : new EPPFeePeriod(1);
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeInfData.encode(Document)");
        }
        if (this.currency == null) {
            throw new EPPEncodeException("Required currency attribute is null in EPPFeeInfData.encode(Document).");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeInfData.encode(Document).");
        }
        if (this.period == null) {
            throw new EPPEncodeException("Required period attribute is null in EPPFeeInfData.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.6", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.6", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.6", "fee:class");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.6", ELM_CURRENCY);
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.6", "fee:command", EPPFeeCommand.class);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.6", "fee:period", EPPFeePeriod.class);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.6", "fee", EPPFeeValue.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.6", ELM_CLASSIFICATION);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeInfData clone = (EPPFeeInfData)super.clone();
        clone.currency = this.currency;
        clone.command = (EPPFeeCommand)this.command.clone();
        clone.period = (EPPFeePeriod)this.period.clone();
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.classification = this.classification;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeInfData)) {
            cat.error((Object)("EPPFeeInfData.equals(): " + aObject.getClass().getName() + " not EPPFeeInfData instance"));
            return false;
        }
        EPPFeeInfData other = (EPPFeeInfData)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeInfData.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeInfData.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeInfData.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeInfData.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeInfData.equals(): classification not equal");
            return false;
        }
        return true;
    }
}

