/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainInfoResp
extends EPPResponse {
    static final String ELM_NAME = "domain:infData";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private static final String ELM_STATUS = "domain:status";
    private static final String ELM_CONTACT = "domain:contact";
    private static final String ELM_CLID = "domain:clID";
    private static final String ELM_CRDATE = "domain:crDate";
    private static final String ELM_CRID = "domain:crID";
    private static final String ELM_EXDATE = "domain:exDate";
    private static final String ELM_HOST = "domain:host";
    private static final String ELM_NS = "domain:ns";
    private static final String ELM_HOST_OBJ = "domain:hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_REGISTRANT = "domain:registrant";
    private static final String ELM_ROID = "domain:roid";
    private static final String ELM_TRDATE = "domain:trDate";
    private static final String ELM_UPDATE = "domain:upDate";
    private static final String ELM_UPID = "domain:upID";
    private static Logger cat = Logger.getLogger((String)EPPDomainInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String name = null;
    private String clientId = null;
    private Vector contacts = null;
    private String createdBy = null;
    private Date createdDate = null;
    private Date expirationDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private Date lastTransferDate = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;
    private Vector hosts = new Vector();
    private Vector nses = new Vector();
    private Vector statuses = new Vector();
    private String roid = null;

    public EPPDomainInfoResp() {
    }

    public EPPDomainInfoResp(EPPTransId aTransId, String aRoid, String aName, String aClientId, Vector someStatuses, String aCreatedBy, Date aCreatedDate, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.roid = aRoid;
        this.clientId = aClientId;
        this.statuses = someStatuses;
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
        this.authInfo = aAuthInfo;
        if (this.authInfo != null) {
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public Vector getHosts() {
        return this.hosts;
    }

    public Vector getNses() {
        return this.nses;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setHosts(Vector newHosts) {
        this.hosts = newHosts;
    }

    public void setNses(Vector aServers) {
        this.nses = aServers;
    }

    public void setStatuses(Vector newStatuses) {
        this.statuses = newStatuses;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainInfoResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainInfoResp theInfoData = (EPPDomainInfoResp)aObject;
        if (!(this.name != null ? this.name.equals(theInfoData.name) : theInfoData.name == null)) {
            return false;
        }
        if (!(this.roid != null ? this.roid.equals(theInfoData.roid) : theInfoData.roid == null)) {
            return false;
        }
        if (!(this.clientId != null ? this.clientId.equals(theInfoData.clientId) : theInfoData.clientId == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theInfoData.statuses)) {
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theInfoData.registrant) : theInfoData.registrant == null)) {
            return false;
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && !EPPUtil.equalVectors(this.contacts, theInfoData.contacts)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.nses, theInfoData.nses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.hosts, theInfoData.hosts)) {
            return false;
        }
        if (!(this.createdBy != null ? this.createdBy.equals(theInfoData.createdBy) : theInfoData.createdBy == null)) {
            return false;
        }
        if (!(this.createdDate != null ? this.createdDate.equals(theInfoData.createdDate) : theInfoData.createdDate == null)) {
            return false;
        }
        if (!(this.expirationDate != null ? this.expirationDate.equals(theInfoData.expirationDate) : theInfoData.expirationDate == null)) {
            return false;
        }
        if (!(this.lastUpdatedBy != null ? this.lastUpdatedBy.equals(theInfoData.lastUpdatedBy) : theInfoData.lastUpdatedBy == null)) {
            return false;
        }
        if (!(this.lastUpdatedDate != null ? this.lastUpdatedDate.equals(theInfoData.lastUpdatedDate) : theInfoData.lastUpdatedDate == null)) {
            return false;
        }
        if (!(this.lastTransferDate != null ? this.lastTransferDate.equals(theInfoData.lastTransferDate) : theInfoData.lastTransferDate == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theInfoData.authInfo) : theInfoData.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainInfoResp clone = (EPPDomainInfoResp)super.clone();
        clone.statuses = (Vector)this.statuses.clone();
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
        }
        if (this.nses != null) {
            clone.nses = (Vector)this.nses.clone();
        }
        if (this.hosts != null) {
            clone.hosts = (Vector)this.hosts.clone();
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector someContacts) {
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            this.contacts = someContacts;
        }
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aDate) {
        this.createdDate = aDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = aExpirationDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public Date getLastTransferDate() {
        return this.lastTransferDate;
    }

    public void setLastTransferDate(Date aLastTransferDate) {
        this.lastTransferDate = aLastTransferDate;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String newRoid) {
        this.roid = newRoid;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPDomainInfoResp.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on EPPDomainInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:domain-1.0", ELM_ROID);
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        if (this.registrant != null) {
            EPPUtil.encodeString(aDocument, root, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        }
        if (this.contacts != null) {
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        if (this.nses != null && this.nses.size() > 0) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NS);
            root.appendChild(theServersElm);
            Object theNS = this.nses.get(0);
            if (theNS instanceof String) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.nses, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theNS instanceof EPPHostAttr) {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.nses);
            } else {
                throw new EPPEncodeException("EPPDomainInfoResp.encode: Invalid NS server class " + theNS.getClass().getName());
            }
        }
        if (this.hosts != null) {
            EPPUtil.encodeVector(aDocument, root, this.hosts, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST);
        }
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:domain-1.0", ELM_CLID);
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRID);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRDATE);
        if (this.lastUpdatedBy != null) {
            EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPID);
        }
        if (this.lastUpdatedDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPDATE);
        }
        if (this.expirationDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.expirationDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXDATE);
        }
        if (this.lastTransferDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastTransferDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_TRDATE);
        }
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theServerElm;
        Element theServersElm;
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_ROID);
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_STATUS, EPPDomainStatus.class);
        this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
        if (this.contacts.size() == 0) {
            this.contacts = null;
        }
        if ((theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_NS)) != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
            if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                this.nses = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                this.nses = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
            } else {
                throw new EPPDecodeException("EPPDomainCreateCmd.doDecode: Invalid host child element " + theServersElm.getLocalName());
            }
        }
        this.hosts = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CLID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRID);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CRDATE);
        this.expirationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXDATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPID);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_UPDATE);
        this.lastTransferDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_TRDATE);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.roid == null) {
            throw new EPPCodecException("roid required attribute is not set");
        }
        if (this.clientId == null) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
    }
}

