/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactPostalDefinition
implements EPPCodecComponent {
    public static final String ELM_NAME_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_ORG = "contact:org";
    private static final String ELM_CONTACT_NAME = "contact:name";
    private static final String ATTR_TYPE = "type";
    public static final String ATTR_TYPE_LOC = "loc";
    public static final String ATTR_TYPE_INT = "int";
    private String rootName = "contact:postalInfo";
    private String type = "int";
    private String name = null;
    private String org = null;
    private EPPContactAddress address = null;
    private boolean validatedFlag = true;

    public EPPContactPostalDefinition() {
    }

    public EPPContactPostalDefinition(String aType) {
        this.type = aType;
    }

    public EPPContactPostalDefinition(String aType, EPPContactAddress aAddress) {
        this.type = aType;
        this.address = aAddress;
    }

    public EPPContactPostalDefinition(String aName, String aType, EPPContactAddress aAddress) {
        this.name = aName;
        this.type = aType;
        this.address = aAddress;
    }

    public EPPContactPostalDefinition(String aName, String aOrg, String aType, EPPContactAddress aAddress) {
        this.name = aName;
        this.org = aOrg;
        this.type = aType;
        this.address = aAddress;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String aOrg) {
        this.org = aOrg;
    }

    public EPPContactAddress getAddress() {
        return this.address;
    }

    public void setAddress(EPPContactAddress aAddress) {
        this.address = aAddress;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.validatedFlag) {
            try {
                this.validateState();
            }
            catch (EPPCodecException e) {
                throw new EPPEncodeException("Invalid state on EPPContactPostalDefination.encode: " + e);
            }
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", this.rootName);
        root.setAttribute(ATTR_TYPE, this.type);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        EPPUtil.encodeString(aDocument, root, this.org, "urn:ietf:params:xml:ns:contact-1.0", ELM_ORG);
        if (this.address != null) {
            EPPUtil.encodeComp(aDocument, root, this.address);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        this.org = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ORG);
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.address = (EPPContactAddress)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:addr", EPPContactAddress.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactPostalDefinition)) {
            return false;
        }
        EPPContactPostalDefinition theComp = (EPPContactPostalDefinition)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.org != null ? this.org.equals(theComp.org) : theComp.org == null)) {
            return false;
        }
        if (!this.type.equals(theComp.type)) {
            return false;
        }
        return this.address != null ? this.address.equals(theComp.address) : theComp.address == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactPostalDefinition clone = (EPPContactPostalDefinition)super.clone();
        if (this.address != null) {
            clone.address = (EPPContactAddress)this.address.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected void validateState() throws EPPCodecException {
        if (this.rootName == null) {
            throw new EPPCodecException("root element name is not set");
        }
        if (!this.rootName.equals(ELM_NAME_POSTAL_INFO)) {
            throw new EPPCodecException("root element name is not recognized");
        }
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.type == null) {
            throw new EPPCodecException("required attribute type is not set");
        }
        if (this.address == null) {
            throw new EPPCodecException("address required attribute is not set");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setRootName(String newRootName) {
        this.rootName = newRootName;
    }

    public boolean isValidated() {
        return this.validatedFlag;
    }

    public void setValidatedFlag(boolean newValidatedFlag) {
        this.validatedFlag = newValidatedFlag;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }
}

