/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactAddress
implements EPPCodecComponent {
    static final String ELM_NAME = "contact:addr";
    private static final String ELM_STREET = "contact:street";
    private static final String ELM_CITY = "contact:city";
    private static final String ELM_STATE_PROVINCE = "contact:sp";
    private static final String ELM_POSTAL_CODE = "contact:pc";
    private static final String ELM_COUNTRY = "contact:cc";
    private static final int MAX_STREET = 3;
    private Vector streets = null;
    private String city = null;
    private String stateProvince = null;
    private String postalCode = null;
    private String country = null;

    public EPPContactAddress() {
    }

    public EPPContactAddress(String aCity, String aCountry) {
        this.streets = null;
        this.city = aCity;
        this.stateProvince = null;
        this.postalCode = null;
        this.country = aCountry;
    }

    public EPPContactAddress(Vector someStreets, String aCity, String aStateProvince, String aPostalCode, String aCountry) {
        this.streets = someStreets;
        this.city = aCity;
        this.stateProvince = aStateProvince;
        this.postalCode = aPostalCode;
        this.country = aCountry;
    }

    public Vector getStreets() {
        return this.streets;
    }

    public void setStreet(String aStreet) {
        this.streets = new Vector();
        this.streets.addElement(aStreet);
    }

    public void setStreets(Vector someStreets) {
        this.streets = someStreets;
    }

    public void setStreets(String aStreet1, String aStreet2) {
        this.streets = new Vector();
        this.streets.addElement(aStreet1);
        this.streets.addElement(aStreet2);
    }

    public void setStreets(String aStreet1, String aStreet2, String aStreet3) {
        this.streets = new Vector();
        this.streets.addElement(aStreet1);
        this.streets.addElement(aStreet2);
        this.streets.addElement(aStreet3);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(String aStateProvince) {
        this.stateProvince = aStateProvince;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String aPostalCode) {
        this.postalCode = aPostalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String aCountry) {
        this.country = aCountry;
    }

    void validateState() throws EPPCodecException {
        if (this.streets != null && this.streets.contains(null)) {
            throw new EPPCodecException("street lines cannot be set to null");
        }
        if (this.streets != null && this.streets.elements().hasMoreElements() && this.streets.size() > 3) {
            throw new EPPCodecException("street lines exceed the maximum");
        }
        if (this.city == null) {
            throw new EPPCodecException("city required attribute is not set");
        }
        if (this.country == null) {
            throw new EPPCodecException("country required attribute is not set");
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactAddress.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        if (this.streets != null && this.streets.elements().hasMoreElements()) {
            EPPUtil.encodeVector(aDocument, root, this.streets, "urn:ietf:params:xml:ns:contact-1.0", ELM_STREET);
        }
        EPPUtil.encodeString(aDocument, root, this.city, "urn:ietf:params:xml:ns:contact-1.0", ELM_CITY);
        if (this.stateProvince != null) {
            EPPUtil.encodeString(aDocument, root, this.stateProvince, "urn:ietf:params:xml:ns:contact-1.0", ELM_STATE_PROVINCE);
        }
        if (this.postalCode != null) {
            EPPUtil.encodeString(aDocument, root, this.postalCode, "urn:ietf:params:xml:ns:contact-1.0", ELM_POSTAL_CODE);
        }
        EPPUtil.encodeString(aDocument, root, this.country, "urn:ietf:params:xml:ns:contact-1.0", ELM_COUNTRY);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.streets = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_STREET);
        if (this.streets.size() == 0) {
            this.streets = null;
        }
        this.city = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CITY);
        this.stateProvince = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_STATE_PROVINCE);
        this.postalCode = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_POSTAL_CODE);
        this.country = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_COUNTRY);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactAddress)) {
            return false;
        }
        EPPContactAddress theComp = (EPPContactAddress)aObject;
        if (!EPPUtil.equalVectors(this.streets, theComp.streets)) {
            return false;
        }
        if (!(this.city != null ? this.city.equals(theComp.city) : theComp.city == null)) {
            return false;
        }
        if (!(this.stateProvince != null ? this.stateProvince.equals(theComp.stateProvince) : theComp.stateProvince == null)) {
            return false;
        }
        if (!(this.postalCode != null ? this.postalCode.equals(theComp.postalCode) : theComp.postalCode == null)) {
            return false;
        }
        return this.country != null ? this.country.equals(theComp.country) : theComp.country == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactAddress clone = null;
        clone = (EPPContactAddress)super.clone();
        if (this.streets != null) {
            clone.streets = (Vector)this.streets.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

