/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.coaext;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtCreate;
import com.verisign.epp.codec.coaext.EPPCoaExtInfData;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtUpdate;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPCoaExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPCoaExtTst(String name) {
        super(name);
    }

    public void testDomainCreateCommandWithCoaExt() {
        EPPCodecTst.printStart("testDomainCreateCommandWithCoaExt");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "john.doe.com", new EPPAuthInfo("2fooBAR@"));
        Vector<EPPCoaExtCreate> commandExtensions = new Vector<EPPCoaExtCreate>();
        EPPCoaExtAttr attr = new EPPCoaExtAttr();
        attr.setKey(new EPPCoaExtKey("KEY1"));
        attr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtCreate create = new EPPCoaExtCreate();
        create.appendAttr(attr);
        commandExtensions.add(create);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreateCommandWithCoaExt");
    }

    public void testDomainUpdateCommandWithCoaExtPut() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExt");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCoaExtUpdate> commandExtensions = new Vector<EPPCoaExtUpdate>();
        EPPCoaExtAttr addAttr = new EPPCoaExtAttr();
        addAttr.setKey(new EPPCoaExtKey("KEY1"));
        addAttr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        updateCmd.appendPutAttr(addAttr);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExt");
    }

    public void testDomainUpdateCommandWithCoaExtRem() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExtRem");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCoaExtUpdate> commandExtensions = new Vector<EPPCoaExtUpdate>();
        EPPCoaExtKey remKey = new EPPCoaExtKey("KEY1");
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        updateCmd.appendRemAttr(remKey);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExtRem");
    }

    public void testDomainUpdateCommandWithCoaExtAll() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithCoaExtAll");
        EPPDomainUpdateCmd theDomainCommand = new EPPDomainUpdateCmd("john.doe.name");
        Vector<EPPCoaExtUpdate> commandExtensions = new Vector<EPPCoaExtUpdate>();
        EPPCoaExtUpdate updateCmd = new EPPCoaExtUpdate();
        EPPCoaExtKey remKey = new EPPCoaExtKey("KEY1");
        updateCmd.appendRemAttr(remKey);
        EPPCoaExtAttr addAttr = new EPPCoaExtAttr();
        addAttr.setKey(new EPPCoaExtKey("KEY2"));
        addAttr.setValue(new EPPCoaExtValue("value2"));
        updateCmd.appendPutAttr(addAttr);
        commandExtensions.add(updateCmd);
        theDomainCommand.setExtensions(commandExtensions);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithCoaExtAll");
    }

    public void testDomainInfoRespWithCoaExtRem() {
        EPPCodecTst.printStart("testDomainInfoRespWithCoaExtRem");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.tv", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPCoaExtAttr attr = new EPPCoaExtAttr();
        attr.setKey(new EPPCoaExtKey("KEY1"));
        attr.setValue(new EPPCoaExtValue("value1"));
        EPPCoaExtInfData infData = new EPPCoaExtInfData();
        infData.appendAttr(attr);
        theResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithCoaExtRem");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPCoaExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.coaext.EPPCoaExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPCoaExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPCoaExtTst Thread " + i, EPPCoaExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPCoaExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

