/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPNameWatch;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPNameWatchTst
extends TestCase {
    private EPPNameWatch nameWatch = null;
    private EPPSession session = null;
    private EPPClientCon connection = null;
    private int iteration = 0;
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPNameWatchTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPNameWatchTst(String name) {
        super(name);
    }

    public void testNameWatch() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.nameWatchInfo();
            this.nameWatchCreate();
            this.nameWatchDelete();
            this.nameWatchRenew();
            this.nameWatchUpdate();
            this.nameWatchTransferQuery();
            this.nameWatchTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void nameWatchInfo() {
        this.printStart("nameWatchInfo");
        try {
            int i;
            System.out.println("\nnameWatchInfo: NameWatch info for EXAMPLE1-REP");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            EPPNameWatchInfoResp response = this.nameWatch.sendInfo();
            System.out.println("nameWatchInfo: Response = [" + response + "]\n\n");
            System.out.println("nameWatchInfo: name            = " + response.getName());
            System.out.println("nameWatchInfo: roid            = " + response.getRoid());
            System.out.println("nameWatchInfo: registrant      = " + response.getRegistrant());
            System.out.println("nameWatchInfo: client id       = " + response.getClientId());
            System.out.println("nameWatchInfo: created by      = " + response.getCreatedBy());
            System.out.println("nameWatchInfo: create date     = " + response.getCreatedDate());
            System.out.println("nameWatchInfo: expiration date = " + response.getExpirationDate());
            if (response.getRptTo() != null) {
                System.out.println("Reply To        :" + response.getRptTo().getRptTo());
                System.out.println("Frequency Type  :" + response.getRptTo().getFreqType());
            }
            if (response.getAuthInfo() != null) {
                System.out.println("Authorization        : " + response.getAuthInfo().getPassword());
                System.out.println("Authorization (Roid) : " + response.getAuthInfo().getRoid());
            }
            if (response.getStatuses() != null) {
                for (i = 0; i < response.getStatuses().size(); ++i) {
                    EPPNameWatchStatus myStatus = (EPPNameWatchStatus)response.getStatuses().elementAt(i);
                    System.out.println("Lang     : " + myStatus.getLang());
                    System.out.println("Status   : " + myStatus.getStatus());
                }
            }
            for (i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchInfo");
    }

    public void nameWatchCreate() {
        this.printStart("nameWatchCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nameWatchCreate: Create \"doe\" with no optional attributes");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setName("doe");
            this.nameWatch.setRegistrant("jd1234");
            this.nameWatch.setRptTo("jdoe@example.com");
            this.nameWatch.setFreq("weekly");
            this.nameWatch.setAuthString("2fooBAR");
            this.nameWatch.setPeriodLength(2);
            EPPNameWatchCreateResp response = this.nameWatch.sendCreate();
            System.out.println("nameWatchCreate: Response = [" + response + "]\n\n");
            System.out.println("nameWatchCreate: name = " + response.getName());
            System.out.println("nameWatchCreate: roid = " + response.getRoid());
            System.out.println("nameWatchCreate: creation date = " + response.getCreationDate());
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchCreate");
    }

    public void nameWatchDelete() {
        this.printStart("nameWatchDelete");
        try {
            System.out.println("\nnameWatchDelete: NameWatch delete for EXAMPLE1-REP");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            EPPResponse response = this.nameWatch.sendDelete();
            System.out.println("nameWatchDelete: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchDelete");
    }

    public void nameWatchRenew() {
        this.printStart("nameWatchRenew");
        try {
            System.out.println("\nnameWatchRenew: NameWatch renew for EXAMPLE1-REP");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            this.nameWatch.setExpirationDate(new GregorianCalendar(2000, 4, 3).getTime());
            this.nameWatch.setPeriodLength(10);
            EPPNameWatchRenewResp response = this.nameWatch.sendRenew();
            System.out.println("nameWatchRenew: Response = [" + response + "]\n\n");
            System.out.println("nameWatchRenew: roid = " + response.getRoid());
            System.out.println("nameWatchRenew: expiration date = " + response.getExpirationDate());
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchRenew");
    }

    public void nameWatchUpdate() {
        this.printStart("nameWatchUpdate");
        try {
            System.out.println("\nnameWatchUpdate: NameWatch update for EXAMPLE1-REP");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            this.nameWatch.setRegistrant("sh8013");
            this.nameWatch.setRptTo("jdoe@example.com");
            this.nameWatch.setFreq("daily");
            this.nameWatch.setAuthString("2BARfoo");
            this.nameWatch.addStatus(new EPPNameWatchStatus("clientHold", "Payment overdue"));
            this.nameWatch.removeStatus(new EPPNameWatchStatus("clientUpdateProhibited"));
            EPPResponse response = this.nameWatch.sendUpdate();
            System.out.println("nameWatchUpdate: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getValues() == null) continue;
                for (int k = 0; k < myResult.getValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchUpdate");
    }

    public void nameWatchTransferQuery() {
        this.printStart("nameWatchTransferQuery");
        try {
            System.out.println("\nnameWatchTransferQuery: NameWatch transfer query for EXAMPLE1-REP");
            this.nameWatch.setTransferOpCode("query");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            EPPNameWatchTransferResp response = this.nameWatch.sendTransfer();
            System.out.println("nameWatchTransferQuery: Response = [" + response + "]\n\n");
            System.out.println("nameWatchTransferQuery: roid = " + response.getRoid());
            System.out.println("nameWatchTransferQuery: transfer status = " + response.getTransferStatus());
            System.out.println("nameWatchTransferQuery: request client = " + response.getRequestClient());
            System.out.println("nameWatchTransferQuery: request date = " + response.getRequestDate());
            System.out.println("nameWatchTransferQuery: action client = " + response.getActionClient());
            System.out.println("nameWatchTransferQuery: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("nameWatchTransferQuery: expiration date = " + response.getExpirationDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchTransferQuery");
    }

    public void nameWatchTransfer() {
        EPPNameWatchTransferResp response;
        this.printStart("nameWatchTransfer");
        try {
            System.out.println("\nnameWatchTransfer: NameWatch transfer request for EXAMPLE1-REP");
            this.nameWatch.setTransferOpCode("request");
            this.nameWatch.setTransId("ABC-12345-XYZ");
            this.nameWatch.setAuthString("2fooBAR");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            this.nameWatch.setPeriodLength(10);
            response = this.nameWatch.sendTransfer();
            System.out.println("nameWatchTransferQuery: Response = [" + response + "]\n\n");
            System.out.println("nameWatchTransferQuery: roid = " + response.getRoid());
            System.out.println("nameWatchTransferQuery: transfer status = " + response.getTransferStatus());
            System.out.println("nameWatchTransferQuery: request client = " + response.getRequestClient());
            System.out.println("nameWatchTransferQuery: request date = " + response.getRequestDate());
            System.out.println("nameWatchTransferQuery: action client = " + response.getActionClient());
            System.out.println("nameWatchTransferQuery: action date = " + response.getActionDate());
            if (response.getExpirationDate() != null) {
                System.out.println("nameWatchTransfer: expiration date = " + response.getExpirationDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nnameWatchTransfer: NameWatch transfer cancel for EXAMPLE1-REP");
            this.nameWatch.setTransferOpCode("cancel");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            response = this.nameWatch.sendTransfer();
            System.out.println("nameWatchTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nnameWatchTransfer: NameWatch transfer reject for EXAMPLE1-REP");
            this.nameWatch.setTransferOpCode("reject");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            response = this.nameWatch.sendTransfer();
            System.out.println("nameWatchTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\nnameWatchTransfer: NameWatch transfer approve for EXAMPLE1-REP");
            this.nameWatch.setTransferOpCode("approve");
            this.nameWatch.setRoid("EXAMPLE1-REP");
            response = this.nameWatch.sendTransfer();
            System.out.println("nameWatchTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nameWatchTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            this.session = new EPPSession();
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.nameWatch = new EPPNameWatch(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPNameWatchTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPNameWatchTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPNameWatchTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

