/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.defReg.EPPDefRegAddRemove;
import com.verisign.epp.codec.defReg.EPPDefRegCheckCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResp;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateResp;
import com.verisign.epp.codec.defReg.EPPDefRegDeleteCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegName;
import com.verisign.epp.codec.defReg.EPPDefRegPeriod;
import com.verisign.epp.codec.defReg.EPPDefRegRenewCmd;
import com.verisign.epp.codec.defReg.EPPDefRegRenewResp;
import com.verisign.epp.codec.defReg.EPPDefRegStatus;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegTransferResp;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPDefReg {
    public static final int CONTACT = 1;
    public static final int STATUS = 2;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int CHANGE = 2;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String STATUS_PENDING_VERIFICATION = "pendingVerification";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String LEVEL_STANDARD = "standard";
    public static final String LEVEL_PREMIUM = "premium";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    private Vector myDefRegList = new Vector();
    private Vector myContactList = new Vector();
    private EPPSession mySession = null;
    private String myTransId = null;
    private String roid = null;
    private String registrant = null;
    private String tm = null;
    private String tmcountry = null;
    private Date tmdate = null;
    private String admincontact = null;
    private Date myExpirationDate;
    private String myTransferOpCode;
    private int thePeriodLength = 1;
    private String thePeriodUnit;
    private String theAuthString;
    private String authRoid;
    private Vector extensions = null;
    private Vector myAddStatuses = null;
    private Vector myRemoveStatuses = null;

    public EPPDefReg(EPPSession newSession) {
        this.mySession = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void addDefRegName(String newLevel, String newName) {
        EPPDefRegName theName = new EPPDefRegName(newLevel, newName);
        this.myDefRegList.addElement(theName);
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getRoid() {
        return this.roid;
    }

    public String getTm() {
        return this.tm;
    }

    public void setTm(String aTm) {
        this.tm = aTm;
    }

    public String getTmCountry() {
        return this.tmcountry;
    }

    public void setTmCountry(String aTmCountry) {
        this.tmcountry = aTmCountry;
    }

    public Date getTmDate() {
        return this.tmdate;
    }

    public void setTmDate(Date aTmDate) {
        this.tmdate = aTmDate;
    }

    public String getAdminContact() {
        return this.admincontact;
    }

    public void setRegistrant(String aRegistrant) {
        this.registrant = aRegistrant;
    }

    public void setAdminContact(String aAdminContact) {
        this.admincontact = aAdminContact;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setExpirationDate(Date newExpirationDate) {
        this.myExpirationDate = newExpirationDate;
    }

    public Date getExpirationDate() {
        return this.myExpirationDate;
    }

    public void setTransferOpCode(String newTransferOpCode) {
        this.myTransferOpCode = newTransferOpCode;
    }

    public void setTransId(String newTransId) {
        this.myTransId = newTransId;
    }

    public void setAuthString(String newAuthString) {
        this.theAuthString = newAuthString;
    }

    public String getAuthString() {
        return this.theAuthString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public EPPDefRegCreateResp sendCreate() throws EPPCommandException {
        if (this.myDefRegList.size() != 1) {
            throw new EPPCommandException("One Defensive Registration Name is required for sendCreate()");
        }
        EPPDefRegPeriod myPeriod = null;
        myPeriod = this.thePeriodLength < 0 ? null : (this.thePeriodUnit == null ? new EPPDefRegPeriod(this.thePeriodLength) : new EPPDefRegPeriod(this.thePeriodUnit, this.thePeriodLength));
        EPPDefRegCreateCmd myCommand = new EPPDefRegCreateCmd(this.myTransId, (EPPDefRegName)this.myDefRegList.firstElement(), this.registrant, this.tm, this.tmcountry, this.tmdate, this.admincontact, myPeriod, new EPPAuthInfo(this.theAuthString));
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return (EPPDefRegCreateResp)this.mySession.processDocument(myCommand, EPPDefRegCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        EPPDefRegAddRemove addItems = null;
        addItems = this.myAddStatuses != null ? new EPPDefRegAddRemove(this.myAddStatuses) : new EPPDefRegAddRemove();
        EPPDefRegAddRemove removeItems = null;
        removeItems = this.myRemoveStatuses != null ? new EPPDefRegAddRemove(this.myRemoveStatuses) : new EPPDefRegAddRemove();
        EPPAuthInfo authInfo = null;
        if (this.theAuthString != null) {
            authInfo = new EPPAuthInfo(this.theAuthString);
        }
        EPPDefRegAddRemove changeItems = new EPPDefRegAddRemove(this.registrant, this.tm, this.tmcountry, this.tmdate, this.admincontact, authInfo);
        EPPDefRegUpdateCmd myCommand = new EPPDefRegUpdateCmd(this.myTransId, this.roid, addItems, removeItems, changeItems);
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    public EPPDefRegTransferResp sendTransfer() throws EPPCommandException {
        EPPDefRegTransferCmd myCommand = new EPPDefRegTransferCmd(this.myTransId, this.myTransferOpCode, this.roid);
        if (this.theAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.theAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        if (this.myTransferOpCode.equals(TRANSFER_REQUEST)) {
            if (this.theAuthString == null) {
                throw new EPPCommandException("Auth Info must be set on a Transfer Request");
            }
            EPPDefRegPeriod myPeriod = null;
            myPeriod = this.thePeriodLength < 0 ? null : (this.thePeriodUnit == null ? new EPPDefRegPeriod(this.thePeriodLength) : new EPPDefRegPeriod(this.thePeriodUnit, this.thePeriodLength));
            myCommand.setPeriod(myPeriod);
        }
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return (EPPDefRegTransferResp)this.mySession.processDocument(myCommand, EPPDefRegTransferResp.class);
    }

    public EPPDefRegRenewResp sendRenew() throws EPPCommandException {
        EPPDefRegPeriod myPeriod = null;
        myPeriod = this.thePeriodLength < 0 ? null : (this.thePeriodUnit == null ? new EPPDefRegPeriod(this.thePeriodLength) : new EPPDefRegPeriod(this.thePeriodUnit, this.thePeriodLength));
        EPPDefRegRenewCmd myCommand = new EPPDefRegRenewCmd(this.myTransId, this.roid, this.myExpirationDate, myPeriod);
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return (EPPDefRegRenewResp)this.mySession.processDocument(myCommand, EPPDefRegRenewResp.class);
    }

    public EPPDefRegInfoResp sendInfo() throws EPPCommandException {
        EPPDefRegInfoCmd myCommand = new EPPDefRegInfoCmd(this.myTransId, this.roid);
        if (this.theAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.theAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return (EPPDefRegInfoResp)this.mySession.processDocument(myCommand, EPPDefRegInfoResp.class);
    }

    public EPPDefRegCheckResp sendCheck() throws EPPCommandException {
        Object myDoc = null;
        EPPDefRegCheckCmd myCommand = new EPPDefRegCheckCmd(this.myTransId, this.myDefRegList);
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return (EPPDefRegCheckResp)this.mySession.processDocument(myCommand, EPPDefRegCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        EPPDefRegDeleteCmd myCommand = new EPPDefRegDeleteCmd(this.myTransId, this.roid);
        myCommand.setExtensions(this.extensions);
        this.resetDefReg();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    public void addStatus(EPPDefRegStatus aStatus) {
        if (this.myAddStatuses == null) {
            this.myAddStatuses = new Vector();
        }
        this.myAddStatuses.addElement(aStatus);
    }

    public void removeStatus(EPPDefRegStatus aStatus) {
        if (this.myRemoveStatuses == null) {
            this.myRemoveStatuses = new Vector();
        }
        this.myRemoveStatuses.addElement(aStatus);
    }

    private void resetDefReg() {
        this.myDefRegList = new Vector();
        this.myContactList = new Vector();
        this.myAddStatuses = null;
        this.myRemoveStatuses = null;
        this.myTransId = null;
        this.roid = null;
        this.registrant = null;
        this.myExpirationDate = null;
        this.myTransferOpCode = null;
        this.thePeriodLength = 1;
        this.thePeriodUnit = null;
        this.theAuthString = null;
        this.authRoid = null;
        this.extensions = null;
    }

    public EPPResponse getResponse() {
        return this.mySession.getResponse();
    }

    public void setPeriodLength(int newPeriodLength) {
        this.thePeriodLength = newPeriodLength;
    }

    public void setPeriodUnit(String newPeriodUnit) {
        this.thePeriodUnit = newPeriodUnit;
    }

    public int getPeriodLength() {
        return this.thePeriodLength;
    }

    public String getPeriodUnit() {
        return this.thePeriodUnit;
    }
}

