/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whowas;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.whowas.EPPWhoWasHistory;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoCmd;
import com.verisign.epp.codec.whowas.EPPWhoWasInfoResp;
import com.verisign.epp.codec.whowas.EPPWhoWasRecord;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPWhoWasTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPWhoWasTst(String name) {
        super(name);
    }

    public void testWhoWasInfoCmd() {
        EPPCodecTst.printStart("testWhoWasInfoCmd");
        String type = "domain";
        int i = 0;
        while ((long)i < numIterations) {
            EPPCodecTst.printStart("EPPWhoWasInfoCmd set with both type and name");
            EPPWhoWasInfoCmd cmd = new EPPWhoWasInfoCmd("51364-CLI", type);
            cmd.setName("abc.com");
            EPPCodecTst.testEncodeDecode(cmd);
            EPPCodecTst.printStart("EPPWhoWasInfoCmd set with both type and roid");
            cmd = new EPPWhoWasInfoCmd("51364-CLI", type);
            cmd.setRoid("abc-rep");
            EPPCodecTst.testEncodeDecode(cmd);
            EPPCodecTst.printStart("EPPWhoWasInfoCmd set with only name and null type");
            cmd = new EPPWhoWasInfoCmd("51364-CLI");
            cmd.setName("abc.com");
            EPPCodecTst.testEncodeDecode(cmd);
            EPPCodecTst.printStart("EPPWhoWasInfoCmd set with only roid and null type");
            cmd = new EPPWhoWasInfoCmd("51364-CLI");
            cmd.setRoid("abc-rep");
            EPPCodecTst.testEncodeDecode(cmd);
            ++i;
        }
        EPPCodecTst.printEnd("testWhoWasInfoCmd");
    }

    public void testWhoWasInfoResponse() {
        EPPCodecTst.printStart("testWhoWasInfoResponse");
        String type = "domain";
        int i = 0;
        while ((long)i < numIterations) {
            EPPWhoWasInfoCmd cmd = new EPPWhoWasInfoCmd("51364-CLI", type);
            EPPTransId aTransId = new EPPTransId(cmd.getTransId(), "SRV-43659");
            EPPCodecTst.printStart("EPPWhoWasInfoResp set with both type and name");
            EPPWhoWasInfoResp resp = new EPPWhoWasInfoResp(aTransId, type);
            resp.setName("abc.com");
            EPPWhoWasRecord record = new EPPWhoWasRecord();
            record.setTransactionDate(new Date());
            record.setName("abc.com");
            record.setOperation("CREATE");
            record.setRoid("EXAMPLE1-REP");
            record.setClientID("ClientX");
            record.setClientName("Client X Corp");
            EPPWhoWasHistory history = new EPPWhoWasHistory();
            history.addRecord(record);
            resp.setHistory(history);
            EPPCodecTst.testEncodeDecode(resp);
            EPPCodecTst.printStart("EPPWhoWasInfoResp set with both type and name");
            resp = new EPPWhoWasInfoResp(aTransId, type);
            resp.setRoid("abc-rep");
            resp.setHistory(history);
            EPPCodecTst.testEncodeDecode(resp);
            EPPCodecTst.printStart("EPPWhoWasInfoResp set with only name and null type");
            resp = new EPPWhoWasInfoResp(aTransId);
            resp.setName("abc.com");
            resp.setHistory(history);
            EPPCodecTst.testEncodeDecode(resp);
            EPPCodecTst.printStart("EPPWhoWasInfoResp set with only roid and null type");
            resp = new EPPWhoWasInfoResp(aTransId);
            resp.setRoid("abc-rep");
            resp.setHistory(history);
            EPPCodecTst.testEncodeDecode(resp);
            ++i;
        }
        EPPCodecTst.printEnd("testWhoWasInfoResponse");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPWhoWasTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.whowas.EPPWhoWasMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPWhoWasMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPWhoWasTst Thread " + i, EPPWhoWasTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPWhoWasTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

