/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.util.EPPCatFactory;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EPPUtil {
    public static final String DEFAULT_TIME_INSTANT_FORMAT = "yyyy-MM-dd'T'HH':'mm':'ss'.'SSS'Z'";
    private static String timeInstantFormat = "yyyy-MM-dd'T'HH':'mm':'ss'.'SSS'Z'";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static Logger cat = Logger.getLogger((String)EPPUtil.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);

    public static String getTimeInstantFormat() {
        return timeInstantFormat;
    }

    public static void setTimeInstantFormat(String aTimeInstantFormat) {
        timeInstantFormat = aTimeInstantFormat;
    }

    public static void appendChildren(Element aSource, Element aDest) {
        NodeList children = aSource.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            aDest.appendChild(children.item(i).cloneNode(true));
        }
    }

    public static BigDecimal decodeBigDecimal(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        return EPPUtil.decodeBigDecimal(theElm);
    }

    public static BigDecimal decodeBigDecimal(Element aElement) throws EPPDecodeException {
        BigDecimal retBigDecimal = null;
        if (aElement != null) {
            Node textNode = aElement.getFirstChild();
            if (textNode != null) {
                String doubleValStr = textNode.getNodeValue();
                try {
                    Double tempDouble = Double.valueOf(doubleValStr);
                    retBigDecimal = new BigDecimal(tempDouble);
                    retBigDecimal = retBigDecimal.setScale(2, 4);
                }
                catch (NumberFormatException e) {
                    throw new EPPDecodeException("Can't convert value to Double: " + doubleValStr + e);
                }
            } else {
                throw new EPPDecodeException("Can't decode numeric value from non-existant text node");
            }
        }
        return retBigDecimal;
    }

    public static Boolean decodeBoolean(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Boolean retVal = null;
        String theVal = null;
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        if (theElm != null) {
            Node textNode = theElm.getFirstChild();
            retVal = textNode != null ? ((theVal = textNode.getNodeValue()).equalsIgnoreCase("true") || theVal.equals("1") ? new Boolean(true) : new Boolean(false)) : null;
        }
        return retVal;
    }

    public static boolean decodeBooleanAttr(Element aElement, String aAttr) throws EPPDecodeException {
        boolean theRet = false;
        String theAttrVal = aElement.getAttribute(aAttr);
        if (theAttrVal == null) {
            throw new EPPDecodeException("EPPUtil.decodeBooleanAttr: Could not find attr " + aAttr);
        }
        if (theAttrVal.equals("1") || theAttrVal.equals("true")) {
            theRet = true;
        } else if (theAttrVal.equals("0") || theAttrVal.equals("false")) {
            theRet = false;
        } else {
            throw new EPPDecodeException("EPPUtil.decodeBooleanAttr: Invalid boolean attr " + aAttr + " value of " + theAttrVal);
        }
        return theRet;
    }

    public static EPPCodecComponent decodeComp(Element aElement, String aNS, String aTagName, Class aClass) throws EPPDecodeException {
        EPPCodecComponent retVal = null;
        try {
            Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
            if (theElm != null) {
                retVal = (EPPCodecComponent)aClass.newInstance();
                retVal.decode(theElm);
            }
        }
        catch (IllegalAccessException e) {
            throw new EPPDecodeException("EPPUtil.decodeComp(), IllegalAccessException: " + e);
        }
        catch (InstantiationException e) {
            throw new EPPDecodeException("EPPUtil.decodeComp(), InstantiationException: " + e);
        }
        return retVal;
    }

    public static List decodeCompList(Element aElement, String aNS, String aTagName, Class aClass) throws EPPDecodeException {
        ArrayList<EPPCodecComponent> retVal = new ArrayList<EPPCodecComponent>();
        try {
            Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, aNS, aTagName);
            for (int i = 0; i < theChildren.size(); ++i) {
                EPPCodecComponent currComp = (EPPCodecComponent)aClass.newInstance();
                currComp.decode((Element)theChildren.elementAt(i));
                retVal.add(currComp);
            }
        }
        catch (IllegalAccessException e) {
            throw new EPPDecodeException("EPPUtil.decodeCompList(), IllegalAccessException: " + e);
        }
        catch (InstantiationException e) {
            throw new EPPDecodeException("EPPUtil.decodeCompList(), InstantiationException: " + e);
        }
        return retVal;
    }

    public static Vector decodeCompVector(Element aElement, String aNS, String aTagName, Class aClass) throws EPPDecodeException {
        Vector<EPPCodecComponent> retVal = new Vector<EPPCodecComponent>();
        try {
            Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, aNS, aTagName);
            for (int i = 0; i < theChildren.size(); ++i) {
                EPPCodecComponent currComp = (EPPCodecComponent)aClass.newInstance();
                currComp.decode((Element)theChildren.elementAt(i));
                retVal.addElement(currComp);
            }
        }
        catch (IllegalAccessException e) {
            throw new EPPDecodeException("EPPUtil.decodeCompVector(), IllegalAccessException: " + e);
        }
        catch (InstantiationException e) {
            throw new EPPDecodeException("EPPUtil.decodeCompVector(), InstantiationException: " + e);
        }
        return retVal;
    }

    public static Date decodeDate(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Date retVal = null;
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        if (theElm != null) {
            retVal = EPPUtil.decodeDate(theElm.getFirstChild().getNodeValue());
        }
        return retVal;
    }

    public static Date decodeDate(String aDateValue) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        Calendar theCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        theCal.set(11, 0);
        theCal.set(12, 0);
        theCal.set(13, 0);
        theCal.set(14, 0);
        formatter.setCalendar(theCal);
        Date theDate = formatter.parse(aDateValue, new ParsePosition(0));
        return theDate;
    }

    public static Integer decodeInteger(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        Integer retInteger = null;
        if (theElm != null) {
            Node textNode = theElm.getFirstChild();
            if (textNode != null) {
                String intValStr = textNode.getNodeValue();
                try {
                    retInteger = Integer.valueOf(intValStr);
                }
                catch (NumberFormatException e) {
                    throw new EPPDecodeException("Can't convert value to Integer: " + intValStr + e);
                }
            } else {
                throw new EPPDecodeException("Can't decode numeric value from non-existant text node");
            }
        }
        return retInteger;
    }

    public static List decodeList(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        ArrayList<String> retVal = new ArrayList<String>();
        Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, aNS, aTagName);
        for (int i = 0; i < theChildren.size(); ++i) {
            Element currChild = (Element)theChildren.elementAt(i);
            Text currVal = (Text)currChild.getFirstChild();
            if (currVal != null) {
                retVal.add(currVal.getNodeValue());
                continue;
            }
            retVal.add("");
        }
        return retVal;
    }

    public static String decodeString(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        String retVal = null;
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        if (theElm != null) {
            Node textNode = theElm.getFirstChild();
            retVal = textNode != null ? textNode.getNodeValue() : "";
        }
        return retVal;
    }

    public static Date decodeTimeInstant(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Date retVal = null;
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, aNS, aTagName);
        if (theElm != null) {
            retVal = EPPUtil.decodeTimeInstant(theElm.getFirstChild().getNodeValue());
        }
        return retVal;
    }

    public static Date decodeTimeInstant(String aTimeInstant) {
        Date theDate = null;
        try {
            theDate = DatatypeConverter.parseDateTime((String)aTimeInstant).getTime();
        }
        catch (IllegalArgumentException ex) {
            cat.error((Object)("Exception decoding dataTime: " + ex));
            theDate = null;
        }
        return theDate;
    }

    public static Vector decodeVector(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        Vector<String> retVal = new Vector<String>();
        Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, aNS, aTagName);
        for (int i = 0; i < theChildren.size(); ++i) {
            Element currChild = (Element)theChildren.elementAt(i);
            Text currVal = (Text)currChild.getFirstChild();
            if (currVal != null) {
                retVal.addElement(currVal.getNodeValue());
                continue;
            }
            retVal.addElement("");
        }
        return retVal;
    }

    public static void encodeBigDecimal(Document aDocument, Element aRoot, BigDecimal aBigDecimal, String aNS, String aTagName, String aFormat) throws EPPEncodeException {
        if (aBigDecimal != null) {
            String format = aFormat != null ? aFormat : "#0.00";
            DecimalFormat decFormat = new DecimalFormat(format, decimalFormatSymbols);
            String numberStr = decFormat.format(aBigDecimal);
            EPPUtil.encodeString(aDocument, aRoot, numberStr, aNS, aTagName);
        }
    }

    public static void encodeBigDecimal(Document aDocument, Element aElement, BigDecimal aBigDecimal, String aFormat) throws EPPEncodeException {
        if (aBigDecimal != null) {
            String format = aFormat != null ? aFormat : "#0.00";
            DecimalFormat decFormat = new DecimalFormat(format, decimalFormatSymbols);
            String numberStr = decFormat.format(aBigDecimal);
            Text currVal = aDocument.createTextNode(numberStr);
            aElement.appendChild(currVal);
        }
    }

    public static void encodeBoolean(Document aDocument, Element aRoot, Boolean aBoolean, String aNS, String aTagName) throws EPPEncodeException {
        if (aBoolean != null) {
            Element currElm = aDocument.createElementNS(aNS, aTagName);
            String xmlValue = aBoolean != false ? "1" : "0";
            Text currVal = aDocument.createTextNode(xmlValue);
            currElm.appendChild(currVal);
            aRoot.appendChild(currElm);
        }
    }

    public static void encodeBooleanAttr(Element aElement, String aAttr, boolean aVal) {
        if (aVal) {
            aElement.setAttribute(aAttr, "1");
        } else {
            aElement.setAttribute(aAttr, "0");
        }
    }

    public static void encodeComp(Document aDocument, Element aRoot, EPPCodecComponent aComp) throws EPPEncodeException {
        if (aComp != null) {
            aRoot.appendChild(aComp.encode(aDocument));
        }
    }

    public static void encodeCompList(Document aDocument, Element aRoot, List aList) throws EPPEncodeException {
        if (aList != null) {
            for (EPPCodecComponent currComp : aList) {
                aRoot.appendChild(currComp.encode(aDocument));
            }
        }
    }

    public static void encodeCompVector(Document aDocument, Element aRoot, Vector aVector) throws EPPEncodeException {
        if (aVector != null) {
            Enumeration elms = aVector.elements();
            while (elms.hasMoreElements()) {
                EPPCodecComponent currComp = (EPPCodecComponent)elms.nextElement();
                aRoot.appendChild(currComp.encode(aDocument));
            }
        }
    }

    public static String encodeDate(Date aDate) {
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        formatter.setTimeZone(utcTimeZone);
        return formatter.format(aDate);
    }

    public static void encodeDate(Document aDocument, Element aRoot, Date aDate, String aNS, String aTagName) throws EPPEncodeException {
        if (aDate != null) {
            EPPUtil.encodeString(aDocument, aRoot, EPPUtil.encodeDate(aDate), aNS, aTagName);
        }
    }

    public static void encodeList(Document aDocument, Element aRoot, List aList, String aNS, String aTagName) throws EPPEncodeException {
        if (aList != null) {
            Iterator elms = aList.iterator();
            while (elms.hasNext()) {
                Element currElm = aDocument.createElementNS(aNS, aTagName);
                Text currVal = aDocument.createTextNode(elms.next().toString());
                currElm.appendChild(currVal);
                aRoot.appendChild(currElm);
            }
        }
    }

    public static void encodeNill(Document aDocument, Element aRoot, String aNS, String aTagName) throws EPPEncodeException {
        Element localElement = aDocument.createElementNS(aNS, aTagName);
        localElement.setAttribute("xsi:nil", "true");
        aRoot.appendChild(localElement);
    }

    public static void encodeString(Document aDocument, Element aRoot, String aString, String aNS, String aTagName) throws EPPEncodeException {
        if (aString != null) {
            Element currElm = aDocument.createElementNS(aNS, aTagName);
            Text currVal = aDocument.createTextNode(aString);
            currElm.appendChild(currVal);
            aRoot.appendChild(currElm);
        }
    }

    public static void encodeStringList(Document aDocument, Element aRoot, List aList, String aNS, String aTagName) {
        if (aList != null) {
            for (String aString : aList) {
                Element aElement = aDocument.createElementNS(aNS, aTagName);
                Text aValue = aDocument.createTextNode(aString);
                aElement.appendChild(aValue);
                aRoot.appendChild(aElement);
            }
        }
    }

    public static String encodeTimeInstant(Date aDate) {
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat formatter = new SimpleDateFormat(timeInstantFormat);
        formatter.setTimeZone(utcTimeZone);
        return formatter.format(aDate);
    }

    public static void encodeTimeInstant(Document aDocument, Element aRoot, Date aDate, String aNS, String aTagName) throws EPPEncodeException {
        if (aDate != null) {
            EPPUtil.encodeString(aDocument, aRoot, EPPUtil.encodeTimeInstant(aDate), aNS, aTagName);
        }
    }

    public static void encodeVector(Document aDocument, Element aRoot, Vector aVector, String aNS, String aTagName) throws EPPEncodeException {
        if (aVector != null) {
            Enumeration elms = aVector.elements();
            while (elms.hasMoreElements()) {
                Element currElm = aDocument.createElementNS(aNS, aTagName);
                Text currVal = aDocument.createTextNode(elms.nextElement().toString());
                currElm.appendChild(currVal);
                aRoot.appendChild(currElm);
            }
        }
    }

    public static boolean equalLists(List aV1, List aV2) {
        if (aV1 == null && aV2 == null) {
            return true;
        }
        if (aV1 != null && aV2 != null) {
            if (aV1.size() != aV2.size()) {
                return false;
            }
            Iterator v1Iter = aV1.iterator();
            Iterator v2Iter = aV2.iterator();
            for (int i = 0; i < aV1.size(); ++i) {
                Object elm1 = v1Iter.next();
                Object elm2 = v2Iter.next();
                if (elm1 != null ? elm1.equals(elm2) : elm2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equalVectors(Vector aV1, Vector aV2) {
        if (aV1 == null && aV2 == null) {
            return true;
        }
        if (aV1 != null && aV2 != null) {
            if (aV1.size() != aV2.size()) {
                return false;
            }
            for (int i = 0; i < aV1.size(); ++i) {
                Object elm1 = aV1.elementAt(i);
                Object elm2 = aV2.elementAt(i);
                if (elm1 != null ? elm1.equals(elm2) : elm2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Element getElementByTagNameNS(Element aElement, String aNS, String aTagName) {
        Element retElm = null;
        aTagName = EPPUtil.getLocalName(aTagName);
        NodeList theNodes = aElement.getChildNodes();
        if (theNodes != null) {
            for (int i = 0; i < theNodes.getLength() && retElm == null; ++i) {
                Element currElm;
                if (theNodes.item(i).getNodeType() != 1 || !(currElm = (Element)theNodes.item(i)).getNamespaceURI().equals(aNS) || !currElm.getLocalName().equals(aTagName)) continue;
                retElm = currElm;
            }
        }
        return retElm;
    }

    public static Vector getElementsByTagNameNS(Element aElement, String aNS, String aTagName) {
        Vector<Node> retVal = new Vector<Node>();
        aTagName = EPPUtil.getLocalName(aTagName);
        NodeList theNodes = aElement.getChildNodes();
        if (theNodes != null) {
            for (int i = 0; i < theNodes.getLength(); ++i) {
                Element currElm;
                if (theNodes.item(i).getNodeType() != 1 || !(currElm = (Element)theNodes.item(i)).getNamespaceURI().equals(aNS) || !currElm.getLocalName().equals(aTagName)) continue;
                retVal.add(theNodes.item(i));
            }
        }
        return retVal;
    }

    public static String getLocalName(String aQualifiedName) {
        if (aQualifiedName.indexOf(58) != -1) {
            aQualifiedName = aQualifiedName.substring(aQualifiedName.indexOf(58) + 1);
        }
        return aQualifiedName;
    }

    public static String getPrefix(String aQualifiedName) {
        String prefix = "";
        if (aQualifiedName.indexOf(58) != -1) {
            prefix = aQualifiedName.substring(0, aQualifiedName.indexOf(58));
        }
        return prefix;
    }

    public static Element getFirstElementChild(Element aElement) {
        NodeList children = aElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            return (Element)children.item(i);
        }
        return null;
    }

    public static Element getNextElementSibling(Element aElement) {
        Element theSibling = null;
        Node theCurrNode = aElement;
        while (theCurrNode != null && theSibling == null) {
            if ((theCurrNode = theCurrNode.getNextSibling()) == null || theCurrNode.getNodeType() != 1) continue;
            theSibling = (Element)theCurrNode;
        }
        return theSibling;
    }

    public static String getTextContent(Node node) throws EPPDecodeException {
        return EPPUtil.getTextContent(node, false);
    }

    public static String getTextContent(Node node, boolean allowEmpty) throws EPPDecodeException {
        String value;
        Node child;
        if (node != null && (child = node.getFirstChild()) != null && (value = child.getNodeValue()) != null && (value = value.trim()).length() > 0) {
            return value;
        }
        if (allowEmpty) {
            return "";
        }
        throw new EPPDecodeException("Empty tag encountered during decode");
    }

    public static boolean listSubset(List aV1, List aV2) {
        Iterator v1Iter = aV1.iterator();
        while (v1Iter.hasNext()) {
            if (aV2.contains(v1Iter.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(EPPCodecComponent aComponent) {
        String ret = "ERROR";
        try {
            DocumentImpl document = new DocumentImpl();
            Element elm = aComponent.encode(document);
            ret = EPPUtil.toString(elm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static String toString(Element aElement) {
        String ret = "ERROR";
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        try {
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(aElement), new StreamResult(theBuffer));
            theBuffer.close();
            ret = new String(theBuffer.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static String toStringNoIndent(Element aElement) {
        String ret = "ERROR";
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        try {
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(aElement), new StreamResult(theBuffer));
            theBuffer.close();
            ret = new String(theBuffer.toByteArray());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public static boolean vectorSubset(Vector aV1, Vector aV2) {
        Enumeration v1Enum = aV1.elements();
        while (v1Enum.hasMoreElements()) {
            if (aV2.contains(v1Enum.nextElement())) continue;
            return false;
        }
        return true;
    }

    public static List decodeIntegerList(Element aElement, String aNS, String aTagName) throws EPPDecodeException {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, aNS, aTagName);
        for (int i = 0; i < theChildren.size(); ++i) {
            Element currChild = (Element)theChildren.elementAt(i);
            Integer retInteger = null;
            Node textNode = currChild.getFirstChild();
            if (textNode != null) {
                String intValStr = textNode.getNodeValue();
                try {
                    retInteger = Integer.valueOf(intValStr);
                }
                catch (NumberFormatException e) {
                    throw new EPPDecodeException("EPPUtil.decodeIntegerList Can't convert value to Integer: " + intValStr + e);
                }
            } else {
                throw new EPPDecodeException("EPPUtil.decodeIntegerList Can't decode numeric value from non-existant text node");
            }
            retVal.add(retInteger);
        }
        return retVal;
    }

    public static void encodeIntegerList(Document aDocument, Element aRoot, List aList, String aNS, String aTagName) throws EPPEncodeException {
        if (aList != null) {
            Iterator elms = aList.iterator();
            while (elms.hasNext()) {
                Element currElm = aDocument.createElementNS(aNS, aTagName);
                Text currVal = aDocument.createTextNode(elms.next().toString());
                currElm.appendChild(currVal);
                aRoot.appendChild(currElm);
            }
        }
    }

    public static String collapseWhitespace(String inString) {
        if (inString == null) {
            return null;
        }
        String s = inString.trim();
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        boolean prevWhitespace = true;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
                prevWhitespace = false;
                continue;
            }
            if (prevWhitespace) continue;
            sb.append(' ');
            prevWhitespace = true;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static String removeWhitespace(String inString) {
        if (inString == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int len = inString.length();
        for (int i = 0; i < len; ++i) {
            char c = inString.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static String encodeBase64(Element aElement) throws Exception {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TransformerFactory transFac = TransformerFactory.newInstance();
        Transformer trans = transFac.newTransformer();
        trans.transform(new DOMSource(aElement), new StreamResult(ostream));
        return new String(Base64.encodeBase64((byte[])ostream.toByteArray(), (boolean)true));
    }
}

