/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v06;

import com.verisign.epp.codec.fee.v06.EPPFeeCommand;
import com.verisign.epp.codec.fee.v06.EPPFeePeriod;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeInfo
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "fee:info";
    private static Logger cat = Logger.getLogger((String)EPPFeeInfo.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period;

    public EPPFeeInfo() {
    }

    public EPPFeeInfo(EPPFeeCommand aCommand) {
        this.setCommand(aCommand);
    }

    public EPPFeeInfo(String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod) {
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeInfo.encode(Document)");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeInfo.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.6", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.6", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeComp(aDocument, root, this.period);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.6", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.6", "fee:command", EPPFeeCommand.class);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.6", "fee:period", EPPFeePeriod.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeInfo clone = (EPPFeeInfo)super.clone();
        clone.currency = this.currency;
        clone.command = this.command == null ? null : (EPPFeeCommand)this.command.clone();
        clone.period = this.period == null ? null : (EPPFeePeriod)this.period.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeInfo)) {
            cat.error((Object)("EPPFeeInfo.equals(): " + aObject.getClass().getName() + " not EPPFeeInfo instance"));
            return false;
        }
        EPPFeeInfo other = (EPPFeeInfo)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeInfo.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeInfo.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeInfo.equals(): period not equal");
            return false;
        }
        return true;
    }
}

