/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.management;

import com.codestudio.management.PoolManConfiguration;
import com.codestudio.management.PoolManDeployer;
import com.codestudio.util.GenericPoolManager;
import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.JDBCPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.SQLManager;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class LocalPoolDeployer
implements PoolManDeployer,
Runnable {
    static /* synthetic */ Class class$java$lang$Thread;

    public void deployConfiguration(PoolManConfiguration poolManConfiguration) throws Exception {
        this.startDataSources(poolManConfiguration.getDataSources());
        this.startGenericPools(poolManConfiguration.getGenericPools());
        try {
            Class<?> clazz = Runtime.getRuntime().getClass();
            Method method = clazz.getDeclaredMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = LocalPoolDeployer.class$("java.lang.Thread")) : class$java$lang$Thread);
            method.invoke((Object)Runtime.getRuntime(), new Thread(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            SQLManager.getInstance().destroyPools();
            GenericPoolManager.getInstance().destroyPools();
        }
        catch (Exception exception) {
            System.out.println("Unable to properly shutdown: " + exception);
        }
    }

    private void startDataSources(ArrayList arrayList) throws Exception {
        if (arrayList == null) {
            return;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object object;
            Properties properties = (Properties)iterator.next();
            JDBCPoolMetaData jDBCPoolMetaData = new JDBCPoolMetaData();
            BeanInfo beanInfo = Introspector.getBeanInfo(jDBCPoolMetaData.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                object = propertyDescriptorArray[n].getName();
                if (((Hashtable)properties).containsKey(((String)object).toLowerCase())) {
                    String string = properties.getProperty(((String)object).toLowerCase());
                    Class<?> clazz = propertyDescriptorArray[n].getPropertyType();
                    PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
                    propertyEditor.setAsText(string);
                    Object object2 = propertyEditor.getValue();
                    propertyDescriptorArray[n].getWriteMethod().invoke((Object)jDBCPoolMetaData, object2);
                }
                ++n;
            }
            object = SQLManager.getInstance().createPool(jDBCPoolMetaData);
            ((ObjectPool)object).log("PoolMan Local Pool Deployer: Created JDBC Connection Pool named: " + jDBCPoolMetaData.getDbname());
        }
    }

    private void startGenericPools(ArrayList arrayList) throws Exception {
        if (arrayList == null) {
            return;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            Object object;
            Properties properties = (Properties)iterator.next();
            GenericPoolMetaData genericPoolMetaData = new GenericPoolMetaData();
            BeanInfo beanInfo = Introspector.getBeanInfo(genericPoolMetaData.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                object = propertyDescriptorArray[n].getName();
                if (((Hashtable)properties).containsKey(((String)object).toLowerCase())) {
                    String string = properties.getProperty(((String)object).toLowerCase());
                    Class<?> clazz = propertyDescriptorArray[n].getPropertyType();
                    PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
                    propertyEditor.setAsText(string);
                    Object object2 = propertyEditor.getValue();
                    propertyDescriptorArray[n].getWriteMethod().invoke((Object)genericPoolMetaData, object2);
                }
                ++n;
            }
            object = GenericPoolManager.getInstance().createPool(genericPoolMetaData);
            ((ObjectPool)object).log("PoolMan Local Pool Deployer: Created Object Pool Named: " + genericPoolMetaData.getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

