/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.sql;

import com.codestudio.sql.PoolManConnection;
import com.codestudio.sql.PoolManResultSet;
import com.codestudio.sql.PoolManResultSetMetaData;
import com.codestudio.sql.Result;
import com.codestudio.util.JDBCPool;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PooledObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class PoolManStatement
implements Statement,
PooledObject {
    private Statement statement;
    protected String sqlString;
    protected ResultSet lastRS;
    protected WeakHashMap openres;
    protected JDBCPool mypool;
    protected PoolManConnection poolmanCon;
    protected boolean closed = false;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;

    public PoolManStatement(PoolManConnection poolManConnection, Statement statement, ObjectPool objectPool) {
        this.poolmanCon = poolManConnection;
        this.statement = statement;
        this.mypool = (JDBCPool)objectPool;
        this.openres = new WeakHashMap();
    }

    public Statement getNativeStatement() {
        return this.statement;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    public void closeAllResources() {
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void clean() {
        Iterator iterator = ((AbstractMap)this.openres).keySet().iterator();
        while (iterator.hasNext()) {
            JDBCPool.closeResultSet((ResultSet)iterator.next());
        }
    }

    public void removeOpenResultSet(ResultSet resultSet) {
        if (this.openres.containsKey(resultSet)) {
            this.openres.remove(resultSet);
        }
    }

    public ObjectPool getPool() {
        return this.mypool;
    }

    public Connection getConnection() throws SQLException {
        return this.mypool.requestConnection();
    }

    public String getSQL() {
        return this.sqlString;
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet executeQuery(String var1_1) throws SQLException {
        block22: {
            this.sqlString = var1_1;
            var2_2 = new ArrayList<Object>();
            var3_3 = null;
            if (this.mypool.usingCache()) {
                var4_4 = null;
                var5_5 = this.mypool.getCache();
                try {
                    var4_4 = (PoolManResultSet)var5_5.getResult(var1_1);
                }
                catch (Exception var6_9) {
                    // empty catch block
                }
                if (var4_4 != null) {
                    this.mypool.debug("Statement: Returning cached result");
                    var4_4.setScrollableType(this.resultSetType);
                    var4_4.setConcurrencyType(this.resultSetConcurrency);
                    this.openres.put(var4_4, null);
                    this.lastRS = var4_4;
                    return var4_4;
                }
            }
            var3_3 = this.statement.executeQuery(var1_1);
            if (this.mypool.isUsingNativeResults()) {
                this.openres.put(var3_3, null);
                this.lastRS = var3_3;
                return var3_3;
            }
            var4_4 = PoolManResultSetMetaData.getCopy(var3_3.getMetaData());
            try {
                var5_6 = var4_4.getColumnCount();
                var6_10 = new String[var5_6];
                var7_11 = 0;
                while (var7_11 < var5_6) {
                    var8_12 = null;
                    try {
                        var8_12 = var4_4.getTableName(var7_11);
                        if (var8_12.trim().length() == 0) {
                            var8_12 = null;
                        }
                    }
                    catch (Exception var9_13) {
                        var8_12 = null;
                    }
                    if (var8_12 == null) {
                        var8_12 = this.fabricateTableName(var1_1, var7_11);
                    }
                    var6_10[var7_11] = var8_12;
                    ++var7_11;
                }
                while (var3_3.next()) {
                    var8_12 = new ArrayList<E>();
                    var9_14 = 1;
                    while (var9_14 <= var5_6) {
                        var10_15 = new Result(var6_10[var9_14 - 1], var4_4.getColumnLabel(var9_14), var3_3.getObject(var9_14), var4_4.getColumnType(var9_14));
                        var8_12.add(var10_15);
                        ++var9_14;
                    }
                    var2_2.add(var8_12);
                }
                var12_16 = null;
                ** if (null == var3_3) goto lbl-1000
            }
            catch (Throwable var11_20) {
                var12_17 = null;
                if (null != var3_3) {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var13_19) {
                        // empty catch block
                    }
                }
                throw var11_20;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (Exception var13_18) {}
            }
lbl-1000:
            // 2 sources

            {
                break block22;
                catch (Exception var5_7) {
                    this.mypool.debug("Exception while attempting a SQL operation", var5_7);
                    throw new SQLException(var5_7.getMessage());
                }
            }
        }
        var5_8 = new PoolManResultSet(this, var2_2, (ResultSetMetaData)var4_4, this.resultSetType, this.resultSetConcurrency);
        this.openres.put(var5_8, null);
        this.lastRS = var5_8;
        if (this.mypool.usingCache() && var2_2.size() > 0) {
            var6_10 = this.mypool.getCache();
            var6_10.cacheResult(var1_1, var5_8);
        }
        return var5_8;
    }

    public String fabricateTableName(String string, int n) {
        String string2 = null;
        try {
            string = string.trim().toLowerCase();
            String string3 = string.substring(string.indexOf("from"));
            if (string3.indexOf("where") != -1) {
                string3 = string3.substring(0, string3.indexOf("where"));
            }
            if ((string3 = string3.substring(4).trim()).indexOf(",") == -1) {
                string2 = string3;
            } else {
                String string4 = string.substring(string.indexOf("select"));
                if (string4.indexOf("from") != -1) {
                    string4 = string4.substring(0, string4.indexOf("from"));
                }
                string4 = string4.substring(6).trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                int n2 = 1;
                if (stringTokenizer.hasMoreTokens()) {
                    while (n2 < n) {
                        stringTokenizer.nextToken();
                        ++n2;
                    }
                    String string5 = stringTokenizer.nextToken();
                    string2 = string5.substring(0, string5.indexOf(46)).trim();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public int executeUpdate(String string) throws SQLException {
        this.sqlString = string;
        return this.statement.executeUpdate(string);
    }

    public void close() throws SQLException {
        this.clean();
        this.statement.close();
        this.poolmanCon.removeOpenStatement(this);
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.statement.setMaxFieldSize(n);
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public void setMaxRows(int n) throws SQLException {
        this.statement.setMaxRows(n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.statement.setEscapeProcessing(bl);
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.statement.setQueryTimeout(n);
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.statement.setCursorName(string);
    }

    public boolean execute(String string) throws SQLException {
        this.sqlString = string.toLowerCase();
        if (this.sqlString.indexOf("select") != -1) {
            this.executeQuery(string);
            return true;
        }
        return this.statement.execute(string);
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.lastRS != null) {
            return this.lastRS;
        }
        return this.statement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public void setFetchDirection(int n) throws SQLException {
        this.statement.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        this.statement.setFetchSize(n);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public void addBatch(String string) throws SQLException {
        this.statement.addBatch(string);
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public String toString() {
        return "PoolManStatement-[UnderlyingStatement:" + this.statement.toString() + "]";
    }
}

