/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.framework.EPPPollDataRecord;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueException;

public class NSPollHandler
implements EPPPollHandler {
    public static final String KIND = "NSPollHandler";

    @Override
    public String getKind() {
        return KIND;
    }

    @Override
    public EPPResponse toResponse(EPPPollDataRecord aRecord) throws EPPPollQueueException {
        if (!aRecord.getKind().equals(this.getKind())) {
            throw new EPPPollQueueException("Handler for kind " + aRecord.getKind() + " does not match");
        }
        EPPResponse theResponse = (EPPResponse)aRecord.getData();
        if (theResponse instanceof EPPDomainTransferResp) {
            String theStatus = ((EPPDomainTransferResp)theResponse).getTransferStatus();
            String theDesc = "Undefined";
            if (theStatus.equals("pending")) {
                theDesc = "Transfer Requested.";
            } else if (theStatus.equals("clientApproved")) {
                theDesc = "Transfer Approved.";
            } else if (theStatus.equals("clientCancelled")) {
                theDesc = "Transfer Cancelled.";
            } else if (theStatus.equals("clientRejected")) {
                theDesc = "Transfer Rejected.";
            } else if (theStatus.equals("serverApproved")) {
                theDesc = "Transfer Auto Approved.";
            } else if (theStatus.equals("serverCancelled")) {
                theDesc = "Transfer Auto Rejected.";
            }
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), theDesc));
        } else if (theResponse instanceof EPPContactTransferResp) {
            String theStatus = ((EPPContactTransferResp)theResponse).getTransferStatus();
            String theDesc = "Undefined";
            if (theStatus.equals("pending")) {
                theDesc = "Transfer Requested.";
            } else if (theStatus.equals("clientApproved")) {
                theDesc = "Transfer Approved.";
            } else if (theStatus.equals("clientCancelled")) {
                theDesc = "Transfer Cancelled.";
            } else if (theStatus.equals("clientRejected")) {
                theDesc = "Transfer Rejected.";
            } else if (theStatus.equals("serverApproved")) {
                theDesc = "Transfer Auto Approved.";
            } else if (theStatus.equals("serverCancelled")) {
                theDesc = "Transfer Auto Rejected.";
            }
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), theDesc));
        } else if (theResponse instanceof EPPDomainPendActionMsg) {
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Pending action completed successfully."));
        } else if (theResponse instanceof EPPLowBalancePollResponse) {
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Low Account Balance (SRS)"));
        } else if (theResponse instanceof EPPRgpPollResponse) {
            theResponse.setMsgQueue(new EPPMsgQueue(new Long(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Restore Request Pending"));
        } else {
            throw new EPPPollQueueException("Unable to handle message class <" + theResponse.getClass().getName());
        }
        theResponse.setResult(1301);
        return theResponse;
    }
}

