/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.interfaces;

import com.verisign.epp.codec.coaext.EPPCoaExtCreate;
import com.verisign.epp.codec.coaext.EPPCoaExtUpdate;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import com.verisign.epp.codec.namestoreext.EPPNamestoreExtNamestoreExt;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtRestore;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtUpdate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.syncext.EPPSyncExtUpdate;
import com.verisign.epp.codec.whois.EPPWhoisInf;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPRelatedDomain;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;

public class NSDomain
extends EPPRelatedDomain {
    private EPPRgpExtReport report = null;
    private int month = -1;
    private int day = -1;
    public static final List REM_ALL_DS = new ArrayList();

    public NSDomain(EPPSession aSession) {
        super(aSession);
    }

    public EPPResponse sendRestoreRequest() throws EPPCommandException {
        super.addExtension(new EPPRgpExtUpdate(new EPPRgpExtRestore()));
        return super.sendUpdate();
    }

    public EPPResponse sendRestoreReport() throws EPPCommandException {
        if (this.report == null) {
            throw new EPPCommandException("Report is required for sendRestoreReport()");
        }
        super.addExtension(new EPPRgpExtUpdate(new EPPRgpExtRestore(this.report)));
        return super.sendUpdate();
    }

    public EPPResponse sendSync() throws EPPCommandException {
        if (this.month < 0 || this.month > 11) {
            throw new EPPCommandException("Month " + this.month + " is invalid value for sendRestoreReport()");
        }
        if (this.day < 1 || this.day > 31) {
            throw new EPPCommandException("Day " + this.day + " is invalid value for sendRestoreReport()");
        }
        super.addExtension(new EPPSyncExtUpdate(this.month, this.day));
        return super.sendUpdate();
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int aDay) {
        this.day = aDay;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int aMonth) {
        this.month = aMonth;
    }

    public EPPRgpExtReport getReport() {
        return this.report;
    }

    public void setReport(EPPRgpExtReport aReport) {
        this.report = aReport;
    }

    public void setIDNLangTag(String aLangTag) {
        super.addExtension(new EPPIdnLangTag(aLangTag));
    }

    public void setSubProductID(String aSubProductID) {
        if (aSubProductID != null) {
            super.addExtension(new EPPNamestoreExtNamestoreExt(aSubProductID));
        }
    }

    public void setWhoisInfo(boolean aWhoisInfo) {
        super.addExtension(new EPPWhoisInf(aWhoisInfo));
    }

    public void setSecDNSUpdate(List aAddDsData, List aRemDsData) throws EPPCommandException {
        if (aAddDsData != null && !aAddDsData.isEmpty() && !(aAddDsData.get(0) instanceof EPPSecDNSExtDsData)) {
            throw new EPPCommandException("NSDomain.setSecDNSUpdate: Invalid aAddDsData element of type = " + aAddDsData.get(0).getClass().getName());
        }
        if (aRemDsData != REM_ALL_DS && aRemDsData != null && !aRemDsData.isEmpty() && !(aRemDsData.get(0) instanceof EPPSecDNSExtDsData)) {
            throw new EPPCommandException("NSDomain.setSecDNSUpdate: Invalid aRemDsData element of type = " + aRemDsData.get(0).getClass().getName());
        }
        com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate theExt = new com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate();
        theExt.setAddDsData(aAddDsData);
        if (aRemDsData == REM_ALL_DS) {
            theExt.setRemAllData(true);
        } else {
            theExt.setRemDsData(aRemDsData);
        }
        super.addExtension(theExt);
    }

    public void setSecDNSCreate(List aDsData) {
        if (aDsData != null && !aDsData.isEmpty()) {
            if (aDsData.get(0) instanceof com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData) {
                super.addExtension(new com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate(aDsData));
            } else if (aDsData.get(0) instanceof EPPSecDNSExtDsData) {
                EPPSecDNSExtCreate theExt = new EPPSecDNSExtCreate();
                theExt.setDsData(aDsData);
                super.addExtension(theExt);
            }
        }
    }

    public void setCoaCreate(List aAttrs) {
        if (aAttrs != null && !aAttrs.isEmpty()) {
            super.addExtension(new EPPCoaExtCreate(aAttrs));
        }
    }

    public void setCoaUpdateForPut(List aAttrs) {
        if (aAttrs != null && !aAttrs.isEmpty()) {
            EPPCoaExtUpdate update = new EPPCoaExtUpdate();
            update.setPutAttrs(aAttrs);
            super.addExtension(update);
        }
    }

    public void setCoaUpdateForRem(List aKeys) {
        if (aKeys != null && !aKeys.isEmpty()) {
            EPPCoaExtUpdate update = new EPPCoaExtUpdate();
            update.setRemAttrs(aKeys);
            super.addExtension(update);
        }
    }

    public void setSecDNSUpdateForAdd(List aAddDsData, boolean aUrgent) {
        if (aAddDsData != null && !aAddDsData.isEmpty()) {
            if (aAddDsData.get(0) instanceof com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData) {
                EPPSecDNSExtUpdate theExt = new EPPSecDNSExtUpdate();
                theExt.setAdd(aAddDsData);
                theExt.setUrgent(aUrgent);
                super.addExtension(theExt);
            } else if (aAddDsData.get(0) instanceof EPPSecDNSExtDsData) {
                com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate theExt = new com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate();
                theExt.setAddDsData(aAddDsData);
                theExt.setUrgent(aUrgent);
                super.addExtension(theExt);
            }
        }
    }

    public void setSecDNSUpdateForChg(List aChgDsData, boolean aUrgent) {
        if (aChgDsData.get(0) instanceof com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData) {
            EPPSecDNSExtUpdate updateExt = new EPPSecDNSExtUpdate(null, aChgDsData, null);
            updateExt.setUrgent(aUrgent);
            super.addExtension(updateExt);
        }
    }

    public void setSecDNSUpdateForRem(List aRemDsData, boolean aUrgent) {
        if (aRemDsData != null && !aRemDsData.isEmpty()) {
            if (aRemDsData.get(0) instanceof Integer) {
                EPPSecDNSExtUpdate theExt = new EPPSecDNSExtUpdate();
                theExt.setRem(aRemDsData);
                theExt.setUrgent(aUrgent);
                super.addExtension(theExt);
            } else if (aRemDsData.get(0) instanceof EPPSecDNSExtDsData) {
                com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate theExt = new com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate();
                theExt.setRemDsData(aRemDsData);
                theExt.setUrgent(aUrgent);
                super.addExtension(theExt);
            }
        }
    }

    @Override
    protected void resetDomain() {
        super.resetDomain();
        this.day = -1;
        this.month = -1;
        this.report = null;
    }
}

