/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainMapFactory;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPDomainHandler
implements EPPEventHandler {
    private static final String NS = "urn:ietf:params:xml:ns:domain-1.0";
    private static final Logger cat = Logger.getLogger((String)EPPDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPDomainHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPDomainMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Domain Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPDomainCreateCmd) {
            response = this.doDomainCreate(aEvent, aData);
        } else if (message instanceof EPPDomainDeleteCmd) {
            response = this.doDomainDelete(aEvent, aData);
        } else if (message instanceof EPPDomainInfoCmd) {
            response = this.doDomainInfo(aEvent, aData);
        } else if (message instanceof EPPDomainCheckCmd) {
            response = this.doDomainCheck(aEvent, aData);
        } else if (message instanceof EPPDomainRenewCmd) {
            response = this.doDomainRenew(aEvent, aData);
        } else if (message instanceof EPPDomainTransferCmd) {
            response = this.doDomainTransfer(aEvent, aData);
        } else if (message instanceof EPPDomainUpdateCmd) {
            response = this.doDomainUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPDomainHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doDomainCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainRenew(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainTransfer(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doDomainUpdate(EPPEvent var1, Object var2);
}

