/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoCmd;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoResp;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.RandomHelper;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPSuggestionTst
extends TestCase {
    private static long numIterations = 100L;

    public EPPSuggestionTst(String name) {
        super(name);
    }

    public void testSuggestionInfo() {
        EPPSuggestionInfoCmd cmd;
        EPPCodecTst.printStart("testSuggestionInfo");
        try {
            int i = 0;
            while ((long)i < numIterations) {
                RandomHelper.reset(i);
                EPPSuggestionInfoCmd cmd2 = RandomHelper.getCommand();
                EPPCodecTst.testEncodeDecode(cmd2);
                EPPSuggestionInfoResp rsp = RandomHelper.getResponse(cmd2.getTransId());
                EPPCodecTst.testEncodeDecode(rsp);
                ++i;
            }
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        try {
            cmd = RandomHelper.getCommand();
            cmd.setLanguage(null);
            System.out.println("cmd with no language set");
            EPPCodecTst.testEncodeDecode(cmd);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        try {
            cmd = RandomHelper.getCommand();
            cmd.setLanguage("ESP");
            System.out.println("cmd with ESP language set");
            EPPCodecTst.testEncodeDecode(cmd);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        try {
            cmd = RandomHelper.getCommand();
            cmd.setLanguage("FRE");
            System.out.println("cmd with FRE language set");
            EPPCodecTst.testEncodeDecode(cmd);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        try {
            cmd = RandomHelper.getCommand();
            cmd.setKey("01234567890123456789012345678901234567890123456789");
            System.out.println("cmd with 01234567890123456789012345678901234567890123456789 key set");
            EPPCodecTst.testEncodeDecode(cmd);
        }
        catch (InvalidValueException e) {
            e.printStackTrace();
        }
        EPPCodecTst.printEnd("testSuggestionInfo");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPSuggestionTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.suggestion.EPPSuggestionMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPSuggestionMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSuggestionTst Thread " + i, EPPSuggestionTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSuggestionTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

