/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.StatusEnum;
import com.verisign.epp.codec.suggestion.util.UnsignedShort;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionRow
implements EPPCodecComponent {
    private static final long serialVersionUID = -4719859288987079953L;
    private static final String ATT_NAME = "name";
    private static final String ATT_SCORE = "score";
    private static final String ATT_STATUS = "status";
    private static final String ATT_SOURCE = "source";
    private static final String ATT_MORELIKETHIS = "morelikethis";
    private static final String ATT_PPCVALUE = "ppcvalue";
    private static final String ATT_UNAME = "uName";
    static final String ELM_NAME = "suggestion:row";
    private String name = null;
    private UnsignedShort score = new UnsignedShort();
    private StatusEnum status = new StatusEnum();
    private String source = null;
    private String moreLikeThis = null;
    private Integer ppcValue = null;
    private String uName = null;

    public EPPSuggestionRow() {
    }

    public EPPSuggestionRow(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public EPPSuggestionRow(String aName, short aScore, String aStatus) throws InvalidValueException {
        this();
        this.setName(aName);
        this.setScore(aScore);
        this.setStatus(aStatus);
    }

    public EPPSuggestionRow(String aName, short aScore, String aStatus, String aUName) throws InvalidValueException {
        this();
        this.setName(aName);
        this.setScore(aScore);
        this.setStatus(aStatus);
        this.setUName(aUName);
    }

    public EPPSuggestionRow(String aName, short aScore, String aStatus, String aSource, String aMoreLikeThis, Integer aPpcValue) throws InvalidValueException {
        this();
        this.setName(aName);
        this.setScore(aScore);
        this.setStatus(aStatus);
        this.setSource(aSource);
        this.setMoreLikeThis(aMoreLikeThis);
        this.setPpcValue(aPpcValue);
    }

    public EPPSuggestionRow(String aName, short aScore, String aStatus, String aSource, String aMoreLikeThis, Integer aPpcValue, String aUName) throws InvalidValueException {
        this();
        this.setName(aName);
        this.setScore(aScore);
        this.setStatus(aStatus);
        this.setSource(aSource);
        this.setMoreLikeThis(aMoreLikeThis);
        this.setPpcValue(aPpcValue);
        this.setUName(aUName);
    }

    public String getMoreLikeThis() {
        return this.moreLikeThis;
    }

    public String getUName() {
        return this.uName;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPpcValue() {
        return this.ppcValue;
    }

    public UnsignedShort getScore() {
        return this.score;
    }

    public String getSource() {
        return this.source;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public boolean isSetMoreLikeThis() {
        return this.moreLikeThis != null && this.moreLikeThis.length() > 0;
    }

    public boolean isSetUName() {
        return this.uName != null && this.uName.length() > 0;
    }

    public boolean isSetSource() {
        return this.source != null && this.source.length() > 0;
    }

    public void setMoreLikeThis(String aMoreLikeThis) {
        this.moreLikeThis = aMoreLikeThis;
    }

    public void setUName(String aUName) {
        this.uName = aUName;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setPpcValue(Integer aPpcValue) {
        this.ppcValue = aPpcValue;
    }

    public void setPpcValue(String aPpcValue) {
        if (aPpcValue != null && aPpcValue.length() > 0) {
            this.ppcValue = new Integer(Integer.parseInt(aPpcValue));
        }
    }

    public void setScore(short aScore) throws InvalidValueException {
        this.score.set(aScore);
    }

    public void setScore(String aScore) throws InvalidValueException {
        this.score.set(aScore);
    }

    public void setScore(UnsignedShort aScore) {
        this.score = aScore;
    }

    public void setSource(String aSource) {
        this.source = aSource;
    }

    public void setStatus(StatusEnum aStatus) {
        this.status = aStatus;
    }

    public void setStatus(String aStatus) throws InvalidValueException {
        this.status.set(aStatus);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionRow)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String tmp;
        this.setName(aElement.getAttribute(ATT_NAME));
        if (this.name == null) {
            ExceptionUtil.missingDuringDecode(ATT_NAME);
        }
        this.setScore(aElement.getAttribute(ATT_SCORE));
        if (!this.score.isSet()) {
            ExceptionUtil.missingDuringDecode(ATT_SCORE);
        }
        this.setStatus(aElement.getAttribute(ATT_STATUS));
        if (!this.status.isSet()) {
            ExceptionUtil.missingDuringDecode(ATT_STATUS);
        }
        if ((tmp = aElement.getAttribute(ATT_SOURCE)) != null && tmp.length() > 0) {
            this.setSource(tmp);
        }
        if ((tmp = aElement.getAttribute(ATT_MORELIKETHIS)) != null && tmp.length() > 0) {
            this.setMoreLikeThis(tmp);
        }
        if ((tmp = aElement.getAttribute(ATT_UNAME)) != null && tmp.length() > 0) {
            this.setUName(tmp);
        }
        this.setPpcValue(aElement.getAttribute(ATT_PPCVALUE));
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.name == null) {
            ExceptionUtil.missingDuringEncode(ATT_NAME);
        }
        if (!this.score.isSet()) {
            ExceptionUtil.missingDuringEncode(ATT_SCORE);
        }
        if (!this.status.isSet()) {
            ExceptionUtil.missingDuringEncode(ATT_STATUS);
        }
        root.setAttribute(ATT_NAME, this.name);
        root.setAttribute(ATT_SCORE, this.score.get() + "");
        root.setAttribute(ATT_STATUS, this.status + "");
        if (this.isSetSource()) {
            root.setAttribute(ATT_SOURCE, this.source);
        }
        if (this.isSetMoreLikeThis()) {
            root.setAttribute(ATT_MORELIKETHIS, this.moreLikeThis);
        }
        if (this.isSetUName()) {
            root.setAttribute(ATT_UNAME, this.uName);
        }
        if (this.ppcValue != null) {
            root.setAttribute(ATT_PPCVALUE, this.ppcValue + "");
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionRow other = (EPPSuggestionRow)o;
            if (!EqualityUtil.equals(this.name, other.name)) {
                return false;
            }
            if (!this.score.equals(other.score)) {
                return false;
            }
            if (!this.status.equals(other.status)) {
                return false;
            }
            if (!EqualityUtil.equals(this.source, other.source)) {
                return false;
            }
            if (!EqualityUtil.equals(this.moreLikeThis, other.moreLikeThis)) {
                return false;
            }
            if (!EqualityUtil.equals(this.uName, other.uName)) {
                return false;
            }
            return EqualityUtil.equals(this.ppcValue, other.ppcValue);
        }
        return false;
    }
}

