/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionAnswer;
import com.verisign.epp.codec.suggestion.EPPSuggestionToken;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionInfoResp
extends EPPResponse {
    private static final long serialVersionUID = -4724121330359790669L;
    private static Logger LOGGER = Logger.getLogger((String)EPPSuggestionInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_ANSWER = "suggestion:answer";
    static final String ELM_NAME = "suggestion:infData";
    private String key = null;
    private String language = "ENG";
    private EPPSuggestionAnswer answer = null;
    private List<EPPSuggestionToken> tokens = new ArrayList<EPPSuggestionToken>();

    public EPPSuggestionInfoResp() {
    }

    public EPPSuggestionInfoResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPSuggestionInfoResp(EPPTransId aTransId, String aKey) {
        super(aTransId);
        this.key = aKey;
    }

    public EPPSuggestionInfoResp(EPPTransId aTransId, String aKey, String aLanguage, List<EPPSuggestionToken> aTokens, EPPSuggestionAnswer aAnswer) {
        super(aTransId);
        this.key = aKey;
        this.setLanguage(aLanguage);
        this.tokens = aTokens;
        this.answer = aAnswer;
    }

    public void addToken(EPPSuggestionToken aToken) throws InvalidValueException {
        if (aToken == null) {
            throw new InvalidValueException((Object)"Cannot add a null Token");
        }
        if (this.tokens == null) {
            this.resetTokens();
        }
        this.tokens.add(aToken);
    }

    public boolean hasAnswer() {
        return this.answer != null;
    }

    public EPPSuggestionAnswer getAnswer() {
        return this.answer;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign-grs.com/epp/suggestion-1.1";
    }

    public boolean hasTokens() {
        return this.tokens != null && this.tokens.size() != 0;
    }

    public List<EPPSuggestionToken> getTokens() {
        return this.tokens;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    public void resetTokens() {
        this.tokens = new ArrayList<EPPSuggestionToken>();
    }

    public void setAnswer(EPPSuggestionAnswer aAnswer) {
        this.answer = aAnswer;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String aLanguage) {
        if (aLanguage == null) {
            this.language = "ENG";
        }
        this.language = aLanguage.toUpperCase();
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        String decodedLanguage;
        this.key = EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:key");
        if (this.key == null) {
            ExceptionUtil.missingDuringDecode("key");
        }
        if ((decodedLanguage = EPPUtil.decodeString(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:language")) == null) {
            decodedLanguage = "ENG";
        }
        this.language = decodedLanguage.toUpperCase();
        this.answer = (EPPSuggestionAnswer)EPPUtil.decodeComp(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", ELM_ANSWER, EPPSuggestionAnswer.class);
        this.tokens = EPPUtil.decodeCompList(aElement, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:token", EPPSuggestionToken.class);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        root.setAttribute("xmlns:suggestion", "http://www.verisign-grs.com/epp/suggestion-1.1");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign-grs.com/epp/suggestion-1.1 suggestion-1.1.xsd");
        if (this.key == null) {
            ExceptionUtil.missingDuringEncode("key");
        }
        EPPUtil.encodeString(aDocument, root, this.key, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:key");
        if (this.language != null && !this.language.equals("ENG")) {
            this.language = this.language.toUpperCase();
            EPPUtil.encodeString(aDocument, root, this.language, "http://www.verisign-grs.com/epp/suggestion-1.1", "suggestion:language");
        }
        EPPUtil.encodeCompList(aDocument, root, this.tokens);
        if (this.answer != null) {
            EPPUtil.encodeComp(aDocument, root, this.answer);
        }
        return root;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionInfoResp)super.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            if (!super.equals(o)) {
                return false;
            }
            EPPSuggestionInfoResp other = (EPPSuggestionInfoResp)o;
            if (!EqualityUtil.equals(this.key, other.key)) {
                LOGGER.error((Object)"EPPSuggestionInfoResp.equals(): key not equal");
                return false;
            }
            if (!EPPUtil.equalLists(this.tokens, other.tokens)) {
                LOGGER.error((Object)"EPPSuggestionInfoResp.equals(): tokens not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.answer, other.answer)) {
                LOGGER.error((Object)"EPPSuggestionInfoResp.equals(): answer not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.language, other.language)) {
                LOGGER.error((Object)"EPPSuggestionInfoResp.equals(): language not equal");
                return false;
            }
            return true;
        }
        return false;
    }
}

