/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtRestore;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpExtUpdate
implements EPPCodecComponent {
    public static final String ELM_NAME = "rgp:update";
    private static Logger cat = Logger.getLogger((String)EPPRgpExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPRgpExtRestore restore;

    public EPPRgpExtUpdate() {
    }

    public EPPRgpExtUpdate(EPPRgpExtRestore aRestore) {
        this.restore = aRestore;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRgpExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPRgpExtUpdate invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtUpdate.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        root.setAttribute("xmlns:rgp", "urn:ietf:params:xml:ns:rgp-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:rgp-1.0 rgp-1.0.xsd");
        EPPUtil.encodeComp(aDocument, root, this.restore);
        return root;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:rgp-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtUpdate)) {
            return false;
        }
        EPPRgpExtUpdate theComp = (EPPRgpExtUpdate)aObject;
        return this.restore != null ? this.restore.equals(theComp.restore) : theComp.restore == null;
    }

    void validateState() throws EPPCodecException {
        if (this.restore == null) {
            throw new EPPCodecException("EPPRgpExtStatus required attribute is not set [restore]");
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.restore = (EPPRgpExtRestore)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "rgp:restore", EPPRgpExtRestore.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtUpdate clone = null;
        clone = (EPPRgpExtUpdate)super.clone();
        clone.setRestore((EPPRgpExtRestore)this.restore.clone());
        return clone;
    }

    public EPPRgpExtRestore getRestore() {
        return this.restore;
    }

    public void setRestore(EPPRgpExtRestore aRestore) {
        this.restore = aRestore;
    }
}

